/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.jwtheaders.token;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.nimbusds.jose.JWSObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.TimeUnit;
import org.geoserver.security.jwtheaders.JwtConfiguration;
import org.geoserver.security.jwtheaders.username.JwtHeaderUserNameExtractor;

public class TokenEndpointValidator {
    JwtConfiguration jwtHeadersConfig;
    public static Cache<Object, Object> validEndpoints = CacheBuilder.newBuilder().maximumSize(50000L).expireAfterWrite(1L, TimeUnit.HOURS).build();

    public TokenEndpointValidator(JwtConfiguration config) {
        this.jwtHeadersConfig = config;
    }

    public void validate(String accessToken) throws Exception {
        if (!this.jwtHeadersConfig.isValidateTokenAgainstURL()) {
            return;
        }
        if (validEndpoints.getIfPresent((Object)accessToken) != null) {
            return;
        }
        this.validateEndpoint(accessToken);
        validEndpoints.put((Object)accessToken, (Object)Boolean.TRUE);
    }

    public void validateEndpoint(String accessToken) throws Exception {
        URL url = new URL(this.jwtHeadersConfig.getValidateTokenAgainstURLEndpoint());
        String result = this.download(url, accessToken);
        if (result == null) {
            throw new Exception("ValidateTokenAgainstURLEndpoint - failed");
        }
        this.validateSubject(accessToken, result);
    }

    private void validateSubject(String accessToken, String result) throws Exception {
        if (!this.jwtHeadersConfig.isValidateSubjectWithEndpoint()) {
            return;
        }
        JWSObject jwsToken = JWSObject.parse((String)accessToken);
        String subject_userinfo = (String)JwtHeaderUserNameExtractor.extractFromJSON(result, "sub");
        String subject_accesstoken = (String)jwsToken.getPayload().toJSONObject().get("sub");
        if (subject_userinfo == null || subject_accesstoken == null) {
            throw new Exception("couldn't extract subject from token or userinfo");
        }
        if (!subject_userinfo.equals(subject_accesstoken)) {
            throw new Exception("subject of token and userinfo dont match");
        }
    }

    public String download(URL url, String accessToken) throws IOException {
        URLConnection connection = url.openConnection();
        HttpURLConnection httpConn = (HttpURLConnection)connection;
        httpConn.setRequestProperty("Authorization", "Bearer " + accessToken);
        int responseCode = httpConn.getResponseCode();
        if (responseCode == 200) {
            String data = this.readStream(httpConn.getInputStream());
            return data;
        }
        return null;
    }

    private String readStream(InputStream inputStream) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String nextLine = "";
            while ((nextLine = reader.readLine()) != null) {
                sb.append(nextLine + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }
}

