/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.jwtheaders.token;

import com.nimbusds.jose.JWSObject;
import java.util.List;
import org.geoserver.security.jwtheaders.JwtConfiguration;
import org.geoserver.security.jwtheaders.roles.JwtHeadersRolesExtractor;

public class TokenAudienceValidator {
    JwtConfiguration jwtHeadersConfig;

    public TokenAudienceValidator(JwtConfiguration config) {
        this.jwtHeadersConfig = config;
    }

    public void validate(JWSObject jwsToken) throws Exception {
        if (!this.jwtHeadersConfig.isValidateTokenAudience()) {
            return;
        }
        String aud_claimName = this.jwtHeadersConfig.getValidateTokenAudienceClaimName();
        List<String> aud = JwtHeadersRolesExtractor.asStringList(jwsToken.getPayload().toJSONObject().get(aud_claimName));
        if (!aud.contains(this.jwtHeadersConfig.getValidateTokenAudienceClaimValue())) {
            throw new Exception("token audience didn't match");
        }
    }
}

