/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid;

import java.awt.Rectangle;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.api.util.Cloneable;
import org.geotools.coverage.grid.GeneralGridEnvelope;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.geometry.PixelTranslation;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class GridEnvelope2D
extends Rectangle
implements GridEnvelope,
Cloneable {
    private static final long serialVersionUID = -3370515914148690059L;

    public GridEnvelope2D() {
    }

    public GridEnvelope2D(Rectangle rectangle) {
        super(rectangle);
    }

    public GridEnvelope2D(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public GridEnvelope2D(Rectangle envelope, PixelInCell anchor) throws IllegalArgumentException {
        this(envelope, anchor, false);
    }

    public GridEnvelope2D(ReferencedEnvelope envelope, PixelInCell anchor) throws IllegalArgumentException {
        this(envelope, anchor, false);
    }

    public GridEnvelope2D(Rectangle envelope, PixelInCell anchor, boolean isHighIncluded) throws IllegalArgumentException {
        double offset = PixelTranslation.getPixelTranslation(anchor) + 0.5;
        int DIMENSION = 2;
        int[] index = new int[]{(int)Math.round(envelope.getMinX() + offset), (int)Math.round(envelope.getMaxX() + offset), (int)Math.round(envelope.getMinY() + offset), (int)Math.round(envelope.getMaxY() + offset)};
        if (isHighIncluded) {
            index[2] = index[2] + 1;
            index[3] = index[3] + 1;
        }
        this.setLocation(index[0], index[1]);
        this.setSize(index[2] - index[0], index[3] - index[1]);
    }

    public GridEnvelope2D(ReferencedEnvelope envelope, PixelInCell anchor, boolean isHighIncluded) throws IllegalArgumentException {
        int i;
        double offset = PixelTranslation.getPixelTranslation(anchor) + 0.5;
        int dimension = envelope.getDimension();
        assert (dimension == 2);
        int[] index = new int[dimension * 2];
        for (i = 0; i < dimension; ++i) {
            index[i] = (int)Math.round(envelope.getMinimum(i) + offset);
            index[i + dimension] = (int)Math.round(envelope.getMaximum(i) + offset);
        }
        if (isHighIncluded) {
            i = index.length / 2;
            while (i < index.length) {
                int n = i++;
                index[n] = index[n] + 1;
            }
        }
        this.setLocation(index[0], index[1]);
        this.setSize(index[0 + dimension] - index[0], index[1 + dimension] - index[1]);
    }

    public final int getDimension() {
        return 2;
    }

    public GridCoordinates2D getLow() {
        return new GridCoordinates2D(this.x, this.y);
    }

    public GridCoordinates2D getHigh() {
        return new GridCoordinates2D(this.x + this.width - 1, this.y + this.height - 1);
    }

    public int getLow(int dimension) {
        switch (dimension) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new IndexOutOfBoundsException(GridCoordinates2D.indexOutOfBounds(dimension));
    }

    public int getHigh(int dimension) {
        switch (dimension) {
            case 0: {
                return this.x + this.width - 1;
            }
            case 1: {
                return this.y + this.height - 1;
            }
        }
        throw new IndexOutOfBoundsException(GridCoordinates2D.indexOutOfBounds(dimension));
    }

    public int getSpan(int dimension) {
        switch (dimension) {
            case 0: {
                return this.width;
            }
            case 1: {
                return this.height;
            }
        }
        throw new IndexOutOfBoundsException(GridCoordinates2D.indexOutOfBounds(dimension));
    }

    @Override
    public String toString() {
        return GeneralGridEnvelope.toString(this);
    }

    @Override
    public GridEnvelope2D clone() {
        return (GridEnvelope2D)super.clone();
    }
}

