/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem2.collection;

import java.util.ConcurrentModificationException;
import java.util.Spliterator;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.jena.mem2.collection.HashCommonBase;
import org.apache.jena.mem2.collection.JenaMap;
import org.apache.jena.mem2.iterator.SparseArrayIterator;
import org.apache.jena.mem2.spliterator.SparseArraySpliterator;
import org.apache.jena.util.iterator.ExtendedIterator;

public abstract class HashCommonMap<K, V>
extends HashCommonBase<K>
implements JenaMap<K, V> {
    protected V[] values;

    protected HashCommonMap(int initialCapacity) {
        super(initialCapacity);
        this.values = this.newValuesArray(this.keys.length);
    }

    @Override
    public void clear(int initialCapacity) {
        super.clear(initialCapacity);
        this.values = this.newValuesArray(this.keys.length);
    }

    protected abstract V[] newValuesArray(int var1);

    @Override
    public boolean tryPut(K key, V value) {
        int slot = this.findSlot(key);
        if (slot < 0) {
            this.values[slot ^ 0xFFFFFFFF] = value;
            return false;
        }
        this.keys[slot] = key;
        this.values[slot] = value;
        if (++this.size > this.threshold) {
            this.grow();
        }
        return true;
    }

    @Override
    public void put(K key, V value) {
        int slot = this.findSlot(key);
        if (slot < 0) {
            this.values[slot ^ 0xFFFFFFFF] = value;
            return;
        }
        this.keys[slot] = key;
        this.values[slot] = value;
        if (++this.size > this.threshold) {
            this.grow();
        }
    }

    @Override
    public V get(K key) {
        int slot = this.findSlot(key);
        if (slot < 0) {
            return this.values[~slot];
        }
        return null;
    }

    @Override
    public V getOrDefault(K key, V defaultValue) {
        int slot = this.findSlot(key);
        if (slot < 0) {
            return this.values[~slot];
        }
        return defaultValue;
    }

    @Override
    public V computeIfAbsent(K key, Supplier<V> absentValueSupplier) {
        int slot = this.findSlot(key);
        if (slot < 0) {
            return this.values[~slot];
        }
        V value = absentValueSupplier.get();
        this.keys[slot] = key;
        this.values[slot] = value;
        if (++this.size > this.threshold) {
            this.grow();
        }
        return value;
    }

    @Override
    public void compute(K key, UnaryOperator<V> valueProcessor) {
        int slot = this.findSlot(key);
        if (slot < 0) {
            Object value = valueProcessor.apply(this.values[~slot]);
            if (value == null) {
                this.removeFrom(~slot);
            } else {
                this.values[slot ^ 0xFFFFFFFF] = value;
            }
        } else {
            Object value = valueProcessor.apply(null);
            if (value == null) {
                return;
            }
            this.keys[slot] = key;
            this.values[slot] = value;
            if (++this.size > this.threshold) {
                this.grow();
            }
        }
    }

    @Override
    protected void grow() {
        Object[] oldContents = this.keys;
        V[] oldValues = this.values;
        this.keys = this.newKeysArray(this.calcGrownCapacityAndSetThreshold());
        this.values = this.newValuesArray(this.keys.length);
        for (int i = 0; i < oldContents.length; ++i) {
            Object key = oldContents[i];
            if (key == null) continue;
            int slot = this.findSlot(key);
            this.keys[slot] = key;
            this.values[slot] = oldValues[i];
        }
    }

    @Override
    protected void removeFrom(int here) {
        --this.size;
        while (true) {
            int r;
            this.keys[here] = null;
            this.values[here] = null;
            int scan = here;
            do {
                if (--scan < 0) {
                    scan += this.keys.length;
                }
                if (this.keys[scan] != null) continue;
                return;
            } while (scan <= (r = this.initialIndexFor(this.keys[scan].hashCode())) && r < here || r < here && here < scan || here < scan && scan <= r);
            this.keys[here] = this.keys[scan];
            this.values[here] = this.values[scan];
            here = scan;
        }
    }

    @Override
    public ExtendedIterator<V> valueIterator() {
        int initialSize = this.size;
        Runnable checkForConcurrentModification = () -> {
            if (this.size != initialSize) {
                throw new ConcurrentModificationException();
            }
        };
        return new SparseArrayIterator<V>(this.values, checkForConcurrentModification);
    }

    @Override
    public Spliterator<V> valueSpliterator() {
        int initialSize = this.size;
        Runnable checkForConcurrentModification = () -> {
            if (this.size != initialSize) {
                throw new ConcurrentModificationException();
            }
        };
        return new SparseArraySpliterator<V>(this.values, checkForConcurrentModification);
    }
}

