/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.simpleurl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.CharStreams;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import jeeves.server.context.ServiceContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.Logger;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.harvest.harvester.HarvestError;
import org.fao.geonet.kernel.harvest.harvester.HarvestResult;
import org.fao.geonet.kernel.harvest.harvester.IHarvester;
import org.fao.geonet.kernel.harvest.harvester.simpleurl.Aligner;
import org.fao.geonet.kernel.harvest.harvester.simpleurl.RDFUtils;
import org.fao.geonet.kernel.harvest.harvester.simpleurl.SimpleUrlParams;
import org.fao.geonet.kernel.harvest.harvester.simpleurl.SimpleUrlResourceType;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.util.Sha1Encoder;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Text;
import org.json.JSONObject;
import org.json.XML;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.client.ClientHttpResponse;

class Harvester
implements IHarvester<HarvestResult> {
    public static final String LOGGER_NAME = "geonetwork.harvester.simpleurl";
    private final AtomicBoolean cancelMonitor;
    private Logger log;
    private final SimpleUrlParams params;
    private final ServiceContext context;
    @Autowired
    GeonetHttpRequestFactory requestFactory;
    private final List<HarvestError> errors;

    public Harvester(AtomicBoolean cancelMonitor, Logger log, ServiceContext context, SimpleUrlParams params, List<HarvestError> errors) {
        this.cancelMonitor = cancelMonitor;
        this.log = log;
        this.context = context;
        this.params = params;
        this.errors = errors;
    }

    @Override
    public HarvestResult harvest(Logger log) throws Exception {
        this.log = log;
        log.debug("Retrieving from harvester: " + this.params.getName());
        this.requestFactory = (GeonetHttpRequestFactory)this.context.getBean(GeonetHttpRequestFactory.class);
        String[] urlList = this.params.url.split("\n");
        boolean error = false;
        Aligner aligner = new Aligner(this.cancelMonitor, this.context, this.params, log);
        HashSet<String> listOfUuids = new HashSet<String>();
        for (String url : urlList) {
            log.debug("Loading URL: " + url);
            String content = this.retrieveUrl(url);
            if (this.cancelMonitor.get()) {
                return new HarvestResult();
            }
            log.debug("Response is: " + content);
            int numberOfRecordsToHarvest = -1;
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode jsonObj = null;
            Element xmlObj = null;
            SimpleUrlResourceType type = Xml.isRDFLike((String)content) ? SimpleUrlResourceType.RDFXML : (Xml.isXMLLike((String)content) ? SimpleUrlResourceType.XML : SimpleUrlResourceType.JSON);
            if (type == SimpleUrlResourceType.XML || type == SimpleUrlResourceType.RDFXML) {
                xmlObj = Xml.loadString((String)content, (boolean)false);
            } else {
                jsonObj = objectMapper.readTree(content);
            }
            if (StringUtils.isNotEmpty((String)this.params.numberOfRecordPath)) {
                try {
                    if (type == SimpleUrlResourceType.XML) {
                        Object element = Xml.selectSingle((Element)xmlObj, (String)this.params.numberOfRecordPath, (List)xmlObj.getAdditionalNamespaces());
                        if (element != null) {
                            String s = this.getXmlElementTextValue(element);
                            numberOfRecordsToHarvest = Integer.parseInt(s);
                        }
                    } else if (type == SimpleUrlResourceType.JSON) {
                        numberOfRecordsToHarvest = jsonObj.at(this.params.numberOfRecordPath).asInt();
                    }
                    log.debug("Number of records to harvest: " + numberOfRecordsToHarvest);
                }
                catch (Exception e) {
                    this.errors.add(new HarvestError(this.context, e));
                    log.error(String.format("Failed to extract total in response at path %s. Error is: %s", this.params.numberOfRecordPath, e.getMessage()));
                }
            }
            try {
                List<String> listOfUrlForPages = this.buildListOfUrl(this.params, numberOfRecordsToHarvest);
                for (int i = 0; i < listOfUrlForPages.size(); ++i) {
                    if (i != 0) {
                        content = this.retrieveUrl(listOfUrlForPages.get(i));
                        if (type == SimpleUrlResourceType.XML) {
                            xmlObj = Xml.loadString((String)content, (boolean)false);
                        } else {
                            jsonObj = objectMapper.readTree(content);
                        }
                    }
                    if (!StringUtils.isNotEmpty((String)this.params.loopElement) && type != SimpleUrlResourceType.RDFXML) continue;
                    HashMap<String, Element> uuids = new HashMap<String, Element>();
                    try {
                        if (type == SimpleUrlResourceType.XML) {
                            this.collectRecordsFromXml(xmlObj, uuids, aligner);
                        } else if (type == SimpleUrlResourceType.RDFXML) {
                            this.collectRecordsFromRdf(xmlObj, uuids, aligner);
                        } else if (type == SimpleUrlResourceType.JSON) {
                            this.collectRecordsFromJson(jsonObj, uuids, aligner);
                        }
                        aligner.align(uuids, this.errors);
                        listOfUuids.addAll(uuids.keySet());
                        continue;
                    }
                    catch (Exception e) {
                        this.errors.add(new HarvestError(this.context, e));
                        log.error(String.format("Failed to collect record in response at path %s. Error is: %s", this.params.loopElement, e.getMessage()));
                    }
                }
            }
            catch (Exception t) {
                error = true;
                log.error("Unknown error trying to harvest");
                log.error(t.getMessage());
                log.error((Throwable)t);
                this.errors.add(new HarvestError(this.context, t));
            }
            catch (Throwable t) {
                error = true;
                log.fatal("Something unknown and terrible happened while harvesting");
                log.fatal(t.getMessage());
                this.errors.add(new HarvestError(this.context, t));
            }
            log.info("Total records processed in all searches :" + listOfUuids.size());
            if (!error) continue;
            log.warning("Due to previous errors the align process has not been called");
        }
        aligner.cleanupRemovedRecords(listOfUuids);
        return aligner.getResult();
    }

    private void collectRecordsFromJson(JsonNode jsonObj, Map<String, Element> uuids, Aligner aligner) {
        JsonNode nodes = jsonObj.at(this.params.loopElement);
        this.log.debug(String.format("%d records found in JSON response.", nodes.size()));
        nodes.forEach(jsonRecord -> {
            String uuid = null;
            try {
                uuid = this.extractUuidFromIdentifier(jsonRecord.at(this.params.recordIdPath).asText());
            }
            catch (Exception e) {
                this.log.error(String.format("Failed to collect record UUID at path %s. Error is: %s", this.params.recordIdPath, e.getMessage()));
            }
            String apiUrlPath = this.params.url.split("\\?")[0];
            try {
                URL apiUrl = new URL(apiUrlPath);
                String nodeUrl = apiUrl.getProtocol() + "://" + apiUrl.getAuthority();
                Element xml = this.convertJsonRecordToXml((JsonNode)jsonRecord, uuid, apiUrlPath, nodeUrl);
                uuids.put(uuid, xml);
            }
            catch (MalformedURLException e) {
                this.errors.add(new HarvestError(this.context, e));
                this.log.warning(String.format("Failed to parse JSON source URL. Error is: %s", e.getMessage()));
            }
        });
    }

    private void collectRecordsFromRdf(Element xmlObj, Map<String, Element> uuids, Aligner aligner) {
        HashMap<String, Element> rdfNodes = null;
        try {
            rdfNodes = RDFUtils.getAllUuids(xmlObj);
        }
        catch (Exception e) {
            this.errors.add(new HarvestError(this.context, e));
            this.log.error(String.format("Failed to find records in RDF graph. Error is: %s", e.getMessage()));
        }
        if (rdfNodes != null) {
            this.log.debug(String.format("%d records found in RDFXML response.", rdfNodes.size()));
            boolean hashUuid = true;
            rdfNodes.forEach((uuid, xml) -> {
                Element output;
                if (hashUuid) {
                    uuid = Sha1Encoder.encodeString((String)uuid);
                }
                if ((output = this.applyConversion((Element)xml, (String)uuid)) != null) {
                    uuids.put((String)uuid, output);
                }
            });
        }
    }

    private void collectRecordsFromXml(Element xmlObj, Map<String, Element> uuids, Aligner aligner) {
        List xmlNodes = null;
        try {
            xmlNodes = Xml.selectNodes((Element)xmlObj, (String)this.params.loopElement, (List)xmlObj.getAdditionalNamespaces());
        }
        catch (JDOMException e) {
            this.log.error(String.format("Failed to query records using %s. Error is: %s", this.params.loopElement, e.getMessage()));
        }
        if (xmlNodes != null) {
            this.log.debug(String.format("%d records found in XML response.", xmlNodes.size()));
            xmlNodes.forEach(element -> {
                try {
                    String uuid = this.getXmlElementTextValue(Xml.selectSingle((Element)element, (String)this.params.recordIdPath, (List)element.getAdditionalNamespaces()));
                    uuids.put(uuid, this.applyConversion((Element)element, null));
                }
                catch (JDOMException e) {
                    this.log.error(String.format("Failed to extract UUID for record. Error is %s.", e.getMessage()));
                    ++aligner.getResult().badFormat;
                    ++aligner.getResult().totalMetadata;
                }
            });
        }
    }

    private String getXmlElementTextValue(Object element) {
        String s = null;
        if (element instanceof Text) {
            s = ((Text)element).getTextNormalize();
        } else if (element instanceof Attribute) {
            s = ((Attribute)element).getValue();
        } else if (element instanceof String) {
            s = (String)element;
        }
        return s;
    }

    private String extractUuidFromIdentifier(String identifier) {
        String uuid = identifier;
        if (Lib.net.isUrlValid(uuid)) {
            uuid = uuid.replaceFirst(".*/([^/?]+).*", "$1");
        }
        return uuid;
    }

    @VisibleForTesting
    protected List<String> buildListOfUrl(SimpleUrlParams params, int numberOfRecordsToHarvest) {
        ArrayList<String> urlList = new ArrayList<String>();
        if (StringUtils.isEmpty((String)params.pageSizeParam)) {
            urlList.add(params.url);
            return urlList;
        }
        int numberOfRecordsPerPage = -1;
        String pageSizeParamValue = params.url.replaceAll(".*[?&]" + params.pageSizeParam + "=([0-9]+).*", "$1");
        if (!StringUtils.isNumeric((String)pageSizeParamValue)) {
            this.log.warning(String.format("Page size param '%s' not found or is not a numeric in URL '%s'. Can't build a list of pages.", params.pageSizeParam, params.url));
            urlList.add(params.url);
            return urlList;
        }
        numberOfRecordsPerPage = Integer.parseInt(pageSizeParamValue);
        String pageFromParamValue = params.url.replaceAll(".*[?&]" + params.pageFromParam + "=([0-9]+).*", "$1");
        if (!StringUtils.isNumeric((String)pageFromParamValue)) {
            this.log.warning(String.format("Page from param '%s' not found or is not a numeric in URL '%s'. Can't build a list of pages.", params.pageFromParam, params.url));
            urlList.add(params.url);
            return urlList;
        }
        boolean startAtZero = Integer.parseInt(pageFromParamValue) == 0;
        int numberOfPages = Math.abs((numberOfRecordsToHarvest + (startAtZero ? -1 : 0)) / numberOfRecordsPerPage) + 1;
        for (int i = 0; i < numberOfPages; ++i) {
            int from = i * numberOfRecordsPerPage + (startAtZero ? 0 : 1);
            int size = i == numberOfPages - 1 ? numberOfRecordsToHarvest - from + (startAtZero ? 0 : 1) : numberOfRecordsPerPage;
            String url = params.url.replaceAll(params.pageFromParam + "=[0-9]+", params.pageFromParam + "=" + from).replaceAll(params.pageSizeParam + "=[0-9]+", params.pageSizeParam + "=" + size);
            urlList.add(url);
        }
        return urlList;
    }

    private Element convertJsonRecordToXml(JsonNode jsonRecord, String uuid, String apiUrl, String nodeUrl) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String recordAsXml = XML.toString((Object)new JSONObject(objectMapper.writeValueAsString((Object)jsonRecord)), (String)"record");
            recordAsXml = Xml.stripNonValidXMLCharacters((String)recordAsXml).replace("<@", "<").replace("</@", "</").replaceAll("(:|%)(?![^<>]*<)", "_");
            Element recordAsElement = Xml.loadString((String)recordAsXml, (boolean)false);
            recordAsElement.addContent((Content)new Element("uuid").setText(uuid));
            recordAsElement.addContent((Content)new Element("apiUrl").setText(apiUrl));
            recordAsElement.addContent((Content)new Element("nodeUrl").setText(nodeUrl));
            return this.applyConversion(recordAsElement, null);
        }
        catch (Exception e) {
            this.log.error(String.format("Failed to convert JSON record %s to XML. Error is: %s", uuid, e.getMessage()));
            return null;
        }
    }

    private Element applyConversion(Element input, String uuid) {
        if (StringUtils.isNotEmpty((String)this.params.toISOConversion)) {
            Path xslPath = ((GeonetworkDataDirectory)ApplicationContextHolder.get().getBean(GeonetworkDataDirectory.class)).getXsltConversion(this.params.toISOConversion);
            try {
                HashMap<String, String> xslParams = new HashMap<String, String>();
                if (uuid != null) {
                    xslParams.put("uuid", uuid);
                }
                return Xml.transform((Element)input, (Path)xslPath, xslParams);
            }
            catch (Exception e) {
                this.errors.add(new HarvestError(this.context, e));
                this.log.error(String.format("Failed to apply conversion %s to record %s. Error is: %s", this.params.toISOConversion, uuid, e.getMessage()));
                return null;
            }
        }
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String retrieveUrl(String url) throws Exception {
        String string;
        ClientHttpResponse httpResponse;
        block5: {
            if (!Lib.net.isUrlValid(url)) {
                throw new BadParameterEx("Invalid URL", (Object)url);
            }
            HttpGet httpMethod = null;
            httpResponse = null;
            try {
                httpMethod = new HttpGet(this.createUrl(url));
                if (this.params.getApiKey() != null && !this.params.getApiKey().trim().isEmpty()) {
                    String headerName = this.params.getApiKeyHeader() != null && !this.params.getApiKeyHeader().isBlank() ? this.params.getApiKeyHeader() : "Authorization";
                    httpMethod.addHeader(headerName, this.params.getApiKey());
                }
                httpResponse = this.requestFactory.execute((HttpUriRequest)httpMethod);
                int status = httpResponse.getRawStatusCode();
                Log.debug((String)LOGGER_NAME, (Object)("Request status code: " + status));
                string = CharStreams.toString((Readable)new InputStreamReader(httpResponse.getBody()));
                if (httpMethod == null) break block5;
            }
            catch (Throwable throwable) {
                if (httpMethod != null) {
                    httpMethod.releaseConnection();
                }
                IOUtils.closeQuietly(httpResponse);
                throw throwable;
            }
            httpMethod.releaseConnection();
        }
        IOUtils.closeQuietly((Closeable)httpResponse);
        return string;
    }

    private URI createUrl(String jsonUrl) throws URISyntaxException {
        return new URI(jsonUrl);
    }
}

