/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.geoPREST;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.ParseException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.Constants;
import org.fao.geonet.Logger;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.exceptions.BadSoapResponseEx;
import org.fao.geonet.exceptions.BadXmlResponseEx;
import org.fao.geonet.exceptions.OperationAbortedEx;
import org.fao.geonet.kernel.harvest.harvester.HarvestError;
import org.fao.geonet.kernel.harvest.harvester.HarvestResult;
import org.fao.geonet.kernel.harvest.harvester.IHarvester;
import org.fao.geonet.kernel.harvest.harvester.RecordInfo;
import org.fao.geonet.kernel.harvest.harvester.geoPREST.Aligner;
import org.fao.geonet.kernel.harvest.harvester.geoPREST.GeoPRESTParams;
import org.fao.geonet.kernel.harvest.harvester.geoPREST.Search;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.Xml;
import org.fao.geonet.utils.XmlRequest;
import org.jdom.Element;

class Harvester
implements IHarvester<HarvestResult> {
    private final AtomicBoolean cancelMonitor;
    private Logger log;
    private final GeoPRESTParams params;
    private final ServiceContext context;
    private final List<HarvestError> errors;

    public Harvester(AtomicBoolean cancelMonitor, Logger log, ServiceContext context, GeoPRESTParams params, List<HarvestError> errors) {
        this.cancelMonitor = cancelMonitor;
        this.log = log;
        this.context = context;
        this.params = params;
        this.errors = errors;
    }

    @Override
    public HarvestResult harvest(Logger log) throws Exception {
        this.log = log;
        XmlRequest request = ((GeonetHttpRequestFactory)this.context.getBean(GeonetHttpRequestFactory.class)).createXmlRequest(new URL(this.params.baseUrl + "/rest/find/document"));
        HashSet<RecordInfo> records = new HashSet<RecordInfo>();
        for (Search s : this.params.getSearches()) {
            if (this.cancelMonitor.get()) {
                return new HarvestResult();
            }
            try {
                records.addAll(this.search(request, s));
            }
            catch (Exception t) {
                log.error("Unknown error trying to harvest");
                log.error(t.getMessage());
                log.error((Throwable)t);
                this.errors.add(new HarvestError(this.context, t));
            }
            catch (Throwable t) {
                log.fatal("Something unknown and terrible happened while harvesting");
                log.fatal(t.getMessage());
                log.error(t);
                this.errors.add(new HarvestError(this.context, t));
            }
        }
        if (this.params.isSearchEmpty()) {
            try {
                log.debug("Doing an empty search");
                records.addAll(this.search(request, Search.createEmptySearch()));
            }
            catch (Exception t) {
                log.error("Unknown error trying to harvest");
                log.error(t.getMessage());
                log.error((Throwable)t);
                this.errors.add(new HarvestError(this.context, t));
            }
            catch (Throwable t) {
                log.fatal("Something unknown and terrible happened while harvesting");
                log.fatal(t.getMessage());
                log.error(t);
                this.errors.add(new HarvestError(this.context, t));
            }
        }
        log.info("Total records processed in all searches :" + records.size());
        Aligner aligner = new Aligner(this.cancelMonitor, log, this.context, this.params);
        return aligner.align(records, this.errors);
    }

    private Set<RecordInfo> search(XmlRequest request, Search s) throws Exception {
        String rss;
        request.clearParams();
        request.addParam("searchText", (Object)s.freeText);
        request.addParam("max", (Object)this.params.maxResults);
        Element response = this.doSearch(request);
        HashSet<RecordInfo> records = new HashSet<RecordInfo>();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Number of child elements in response: " + response.getChildren().size());
        }
        if (!(rss = response.getName()).equals("rss")) {
            throw new OperationAbortedEx("Missing 'rss' element in\n", (Object)Xml.getString((Element)response));
        }
        Element channel = response.getChild("channel");
        if (channel == null) {
            throw new OperationAbortedEx("Missing 'channel' element in \n", (Object)Xml.getString((Element)response));
        }
        List list = channel.getChildren();
        for (Element record : list) {
            RecordInfo recInfo;
            if (this.cancelMonitor.get()) {
                return Collections.emptySet();
            }
            if (!record.getName().equals("item") || (recInfo = this.getRecordInfo((Element)record.clone())) == null) continue;
            records.add(recInfo);
        }
        this.log.info("Records added to result list : " + records.size());
        return records;
    }

    private Element doSearch(XmlRequest request) throws OperationAbortedEx {
        try {
            this.log.info("Searching on : " + this.params.getName());
            Element response = request.execute();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Sent request " + request.getSentData());
                this.log.debug("Search results:\n" + Xml.getString((Element)response));
            }
            return response;
        }
        catch (BadSoapResponseEx e) {
            this.errors.add(new HarvestError(this.context, e));
            throw new OperationAbortedEx("Raised exception when searching: " + e.getMessage(), (Object)e);
        }
        catch (BadXmlResponseEx e) {
            this.errors.add(new HarvestError(this.context, e));
            throw new OperationAbortedEx("Raised exception when searching: " + e.getMessage(), (Object)e);
        }
        catch (IOException e) {
            this.errors.add(new HarvestError(this.context, e));
            throw new OperationAbortedEx("Raised exception when searching: " + e.getMessage(), (Object)e);
        }
    }

    private RecordInfo getRecordInfo(Element record) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("getRecordInfo : " + Xml.getString((Element)record));
        }
        String identif = "";
        try {
            String guidLink = record.getChildText("guid");
            if (guidLink != null) {
                guidLink = URLDecoder.decode(guidLink, Constants.ENCODING);
                identif = StringUtils.substringAfter((String)guidLink, (String)"id=");
            }
            if (identif.length() == 0) {
                this.log.warning("Record doesn't have a uuid : " + Xml.getString((Element)record));
                return null;
            }
            String modified = record.getChildText("pubDate");
            Date modDate = this.parseDate(modified);
            if ((modified = new ISODate(modDate.getTime(), false).toString()) != null && modified.length() == 0) {
                modified = null;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("getRecordInfo: adding " + identif + " with modification date " + modified);
            }
            return new RecordInfo(identif, modified);
        }
        catch (UnsupportedEncodingException e) {
            HarvestError harvestError = new HarvestError(this.context, e);
            harvestError.setDescription(harvestError.getDescription() + "\n record: " + Xml.getString((Element)record));
            this.errors.add(harvestError);
        }
        catch (ParseException e) {
            HarvestError harvestError = new HarvestError(this.context, e);
            harvestError.setDescription(harvestError.getDescription() + "\n record: " + Xml.getString((Element)record));
            this.errors.add(new HarvestError(this.context, e));
        }
        return null;
    }

    protected Date parseDate(String pubDate) throws ParseException {
        Locale[] wellKnownLocales;
        for (Locale locale : wellKnownLocales = new Locale[]{Locale.ENGLISH, Locale.FRENCH, Locale.GERMAN, Locale.ITALIAN}) {
            DateTimeFormatter formatter = DateTimeFormatter.RFC_1123_DATE_TIME.withLocale(locale);
            try {
                ZonedDateTime date = ZonedDateTime.parse(pubDate, formatter);
                return Date.from(date.toInstant());
            }
            catch (DateTimeParseException e) {
                if (locale == Locale.GERMAN && (pubDate.toLowerCase(Locale.GERMAN).contains("mrz") || pubDate.toLowerCase(Locale.GERMAN).contains("m\u00e4r"))) {
                    try {
                        this.log.info("Applying MRZ workaround to '" + pubDate + "'");
                        String wad = pubDate.toLowerCase(Locale.GERMAN).replace("mrz", "mar");
                        wad = wad.replace("m\u00e4r", "mar");
                        ZonedDateTime workedAroundDate = ZonedDateTime.parse(wad, formatter);
                        return Date.from(workedAroundDate.toInstant());
                    }
                    catch (DateTimeParseException dateTimeParseException) {
                        // empty catch block
                    }
                }
                this.log.debug("Date '" + pubDate + "' is not parsable according to " + locale);
            }
        }
        throw new ParseException("Can't parse date '" + pubDate + "'", 0);
    }
}

