/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.omm.security;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.sesame.sailimpl.omm.security.NullParameterException;
import org.openrdf.sesame.sailimpl.omm.security.Restriction;
import org.openrdf.sesame.sailimpl.omm.security.SecurityException;

public class PropertiesRestriction
extends Restriction {
    Set properties = new HashSet();

    public PropertiesRestriction(int id, String name, String descr) {
        super(id, 5, name, descr);
    }

    public Set getProperties() {
        return this.properties;
    }

    public void setProperties(Set properties) throws NullParameterException {
        if (null == properties) {
            throw new NullParameterException("[properties] should not be [null].");
        }
        this.properties = properties;
    }

    public ArrayList toSql(Map idByLiteral, Map idByRes) throws NullParameterException, SecurityException {
        if (idByRes == null) {
            throw new NullParameterException("[ids by resources] map should not be [null].");
        }
        if (idByLiteral == null) {
            throw new NullParameterException("[ids by literals] map should not be [null].");
        }
        ArrayList list = super.toSql(idByLiteral, idByRes);
        ArrayList propz = new ArrayList(this.properties);
        for (int pi = 0; pi < propz.size(); ++pi) {
            Resource res = (Resource)propz.get(pi);
            Integer i = (Integer)idByRes.get(res);
            if (i == null) {
                throw new SecurityException("Id not found for resource : \n" + res);
            }
            int pid = i;
            StringBuffer query = new StringBuffer();
            query.append("INSERT INTO ");
            query.append("res_propr_restrs");
            query.append(" VALUES ");
            query.append("(").append(this.id);
            query.append(",");
            query.append(pid).append(");");
            list.add(query.toString());
        }
        return list;
    }
}

