/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.config.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;
import org.openrdf.sesame.config.SystemConfig;
import org.openrdf.sesame.config.SystemConfigListener;
import org.openrdf.sesame.config.handlers.SystemConfigFileHandler;
import org.openrdf.sesame.config.ui.AboutDialog;
import org.openrdf.sesame.config.ui.RepositoryTab;
import org.openrdf.sesame.config.ui.ServerIOPanel;
import org.openrdf.sesame.config.ui.ServerTab;
import org.openrdf.sesame.config.ui.UserTab;
import org.openrdf.sesame.config.ui.util.Util;

public class ConfigureSesameFrame
extends JFrame
implements SystemConfigListener {
    protected SystemConfigFileChooser _fileChooser;
    protected ServerIOPanel _serverIOPanel;
    protected SystemConfig _config = new SystemConfig();
    protected boolean _configChanged;
    protected File _file;
    protected String _serverURL;
    protected Action _newAction;
    protected Action _closeAction;
    protected Action _loadFromServerAction;
    protected Action _sendToServerAction;
    protected Action _openFileAction;
    protected Action _saveFileAction;
    protected Action _saveFileAsAction;
    protected Action _exitAction;
    protected Action _aboutAction;

    public ConfigureSesameFrame() {
        this._config.addListener(this);
        this._configChanged = false;
        this._fileChooser = new SystemConfigFileChooser();
        this._serverIOPanel = new ServerIOPanel();
        this.setTitle("Configure Sesame!");
        URL url = this.getClass().getResource("icons/cs.png");
        ImageIcon imageIcon = new ImageIcon(url);
        this.setIconImage(imageIcon.getImage());
        this._createActions();
        JMenuBar menuBar = this._createMenuBar();
        this.setJMenuBar(menuBar);
        JToolBar toolBar = this._createToolBar();
        JTabbedPane tabs = new JTabbedPane();
        tabs.add("Users", new UserTab(this._config));
        tabs.add("Repositories", new RepositoryTab(this._config));
        tabs.add("Server", new ServerTab(this._config));
        Container contentPane = this.getContentPane();
        contentPane.add((Component)toolBar, "North");
        contentPane.add((Component)tabs, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (ConfigureSesameFrame.this._discardCurrentConf()) {
                    System.exit(0);
                }
            }
        });
    }

    protected void _createActions() {
        this._newAction = this._createNewAction();
        this._closeAction = this._createCloseAction();
        this._loadFromServerAction = this._createLoadFromServerAction();
        this._sendToServerAction = this._createSendToServerAction();
        this._openFileAction = this._createOpenFileAction();
        this._saveFileAction = this._createSaveFileAction();
        this._saveFileAsAction = this._createSaveFileAsAction();
        this._exitAction = this._createExitAction();
        this._aboutAction = this._createAboutAction();
    }

    protected JMenuBar _createMenuBar() {
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        fileMenu.add(new JMenuItem(this._newAction));
        fileMenu.add(new JMenuItem(this._closeAction));
        fileMenu.addSeparator();
        fileMenu.add(new JMenuItem(this._loadFromServerAction));
        fileMenu.add(new JMenuItem(this._sendToServerAction));
        fileMenu.addSeparator();
        fileMenu.add(new JMenuItem(this._openFileAction));
        fileMenu.add(new JMenuItem(this._saveFileAction));
        fileMenu.add(new JMenuItem(this._saveFileAsAction));
        fileMenu.addSeparator();
        fileMenu.add(new JMenuItem(this._exitAction));
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic('H');
        helpMenu.add(new JMenuItem(this._aboutAction));
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(fileMenu);
        menuBar.add(helpMenu);
        return menuBar;
    }

    protected JToolBar _createToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.add(this._newAction);
        toolBar.addSeparator();
        toolBar.add(this._loadFromServerAction);
        toolBar.add(this._sendToServerAction);
        toolBar.addSeparator();
        toolBar.add(this._openFileAction);
        toolBar.add(this._saveFileAction);
        return toolBar;
    }

    protected Action _createNewAction() {
        URL url = this.getClass().getResource("icons/file_new.gif");
        ImageIcon icon = new ImageIcon(url);
        AbstractAction action = new AbstractAction("New", icon){

            public void actionPerformed(ActionEvent e) {
                if (ConfigureSesameFrame.this._discardCurrentConf()) {
                    ConfigureSesameFrame.this._file = null;
                    ConfigureSesameFrame.this._serverURL = null;
                    ConfigureSesameFrame.this._configChanged = false;
                    ConfigureSesameFrame.this._config.setSystemConfig(new SystemConfig());
                    ConfigureSesameFrame.this._fileChooser.setSelectedFile(null);
                }
            }
        };
        action.putValue("ShortDescription", "New configuration");
        action.putValue("MnemonicKey", new Integer(78));
        return action;
    }

    protected Action _createCloseAction() {
        AbstractAction action = new AbstractAction("Close"){

            public void actionPerformed(ActionEvent e) {
                if (ConfigureSesameFrame.this._discardCurrentConf()) {
                    ConfigureSesameFrame.this._file = null;
                    ConfigureSesameFrame.this._serverURL = null;
                    ConfigureSesameFrame.this._configChanged = false;
                    ConfigureSesameFrame.this._config.setSystemConfig(new SystemConfig());
                    ConfigureSesameFrame.this._fileChooser.setSelectedFile(null);
                }
            }
        };
        action.putValue("ShortDescription", "Close configuration");
        action.putValue("MnemonicKey", new Integer(67));
        return action;
    }

    protected Action _createLoadFromServerAction() {
        URL url = this.getClass().getResource("icons/loadfromserver.png");
        ImageIcon icon = new ImageIcon(url);
        AbstractAction action = new AbstractAction("Load from server...", icon){

            public void actionPerformed(ActionEvent e) {
                SystemConfig newConfig;
                if (ConfigureSesameFrame.this._discardCurrentConf() && (newConfig = ConfigureSesameFrame.this._serverIOPanel.showLoadDialog(ConfigureSesameFrame.this)) != null) {
                    ConfigureSesameFrame.this._file = null;
                    ConfigureSesameFrame.this._serverURL = ConfigureSesameFrame.this._serverIOPanel.getServerURL();
                    ConfigureSesameFrame.this._config.setSystemConfig(newConfig);
                    ConfigureSesameFrame.this._configChanged = false;
                    ConfigureSesameFrame.this._updateTitle();
                }
            }
        };
        action.putValue("ShortDescription", "Load configuration from server");
        action.putValue("MnemonicKey", new Integer(76));
        return action;
    }

    protected Action _createSendToServerAction() {
        URL url = this.getClass().getResource("icons/sendtoserver.png");
        ImageIcon icon = new ImageIcon(url);
        AbstractAction action = new AbstractAction("Send to server...", icon){

            public void actionPerformed(ActionEvent e) {
                ConfigureSesameFrame.this._serverIOPanel.showSendDialog(ConfigureSesameFrame.this, ConfigureSesameFrame.this._config);
                ConfigureSesameFrame.this._configChanged = false;
                ConfigureSesameFrame.this._updateTitle();
            }
        };
        action.putValue("ShortDescription", "Send configuration to server");
        action.putValue("MnemonicKey", new Integer(83));
        return action;
    }

    protected Action _createOpenFileAction() {
        URL url = this.getClass().getResource("icons/file_open.gif");
        ImageIcon icon = new ImageIcon(url);
        AbstractAction action = new AbstractAction("Open file...", icon){

            public void actionPerformed(ActionEvent e) {
                if (ConfigureSesameFrame.this._discardCurrentConf() && ConfigureSesameFrame.this._fileChooser.showOpenDialog(ConfigureSesameFrame.this) == 0) {
                    ConfigureSesameFrame.this.load(ConfigureSesameFrame.this._fileChooser.getSelectedFile());
                }
            }
        };
        action.putValue("ShortDescription", "Open configuration file");
        action.putValue("MnemonicKey", new Integer(79));
        return action;
    }

    protected Action _createSaveFileAction() {
        URL url = this.getClass().getResource("icons/file_save.gif");
        ImageIcon icon = new ImageIcon(url);
        AbstractAction action = new AbstractAction("Save file", icon){

            public void actionPerformed(ActionEvent e) {
                if (ConfigureSesameFrame.this._file == null) {
                    ConfigureSesameFrame.this._saveAs();
                } else {
                    ConfigureSesameFrame.this._save();
                }
            }
        };
        action.putValue("ShortDescription", "Save configuration file");
        action.putValue("MnemonicKey", new Integer(102));
        return action;
    }

    protected Action _createSaveFileAsAction() {
        AbstractAction action = new AbstractAction("Save file as..."){

            public void actionPerformed(ActionEvent e) {
                ConfigureSesameFrame.this._saveAs();
            }
        };
        action.putValue("ShortDescription", "Save configuration file as");
        action.putValue("MnemonicKey", new Integer(97));
        return action;
    }

    protected Action _createExitAction() {
        AbstractAction action = new AbstractAction("Exit"){

            public void actionPerformed(ActionEvent e) {
                if (ConfigureSesameFrame.this._discardCurrentConf()) {
                    System.exit(0);
                }
            }
        };
        action.putValue("ShortDescription", "Exit Configure Sesame!");
        action.putValue("MnemonicKey", new Integer(120));
        return action;
    }

    protected Action _createAboutAction() {
        AbstractAction action = new AbstractAction("About"){

            public void actionPerformed(ActionEvent e) {
                AboutDialog dialog = new AboutDialog(ConfigureSesameFrame.this);
                dialog.show();
            }
        };
        action.putValue("ShortDescription", "Show info about Configure Sesame!");
        action.putValue("MnemonicKey", new Integer(65));
        return action;
    }

    public void configurationChanged() {
        this._configChanged = true;
        this._updateTitle();
    }

    protected void _updateTitle() {
        String title = "";
        if (this._file != null) {
            title = title + this._file.getName();
            if (this._configChanged) {
                title = title + "*";
            }
            title = title + " - ";
        } else if (this._serverURL != null) {
            title = title + this._serverURL;
            if (this._configChanged) {
                title = title + "*";
            }
            title = title + " - ";
        }
        title = title + "Configure Sesame!";
        this.setTitle(title);
    }

    protected boolean _discardCurrentConf() {
        if (this._configChanged) {
            int option;
            Window owner = Util.getOwner(this);
            String message = "Do you want to save your changes";
            if (this._file != null) {
                message = message + " to '" + this._file.getName() + "'";
            }
            if ((option = JOptionPane.showConfirmDialog(owner, message = message + "?", "Configure Sesame!", 1)) == 0) {
                if (this._file == null) {
                    this._saveAs();
                } else {
                    this._save();
                }
            } else if (option == 2) {
                return false;
            }
        }
        return true;
    }

    public void load(File file) {
        this._file = file;
        this._serverURL = null;
        this._load();
    }

    protected void _load() {
        try {
            FileInputStream in = new FileInputStream(this._file);
            SystemConfig newConfig = SystemConfigFileHandler.readConfiguration(in);
            ((InputStream)in).close();
            this._config.setSystemConfig(newConfig);
            this._configChanged = false;
            this._updateTitle();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    protected void _saveAs() {
        if (this._file == null) {
            this._fileChooser.setSelectedFile(new File("system.conf"));
        }
        if (this._fileChooser.showSaveDialog(this) == 0) {
            this._file = this._fileChooser.getSelectedFile();
            this._save();
        }
        this._fileChooser.setSelectedFile(this._file);
    }

    protected void _save() {
        try {
            FileOutputStream outputStream = new FileOutputStream(this._file);
            SystemConfigFileHandler.writeConfiguration(this._config, outputStream);
            outputStream.flush();
            ((OutputStream)outputStream).close();
            this._configChanged = false;
            this._updateTitle();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    class SystemConfigFileChooser
    extends JFileChooser {
        public SystemConfigFileChooser() {
            this.setFileFilter(new FileFilter(this){
                private final /* synthetic */ SystemConfigFileChooser this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean accept(File file) {
                    return file.getName().endsWith(".conf") || file.isDirectory();
                }

                public String getDescription() {
                    return ".conf";
                }
            });
        }

        public void approveSelection() {
            File file;
            if (this.getDialogType() == 1) {
                File file2 = this.getSelectedFile();
                if ((ConfigureSesameFrame.this._file == null || !ConfigureSesameFrame.this._file.getPath().equals(file2.getPath())) && file2.exists()) {
                    Window owner = Util.getOwner(this);
                    int option = JOptionPane.showConfirmDialog(owner, "The file '" + file2.getName() + "' already exists.\n" + "Are you sure you want to overwrite the existing file?", "Configure Sesame!", 1);
                    if (option == 1) {
                        this.setSelectedFile(ConfigureSesameFrame.this._file);
                        return;
                    }
                    if (option == 2) {
                        this.cancelSelection();
                        return;
                    }
                }
            } else if (this.getDialogType() == 0 && !(file = this.getSelectedFile()).exists()) {
                Window owner = Util.getOwner(this);
                Util.showWarningDialog(owner, "The file '" + file.getName() + "' does not exist.", "Configure Sesame!");
                return;
            }
            super.approveSelection();
        }
    }
}

