/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.algebra;

import it.geosolutions.jaiext.range.Range;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.ROI;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;

public class AlgebraDescriptor
extends OperationDescriptorImpl {
    public static final int OPERATION_INDEX = 0;
    public static final int ROI_INDEX = 1;
    public static final int RANGE_INDEX = 2;
    public static final int DEST_NODATA_INDEX = 3;
    private static final String[][] resources = new String[][]{{"GlobalName", "algebric"}, {"LocalName", "algebric"}, {"Vendor", "it.geosolutions.jaiext"}, {"Description", "This class executes the operation selected by the user on each pixel of the source images "}, {"DocURL", "Not Defined"}, {"Version", "1.0"}, {"arg0Desc", "Operation to execute"}, {"arg1Desc", "ROI object used"}, {"arg2Desc", "No Data Range used"}, {"arg3Desc", "Output value for No Data"}};
    private static final String[] paramNames = new String[]{"operation", "roi", "noData", "destinationNoData"};
    private static final Class[] paramClasses = new Class[]{Operator.class, ROI.class, Range.class, Double.class};
    private static final Object[] paramDefaults = new Object[]{null, null, null, 0.0};

    public AlgebraDescriptor() {
        super(resources, paramClasses, paramNames, paramDefaults);
    }

    public boolean isRenderableSupported() {
        return true;
    }

    public static RenderedOp create(Operator op, ROI roi, Range noData, double destinationNoData, RenderingHints hints, RenderedImage ... sources) {
        ParameterBlockJAI pb = new ParameterBlockJAI("algebric", "rendered");
        int numSources = sources.length;
        for (int i = 0; i < numSources; ++i) {
            RenderedImage img = sources[i];
            if (img == null) continue;
            pb.setSource((Object)img, i);
        }
        if (pb.getNumSources() == 0) {
            throw new IllegalArgumentException("The input images are Null");
        }
        pb.setParameter("operation", (Object)op);
        pb.setParameter("roi", (Object)roi);
        pb.setParameter("noData", (Object)noData);
        pb.setParameter("destinationNoData", destinationNoData);
        return JAI.create((String)"algebric", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public static RenderableOp createRenderable(Operator op, ROI roi, Range noData, double destinationNoData, RenderingHints hints, RenderableImage ... sources) {
        ParameterBlockJAI pb = new ParameterBlockJAI("algebric", "renderable");
        int numSources = sources.length;
        for (int i = 0; i < numSources; ++i) {
            RenderableImage img = sources[i];
            if (img == null) continue;
            pb.setSource((Object)img, i);
        }
        if (pb.getNumSources() == 0) {
            throw new IllegalArgumentException("The input images are Null");
        }
        pb.setParameter("operation", (Object)op);
        pb.setParameter("roi", (Object)roi);
        pb.setParameter("noData", (Object)noData);
        pb.setParameter("destinationNoData", destinationNoData);
        return JAI.createRenderable((String)"algebric", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public static enum Operator {
        SUM(0, 0.0, true){

            @Override
            public byte calculate(byte ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = (byte)(values[0] + values[i]);
                    }
                }
                return values[0];
            }

            @Override
            public short calculate(boolean isUshort, short ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = (short)(values[0] + values[i]);
                    }
                }
                return values[0];
            }

            @Override
            public short calculate(short ... values) {
                return this.calculate(false, values);
            }

            @Override
            public int calculate(int ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[0] + values[i];
                    }
                }
                return values[0];
            }

            @Override
            public float calculate(float ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[0] + values[i];
                    }
                }
                return values[0];
            }

            @Override
            public double calculate(double ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[0] + values[i];
                    }
                }
                return values[0];
            }

            @Override
            public long calculateL(long ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[0] + values[i];
                    }
                }
                return values[0];
            }
        }
        ,
        SUBTRACT(1, 0.0, true){

            @Override
            public byte calculate(byte ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = (byte)(values[0] - values[i]);
                    }
                }
                return values[0];
            }

            @Override
            public short calculate(boolean isUshort, short ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = (short)(values[0] - values[i]);
                    }
                }
                return values[0];
            }

            @Override
            public short calculate(short ... values) {
                return this.calculate(false, values);
            }

            @Override
            public int calculate(int ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[0] - values[i];
                    }
                }
                return values[0];
            }

            @Override
            public float calculate(float ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[0] - values[i];
                    }
                }
                return values[0];
            }

            @Override
            public double calculate(double ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[0] - values[i];
                    }
                }
                return values[0];
            }

            @Override
            public long calculateL(long ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[0] - values[i];
                    }
                }
                return values[0];
            }
        }
        ,
        MULTIPLY(2, 1.0, true){

            @Override
            public byte calculate(byte ... values) {
                long temp = 1L;
                if (values.length > 1) {
                    for (int i = 0; i < values.length; ++i) {
                        temp *= (long)values[i];
                    }
                    values[0] = temp > 127L ? 127 : (temp < -128L ? -128 : (byte)temp);
                }
                return values[0];
            }

            @Override
            public short calculate(boolean isUshort, short ... values) {
                long temp = 1L;
                if (values.length > 1) {
                    for (int i = 0; i < values.length; ++i) {
                        temp *= (long)values[i];
                    }
                    values[0] = isUshort ? (temp > (long)USHORT_MAX_VALUE ? (int)USHORT_MAX_VALUE : (temp < 0L ? 0 : (int)((int)temp))) : (temp > 32767L ? Short.MAX_VALUE : (temp < -32768L ? Short.MIN_VALUE : (short)temp));
                }
                return values[0];
            }

            @Override
            public short calculate(short ... values) {
                return this.calculate(false, values);
            }

            @Override
            public int calculate(int ... values) {
                long temp = 1L;
                if (values.length > 1) {
                    for (int i = 0; i < values.length; ++i) {
                        temp *= (long)values[i];
                    }
                    values[0] = temp > Integer.MAX_VALUE ? Integer.MAX_VALUE : (temp < Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)temp);
                }
                return values[0];
            }

            @Override
            public float calculate(float ... values) {
                double temp = 1.0;
                if (values.length > 1) {
                    for (int i = 0; i < values.length; ++i) {
                        temp *= (double)values[i];
                    }
                    values[0] = temp > 3.4028234663852886E38 ? Float.MAX_VALUE : (temp < -3.4028234663852886E38 ? -3.4028235E38f : (float)temp);
                }
                return values[0];
            }

            @Override
            public double calculate(double ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[0] * values[i];
                    }
                }
                return values[0];
            }

            @Override
            public long calculateL(long ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[0] * values[i];
                    }
                }
                return values[0];
            }
        }
        ,
        DIVIDE(3, 1.0, true){

            @Override
            public byte calculate(byte ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[i] == 0 && values[0] >= 0 ? 127 : (values[i] == 0 && values[0] < 0 ? -128 : (byte)(values[0] / values[i]));
                    }
                }
                return values[0];
            }

            @Override
            public short calculate(boolean isUshort, short ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[i] == 0 && values[0] >= 0 ? (int)(isUshort ? USHORT_MAX_VALUE : Short.MAX_VALUE) : (values[i] == 0 && values[0] < 0 ? (isUshort ? 0 : Short.MIN_VALUE) : (short)(values[0] / values[i]));
                    }
                }
                return values[0];
            }

            @Override
            public short calculate(short ... values) {
                return this.calculate(false, values);
            }

            @Override
            public int calculate(int ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[i] == 0 && values[0] >= 0 ? Integer.MAX_VALUE : (values[i] == 0 && values[0] < 0 ? Integer.MIN_VALUE : values[0] / values[i]);
                    }
                }
                return values[0];
            }

            @Override
            public float calculate(float ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[0] / values[i];
                    }
                }
                return values[0];
            }

            @Override
            public double calculate(double ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[0] / values[i];
                    }
                }
                return values[0];
            }

            @Override
            public long calculateL(long ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[i] == 0L && values[0] >= 0L ? Long.MAX_VALUE : (values[i] == 0L && values[0] < 0L ? Long.MIN_VALUE : values[0] / values[i]);
                    }
                }
                return values[0];
            }
        }
        ,
        AND(4, 9.223372036854776E18, true){

            @Override
            public byte calculate(byte ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = (byte)(values[0] & values[i]);
                    }
                }
                return values[0];
            }

            @Override
            public short calculate(boolean isUshort, short ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = (short)(values[0] & values[i]);
                    }
                }
                return values[0];
            }

            @Override
            public short calculate(short ... values) {
                return this.calculate(false, values);
            }

            @Override
            public int calculate(int ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[0] & values[i];
                    }
                }
                return values[0];
            }

            @Override
            public float calculate(float ... values) {
                throw new UnsupportedOperationException("Float data type is not supported for this operation");
            }

            @Override
            public double calculate(double ... values) {
                throw new UnsupportedOperationException("Double data type is not supported for this operation");
            }

            @Override
            public long calculateL(long ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[0] & values[i];
                    }
                }
                return values[0];
            }

            @Override
            public boolean isDataTypeSupported(int dataType) {
                return dataType != 4 && dataType != 5;
            }
        }
        ,
        OR(5, 0.0, true){

            @Override
            public byte calculate(byte ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = (byte)(values[0] | values[i]);
                    }
                }
                return values[0];
            }

            @Override
            public short calculate(boolean isUshort, short ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = (short)(values[0] | values[i]);
                    }
                }
                return values[0];
            }

            @Override
            public short calculate(short ... values) {
                return this.calculate(false, values);
            }

            @Override
            public int calculate(int ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[0] | values[i];
                    }
                }
                return values[0];
            }

            @Override
            public float calculate(float ... values) {
                throw new UnsupportedOperationException("Float data type is not supported for this operation");
            }

            @Override
            public double calculate(double ... values) {
                throw new UnsupportedOperationException("Double data type is not supported for this operation");
            }

            @Override
            public long calculateL(long ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[0] | values[i];
                    }
                }
                return values[0];
            }

            @Override
            public boolean isDataTypeSupported(int dataType) {
                return dataType != 4 && dataType != 5;
            }
        }
        ,
        NOT(6, 0.0, false){

            @Override
            public byte calculate(byte ... values) {
                return ~values[0];
            }

            @Override
            public short calculate(boolean isUshort, short ... values) {
                return ~values[0];
            }

            @Override
            public short calculate(short ... values) {
                return this.calculate(false, values);
            }

            @Override
            public int calculate(int ... values) {
                return ~values[0];
            }

            @Override
            public float calculate(float ... values) {
                throw new UnsupportedOperationException("Float data type is not supported for this operation");
            }

            @Override
            public double calculate(double ... values) {
                throw new UnsupportedOperationException("Double data type is not supported for this operation");
            }

            @Override
            public long calculateL(long ... values) {
                return values[0] ^ 0xFFFFFFFFFFFFFFFFL;
            }

            @Override
            public boolean isDataTypeSupported(int dataType) {
                return dataType != 4 && dataType != 5;
            }
        }
        ,
        XOR(7, 0.0, true){

            @Override
            public byte calculate(byte ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = (byte)(values[0] ^ values[i]);
                    }
                }
                return values[0];
            }

            @Override
            public short calculate(boolean isUshort, short ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = (short)(values[0] ^ values[i]);
                    }
                }
                return values[0];
            }

            @Override
            public short calculate(short ... values) {
                return this.calculate(false, values);
            }

            @Override
            public int calculate(int ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[0] ^ values[i];
                    }
                }
                return values[0];
            }

            @Override
            public float calculate(float ... values) {
                throw new UnsupportedOperationException("Float data type is not supported for this operation");
            }

            @Override
            public double calculate(double ... values) {
                throw new UnsupportedOperationException("Double data type is not supported for this operation");
            }

            @Override
            public long calculateL(long ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[0] ^ values[i];
                    }
                }
                return values[0];
            }

            @Override
            public boolean isDataTypeSupported(int dataType) {
                return dataType != 4 && dataType != 5;
            }
        }
        ,
        EXP(8, 0.0, false){
            private byte[] byteTable;

            @Override
            protected void initialization() {
                int i;
                if (this.byteTable != null) {
                    return;
                }
                this.byteTable = new byte[256];
                this.byteTable[0] = 1;
                for (i = 1; i < 6; ++i) {
                    this.byteTable[i] = (byte)(Math.exp(i) + 0.5);
                }
                for (i = 6; i < 256; ++i) {
                    this.byteTable[i] = -1;
                }
            }

            @Override
            public byte calculate(byte ... values) {
                return this.byteTable[values[0] & 0xFF];
            }

            @Override
            public short calculate(boolean isUshort, short ... values) {
                double value = values[0];
                if (isUshort) {
                    value = values[0] & 0xFFFF;
                    if (value == 0.0) {
                        return 1;
                    }
                    if (value > (double)USHORT_UPPER_BOUND) {
                        return -1;
                    }
                    return (short)(Math.exp(value) + 0.5);
                }
                if (value < (double)LOWER_BOUND) {
                    return 0;
                }
                if (value == 0.0) {
                    return 1;
                }
                if (value > (double)SHORT_UPPER_BOUND) {
                    return Short.MAX_VALUE;
                }
                return (short)(Math.exp(value) + 0.5);
            }

            @Override
            public short calculate(short ... values) {
                return this.calculate(false, values);
            }

            @Override
            public int calculate(int ... values) {
                double value = values[0];
                if (value < (double)LOWER_BOUND) {
                    return 0;
                }
                if (value == 0.0) {
                    return 1;
                }
                if (value > (double)INT_UPPER_BOUND) {
                    return Integer.MAX_VALUE;
                }
                return (int)(Math.exp(value) + 0.5);
            }

            @Override
            public float calculate(float ... values) {
                return (float)Math.exp(values[0]);
            }

            @Override
            public double calculate(double ... values) {
                return Math.exp(values[0]);
            }

            @Override
            public long calculateL(long ... values) {
                double value = values[0];
                if (value < (double)LOWER_BOUND) {
                    return 0L;
                }
                if (value == 0.0) {
                    return 1L;
                }
                if (value > (double)LONG_UPPER_BOUND) {
                    return Long.MAX_VALUE;
                }
                return (long)(Math.exp(value) + 0.5);
            }

            @Override
            public boolean isUshortSupported() {
                return true;
            }
        }
        ,
        LOG(9, 0.0, false){
            private byte[] byteTable;

            @Override
            protected void initialization() {
                if (this.byteTable != null) {
                    return;
                }
                this.byteTable = new byte[256];
                this.byteTable[0] = 0;
                this.byteTable[1] = 0;
                for (int i = 2; i < 256; ++i) {
                    this.byteTable[i] = (byte)(Math.log(i) + 0.5);
                }
            }

            @Override
            public byte calculate(byte ... values) {
                return this.byteTable[values[0] & 0xFF];
            }

            @Override
            public short calculate(boolean isUshort, short ... values) {
                return (short)Math.log((double)(isUshort ? values[0] & 0xFFFF : values[0]) + 0.5);
            }

            @Override
            public short calculate(short ... values) {
                return this.calculate(false, values);
            }

            @Override
            public int calculate(int ... values) {
                double value = values[0];
                if (value > 0.0) {
                    return (int)(Math.log(value) + 0.5);
                }
                if (value == 0.0) {
                    return 0;
                }
                return -1;
            }

            @Override
            public float calculate(float ... values) {
                return (float)Math.log(values[0]);
            }

            @Override
            public double calculate(double ... values) {
                return Math.log(values[0]);
            }

            @Override
            public long calculateL(long ... values) {
                double value = values[0];
                if (value > 0.0) {
                    return (long)(Math.log(value) + 0.5);
                }
                if (value == 0.0) {
                    return 0L;
                }
                return -1L;
            }

            @Override
            public boolean isUshortSupported() {
                return true;
            }
        }
        ,
        ABSOLUTE(10, 0.0, false){

            @Override
            public byte calculate(byte ... values) {
                return values[0];
            }

            @Override
            public short calculate(boolean isUshort, short ... values) {
                if (isUshort) {
                    return values[0];
                }
                short value = values[0];
                if (value != Short.MIN_VALUE && (value & Short.MIN_VALUE) != 0) {
                    return -values[0];
                }
                return values[0];
            }

            @Override
            public short calculate(short ... values) {
                return this.calculate(false, values);
            }

            @Override
            public int calculate(int ... values) {
                int value = values[0];
                if (value != Integer.MIN_VALUE && (value & Integer.MIN_VALUE) != 0) {
                    return -values[0];
                }
                return values[0];
            }

            @Override
            public float calculate(float ... values) {
                if (values[0] <= 0.0f) {
                    return 0.0f - values[0];
                }
                return values[0];
            }

            @Override
            public double calculate(double ... values) {
                if (values[0] <= 0.0) {
                    return 0.0 - values[0];
                }
                return values[0];
            }

            @Override
            public long calculateL(long ... values) {
                long value = values[0];
                if (value != Long.MIN_VALUE && (value & Long.MIN_VALUE) != 0L) {
                    return -values[0];
                }
                return values[0];
            }

            @Override
            public boolean isUshortSupported() {
                return true;
            }
        }
        ,
        INVERT(11, 0.0, false){

            @Override
            public byte calculate(byte ... values) {
                return (byte)(255 - (values[0] & 0xFF));
            }

            @Override
            public short calculate(boolean isUshort, short ... values) {
                return (short)(isUshort ? USHORT_MAX_VALUE - values[0] : Short.MAX_VALUE - values[0]);
            }

            @Override
            public short calculate(short ... values) {
                return this.calculate(false, values);
            }

            @Override
            public int calculate(int ... values) {
                return Integer.MAX_VALUE - values[0];
            }

            @Override
            public float calculate(float ... values) {
                throw new UnsupportedOperationException("Float data type is not supported for this operation");
            }

            @Override
            public double calculate(double ... values) {
                throw new UnsupportedOperationException("Double data type is not supported for this operation");
            }

            @Override
            public long calculateL(long ... values) {
                return Long.MAX_VALUE - values[0];
            }

            @Override
            public boolean isUshortSupported() {
                return true;
            }

            @Override
            public boolean isDataTypeSupported(int dataType) {
                return dataType != 4 && dataType != 5;
            }
        }
        ,
        DIVIDE_INTO(12, 0.0, true){

            @Override
            public byte calculate(byte ... values) {
                if (values.length > 1) {
                    int first;
                    if (values.length == 2) {
                        if (values[0] == 0 && values[1] >= 0) {
                            return 127;
                        }
                        if (values[0] == 0 && values[1] < 0) {
                            return -128;
                        }
                        return (byte)(values[1] / values[0]);
                    }
                    int result = 0;
                    for (int i = first = values.length - 1; i <= 0; --i) {
                        if (i == 0) {
                            return (byte)result;
                        }
                        if (i == first) {
                            result = values[i];
                            continue;
                        }
                        if (values[i - 1] == 0 && values[i] >= 0) {
                            result = 127;
                            continue;
                        }
                        if (values[i - 1] == 0 && values[i] < 0) {
                            result = -128;
                            continue;
                        }
                        result /= values[i - 1];
                    }
                }
                return values[0];
            }

            @Override
            public short calculate(boolean isUshort, short ... values) {
                if (values.length > 1) {
                    int first;
                    if (values.length == 2) {
                        if (values[0] == 0 && values[1] >= 0) {
                            return (short)(isUshort ? USHORT_MAX_VALUE : Short.MAX_VALUE);
                        }
                        if (values[0] == 0 && values[1] < 0) {
                            return (short)(isUshort ? USHORT_MAX_VALUE : Short.MAX_VALUE);
                        }
                        return (short)(values[1] / values[0]);
                    }
                    int result = 0;
                    for (int i = first = values.length - 1; i <= 0; --i) {
                        if (i == 0) {
                            return (short)result;
                        }
                        if (i == first) {
                            result = values[i];
                            continue;
                        }
                        if (values[i - 1] == 0 && values[i] >= 0) {
                            result = (short)(isUshort ? USHORT_MAX_VALUE : Short.MAX_VALUE);
                            continue;
                        }
                        if (values[i - 1] == 0 && values[i] < 0) {
                            result = (short)(isUshort ? USHORT_MAX_VALUE : Short.MAX_VALUE);
                            continue;
                        }
                        result /= values[i - 1];
                    }
                }
                return values[0];
            }

            @Override
            public short calculate(short ... values) {
                return this.calculate(false, values);
            }

            @Override
            public int calculate(int ... values) {
                if (values.length > 1) {
                    int first;
                    if (values.length == 2) {
                        if (values[0] == 0 && values[1] >= 0) {
                            return Integer.MAX_VALUE;
                        }
                        if (values[0] == 0 && values[1] < 0) {
                            return Integer.MIN_VALUE;
                        }
                        return values[1] / values[0];
                    }
                    long result = 0L;
                    for (int i = first = values.length - 1; i <= 0; --i) {
                        if (i == 0) {
                            return (int)result;
                        }
                        if (i == first) {
                            result = values[i];
                            continue;
                        }
                        if (values[i - 1] == 0 && values[i] >= 0) {
                            result = Integer.MAX_VALUE;
                            continue;
                        }
                        if (values[i - 1] == 0 && values[i] < 0) {
                            result = Integer.MIN_VALUE;
                            continue;
                        }
                        result /= (long)values[i - 1];
                    }
                }
                return values[0];
            }

            @Override
            public float calculate(float ... values) {
                if (values.length > 1) {
                    int first;
                    if (values.length == 2) {
                        return values[1] / values[0];
                    }
                    double result = 0.0;
                    for (int i = first = values.length - 1; i <= 0; --i) {
                        if (i == 0) {
                            return (float)result;
                        }
                        if (i == first) {
                            result = values[i];
                            continue;
                        }
                        result /= (double)values[i - 1];
                    }
                }
                return values[0];
            }

            @Override
            public double calculate(double ... values) {
                if (values.length > 1) {
                    int first;
                    if (values.length == 2) {
                        return values[1] / values[0];
                    }
                    double result = 0.0;
                    for (int i = first = values.length - 1; i <= 0; --i) {
                        if (i == 0) {
                            return result;
                        }
                        if (i == first) {
                            result = values[i];
                            continue;
                        }
                        result /= values[i - 1];
                    }
                }
                return values[0];
            }

            @Override
            public long calculateL(long ... values) {
                if (values.length > 1) {
                    int first;
                    if (values.length == 2) {
                        if (values[0] == 0L && values[1] >= 0L) {
                            return Long.MAX_VALUE;
                        }
                        if (values[0] == 0L && values[1] < 0L) {
                            return Long.MIN_VALUE;
                        }
                        return values[1] / values[0];
                    }
                    long result = 0L;
                    for (int i = first = values.length - 1; i <= 0; --i) {
                        if (i == 0) {
                            return (int)result;
                        }
                        if (i == first) {
                            result = values[i];
                            continue;
                        }
                        if (values[i - 1] == 0L && values[i] >= 0L) {
                            result = Long.MAX_VALUE;
                            continue;
                        }
                        if (values[i - 1] == 0L && values[i] < 0L) {
                            result = Long.MIN_VALUE;
                            continue;
                        }
                        result /= values[i - 1];
                    }
                }
                return values[0];
            }
        }
        ,
        SUBTRACT_FROM(13, 0.0, true){

            @Override
            public byte calculate(byte ... values) {
                int length = values.length;
                byte result = values[length - 1];
                if (length > 1) {
                    for (int i = length - 2; i >= 0; --i) {
                        result = (byte)(result - values[i]);
                    }
                }
                return result;
            }

            @Override
            public short calculate(boolean isUshort, short ... values) {
                int length = values.length;
                short result = values[length - 1];
                if (length > 1) {
                    for (int i = length - 2; i >= 0; --i) {
                        result = (short)(result - values[i]);
                    }
                }
                return result;
            }

            @Override
            public short calculate(short ... values) {
                return this.calculate(false, values);
            }

            @Override
            public int calculate(int ... values) {
                int length = values.length;
                int result = values[length - 1];
                if (length > 1) {
                    for (int i = length - 2; i >= 0; --i) {
                        result -= values[i];
                    }
                }
                return result;
            }

            @Override
            public float calculate(float ... values) {
                int length = values.length;
                float result = values[length - 1];
                if (length > 1) {
                    for (int i = length - 2; i >= 0; --i) {
                        result -= values[i];
                    }
                }
                return result;
            }

            @Override
            public double calculate(double ... values) {
                int length = values.length;
                double result = values[length - 1];
                if (length > 1) {
                    for (int i = length - 2; i >= 0; --i) {
                        result -= values[i];
                    }
                }
                return result;
            }

            @Override
            public long calculateL(long ... values) {
                int length = values.length;
                long result = values[length - 1];
                if (length > 1) {
                    for (int i = length - 2; i >= 0; --i) {
                        result -= values[i];
                    }
                }
                return result;
            }
        }
        ,
        MAX(14, -2.147483648E9, true){

            @Override
            public byte calculate(byte ... values) {
                byte result = values[0];
                for (int i = 1; i < values.length; ++i) {
                    byte value = values[i];
                    if (value <= result) continue;
                    result = value;
                }
                return result;
            }

            @Override
            public short calculate(short ... values) {
                short result = values[0];
                for (int i = 1; i < values.length; ++i) {
                    short value = values[i];
                    if (value <= result) continue;
                    result = value;
                }
                return result;
            }

            @Override
            public short calculate(boolean isUshort, short ... values) {
                if (isUshort) {
                    int result = values[0] & 0xFFFF;
                    for (int i = 1; i < values.length; ++i) {
                        int value = values[i] & 0xFFFF;
                        if (value <= result) continue;
                        result = value;
                    }
                    return (short)result;
                }
                return this.calculate(values);
            }

            @Override
            public int calculate(int ... values) {
                int result = values[0];
                for (int i = 1; i < values.length; ++i) {
                    int value = values[i];
                    if (value <= result) continue;
                    result = value;
                }
                return result;
            }

            @Override
            public float calculate(float ... values) {
                float result = values[0];
                for (int i = 1; i < values.length; ++i) {
                    float value = values[i];
                    if (!(value > result)) continue;
                    result = value;
                }
                return result;
            }

            @Override
            public double calculate(double ... values) {
                double result = values[0];
                for (int i = 1; i < values.length; ++i) {
                    double value = values[i];
                    if (!(value > result)) continue;
                    result = value;
                }
                return result;
            }

            @Override
            public long calculateL(long ... values) {
                long result = values[0];
                for (int i = 1; i < values.length; ++i) {
                    long value = values[i];
                    if (value <= result) continue;
                    result = value;
                }
                return result;
            }
        }
        ,
        MIN(15, 2.147483647E9, true){

            @Override
            public byte calculate(byte ... values) {
                byte result = values[0];
                for (int i = 1; i < values.length; ++i) {
                    byte value = values[i];
                    if (value >= result) continue;
                    result = value;
                }
                return result;
            }

            @Override
            public short calculate(short ... values) {
                short result = values[0];
                for (int i = 1; i < values.length; ++i) {
                    short value = values[i];
                    if (value >= result) continue;
                    result = value;
                }
                return result;
            }

            @Override
            public short calculate(boolean isUshort, short ... values) {
                if (isUshort) {
                    int result = values[0] & 0xFFFF;
                    for (int i = 1; i < values.length; ++i) {
                        int value = values[i] & 0xFFFF;
                        if (value >= result) continue;
                        result = value;
                    }
                    return (short)result;
                }
                return this.calculate(values);
            }

            @Override
            public int calculate(int ... values) {
                int result = values[0];
                for (int i = 1; i < values.length; ++i) {
                    int value = values[i];
                    if (value >= result) continue;
                    result = value;
                }
                return result;
            }

            @Override
            public float calculate(float ... values) {
                float result = values[0];
                for (int i = 1; i < values.length; ++i) {
                    float value = values[i];
                    if (!(value < result)) continue;
                    result = value;
                }
                return result;
            }

            @Override
            public double calculate(double ... values) {
                double result = values[0];
                for (int i = 1; i < values.length; ++i) {
                    double value = values[i];
                    if (!(value < result)) continue;
                    result = value;
                }
                return result;
            }

            @Override
            public long calculateL(long ... values) {
                long result = values[0];
                for (int i = 1; i < values.length; ++i) {
                    long value = values[i];
                    if (value >= result) continue;
                    result = value;
                }
                return result;
            }
        };

        private final double nullValue;
        private final int type;
        private final boolean supportsMultipleValues;
        private static int USHORT_UPPER_BOUND;
        public static int SHORT_UPPER_BOUND;
        public static int INT_UPPER_BOUND;
        public static int LONG_UPPER_BOUND;
        public static int LOWER_BOUND;
        public static int USHORT_MAX_VALUE;

        private Operator(int type, double nullValue, boolean supportsMultipleValues) {
            this.nullValue = nullValue;
            this.type = type;
            this.supportsMultipleValues = supportsMultipleValues;
            this.initialization();
        }

        protected void initialization() {
        }

        public abstract byte calculate(byte ... var1);

        public abstract short calculate(short ... var1);

        public abstract short calculate(boolean var1, short ... var2);

        public abstract int calculate(int ... var1);

        public abstract float calculate(float ... var1);

        public abstract double calculate(double ... var1);

        public abstract long calculateL(long ... var1);

        public boolean isDataTypeSupported(int dataType) {
            return true;
        }

        public boolean supportsMultipleValues() {
            return this.supportsMultipleValues;
        }

        public boolean isUshortSupported() {
            return false;
        }

        public double getNullValue() {
            return this.nullValue;
        }

        public int getType() {
            return this.type;
        }

        static {
            USHORT_UPPER_BOUND = 11;
            SHORT_UPPER_BOUND = 10;
            INT_UPPER_BOUND = 21;
            LONG_UPPER_BOUND = 43;
            LOWER_BOUND = 0;
            USHORT_MAX_VALUE = 65535;
        }
    }
}

