/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.Matrix;
import org.geotools.api.referencing.operation.Operation;
import org.geotools.api.referencing.operation.OperationMethod;
import org.geotools.api.referencing.operation.Projection;
import org.geotools.api.util.InternationalString;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.parameter.Parameters;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.PassThroughTransform;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.util.Utilities;

public class DefaultOperationMethod
extends AbstractIdentifiedObject
implements OperationMethod {
    private static final long serialVersionUID = -98032729598205972L;
    private static final String[] LOCALIZABLES = new String[]{"formula"};
    private final InternationalString formula;
    protected final int sourceDimensions;
    protected final int targetDimensions;
    private final ParameterDescriptorGroup parameters;

    public DefaultOperationMethod(MathTransform transform) {
        this(DefaultOperationMethod.getProperties(transform), transform.getSourceDimensions(), transform.getTargetDimensions(), DefaultOperationMethod.getDescriptor(transform));
    }

    private static Map<String, ?> getProperties(MathTransform transform) {
        AbstractMathTransform mt;
        DefaultOperationMethod.ensureNonNull("transform", transform);
        if (transform instanceof AbstractMathTransform && (mt = (AbstractMathTransform)transform).getParameterDescriptors() != null) {
            return DefaultOperationMethod.getProperties((IdentifiedObject)mt.getParameterDescriptors(), null);
        }
        return Collections.singletonMap("name", Vocabulary.format((int)252));
    }

    private static ParameterDescriptorGroup getDescriptor(MathTransform transform) {
        ParameterDescriptorGroup descriptor = null;
        if (transform instanceof AbstractMathTransform) {
            descriptor = ((AbstractMathTransform)transform).getParameterDescriptors();
        }
        return descriptor;
    }

    public DefaultOperationMethod(OperationMethod method) {
        super((IdentifiedObject)method);
        this.formula = method.getFormula();
        this.parameters = method.getParameters();
        this.sourceDimensions = method.getSourceDimensions();
        this.targetDimensions = method.getTargetDimensions();
    }

    public DefaultOperationMethod(OperationMethod method, int sourceDimensions, int targetDimensions) {
        super((IdentifiedObject)method);
        this.formula = method.getFormula();
        this.parameters = method.getParameters();
        this.sourceDimensions = sourceDimensions;
        this.targetDimensions = targetDimensions;
        DefaultOperationMethod.ensurePositive("sourceDimensions", sourceDimensions);
        DefaultOperationMethod.ensurePositive("targetDimensions", targetDimensions);
    }

    public DefaultOperationMethod(Map<String, ?> properties, int sourceDimensions, int targetDimensions, ParameterDescriptorGroup parameters) {
        this(properties, new HashMap<String, Object>(), sourceDimensions, targetDimensions, parameters);
    }

    private DefaultOperationMethod(Map<String, ?> properties, Map<String, Object> subProperties, int sourceDimensions, int targetDimensions, ParameterDescriptorGroup parameters) {
        super(properties, subProperties, LOCALIZABLES);
        this.formula = (InternationalString)subProperties.get("formula");
        this.parameters = parameters;
        this.sourceDimensions = sourceDimensions;
        this.targetDimensions = targetDimensions;
        DefaultOperationMethod.ensurePositive("sourceDimensions", sourceDimensions);
        DefaultOperationMethod.ensurePositive("targetDimensions", targetDimensions);
    }

    private static void ensurePositive(String name, int value) throws IllegalArgumentException {
        if (value < 0) {
            throw new IllegalArgumentException(MessageFormat.format("Illegal argument: \"{0}={1}\".", name, value));
        }
    }

    public InternationalString getFormula() {
        return this.formula;
    }

    public int getSourceDimensions() {
        return this.sourceDimensions;
    }

    public int getTargetDimensions() {
        return this.targetDimensions;
    }

    public ParameterDescriptorGroup getParameters() {
        return this.parameters != null ? this.parameters : Parameters.EMPTY_GROUP;
    }

    Class<? extends Operation> getOperationType() {
        return Projection.class;
    }

    @Override
    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            DefaultOperationMethod that = (DefaultOperationMethod)object;
            if (this.sourceDimensions == that.sourceDimensions && this.targetDimensions == that.targetDimensions && DefaultOperationMethod.equals((IdentifiedObject)this.parameters, (IdentifiedObject)that.parameters, compareMetadata)) {
                return !compareMetadata || Utilities.equals((Object)this.formula, (Object)that.formula);
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int code = 2012209132 + this.sourceDimensions + 37 * this.targetDimensions;
        if (this.parameters != null) {
            code = code * 37 + this.parameters.hashCode();
        }
        return code;
    }

    @Override
    protected String formatWKT(Formatter formatter) {
        if (Projection.class.isAssignableFrom(this.getOperationType())) {
            return "PROJECTION";
        }
        return super.formatWKT(formatter);
    }

    private static boolean isTrivial(MathTransform transform) {
        if (transform instanceof LinearTransform) {
            Matrix matrix = ((LinearTransform)transform).getMatrix();
            int size = matrix.getNumRow();
            if (matrix.getNumCol() == size) {
                for (int j = 0; j < size; ++j) {
                    int n1 = 0;
                    int n2 = 0;
                    for (int i = 0; i < size; ++i) {
                        if (matrix.getElement(j, i) != 0.0) {
                            ++n1;
                        }
                        if (matrix.getElement(i, j) == 0.0) continue;
                        ++n2;
                    }
                    if (n1 == 1 && n2 == true) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static void checkDimensions(OperationMethod method, MathTransform transform) throws MismatchedDimensionException {
        if (method != null && transform != null) {
            String name;
            int actual;
            int expected = method.getSourceDimensions();
            while ((actual = transform.getSourceDimensions()) > expected) {
                if (transform instanceof ConcatenatedTransform) {
                    ConcatenatedTransform c = (ConcatenatedTransform)transform;
                    if (DefaultOperationMethod.isTrivial(c.transform1)) {
                        transform = c.transform2;
                        continue;
                    }
                    if (!DefaultOperationMethod.isTrivial(c.transform2)) break;
                    transform = c.transform1;
                    continue;
                }
                if (!(transform instanceof PassThroughTransform)) break;
                transform = ((PassThroughTransform)transform).getSubTransform();
            }
            if (actual != expected) {
                name = "sourceDimensions";
            } else {
                actual = transform.getTargetDimensions();
                if (actual != (expected = method.getTargetDimensions())) {
                    name = "targetDimensions";
                } else {
                    return;
                }
            }
            throw new IllegalArgumentException(MessageFormat.format("Argument \"{0}\" has {1} dimensions, while {2} was expected.", name, actual, expected));
        }
    }
}

