/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.util.Map;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.ConicProjection;
import org.geotools.api.referencing.operation.Conversion;
import org.geotools.api.referencing.operation.CoordinateOperation;
import org.geotools.api.referencing.operation.CylindricalProjection;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.Operation;
import org.geotools.api.referencing.operation.OperationMethod;
import org.geotools.api.referencing.operation.PlanarProjection;
import org.geotools.api.referencing.operation.Projection;
import org.geotools.referencing.operation.DefaultConicProjection;
import org.geotools.referencing.operation.DefaultCylindricalProjection;
import org.geotools.referencing.operation.DefaultOperation;
import org.geotools.referencing.operation.DefaultPlanarProjection;
import org.geotools.referencing.operation.DefaultProjection;
import org.geotools.referencing.operation.MathTransformProvider;

public class DefaultConversion
extends DefaultOperation
implements Conversion {
    private static final long serialVersionUID = -2148164324805562793L;

    public DefaultConversion(Conversion definition, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform) {
        super(definition, sourceCRS, targetCRS, transform);
    }

    public DefaultConversion(Map<String, ?> properties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform, OperationMethod method) {
        super(properties, sourceCRS, targetCRS, transform, method);
    }

    @Override
    void validate() throws IllegalArgumentException {
        if (this.transform != null || this.sourceCRS != null || this.targetCRS != null) {
            super.validate();
        }
    }

    public static Conversion create(Conversion definition, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform, Class<? extends Conversion> typeHint) {
        Class<? extends Operation> candidate;
        Class<? extends CoordinateOperation> type = DefaultConversion.getType((CoordinateOperation)definition);
        OperationMethod method = definition.getMethod();
        if (method instanceof MathTransformProvider && (candidate = ((MathTransformProvider)method).getOperationType()) != null && type.isAssignableFrom(candidate)) {
            type = candidate;
        }
        if (typeHint != null && type.isAssignableFrom(typeHint)) {
            type = typeHint;
        }
        if (ConicProjection.class.isAssignableFrom(type)) {
            return new DefaultConicProjection(definition, sourceCRS, targetCRS, transform);
        }
        if (CylindricalProjection.class.isAssignableFrom(type)) {
            return new DefaultCylindricalProjection(definition, sourceCRS, targetCRS, transform);
        }
        if (PlanarProjection.class.isAssignableFrom(type)) {
            return new DefaultPlanarProjection(definition, sourceCRS, targetCRS, transform);
        }
        if (Projection.class.isAssignableFrom(type)) {
            return new DefaultProjection(definition, sourceCRS, targetCRS, transform);
        }
        return new DefaultConversion(definition, sourceCRS, targetCRS, transform);
    }
}

