/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry;

import java.io.Serializable;
import java.util.Objects;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.geometry.Position;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.util.Cloneable;
import org.geotools.geometry.AbstractPosition;

public class Position1D
extends AbstractPosition
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3235094562875693710L;
    private CoordinateReferenceSystem crs;
    public double ordinate;

    public Position1D() {
    }

    public Position1D(CoordinateReferenceSystem crs) {
        this.setCoordinateReferenceSystem(crs);
    }

    public Position1D(double ordinate) {
        this.ordinate = ordinate;
    }

    public Position1D(Position point) {
        this.setLocation(point);
    }

    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        Position1D.checkCoordinateReferenceSystemDimension(crs, 1);
        this.crs = crs;
    }

    public final int getDimension() {
        return 1;
    }

    @Override
    public double[] getCoordinate() {
        return new double[]{this.ordinate};
    }

    public final double getOrdinate(int dimension) throws IndexOutOfBoundsException {
        if (dimension == 0) {
            return this.ordinate;
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    public final void setOrdinate(int dimension, double value) throws IndexOutOfBoundsException {
        if (dimension != 0) {
            throw new IndexOutOfBoundsException(String.valueOf(dimension));
        }
        this.ordinate = value;
    }

    public void setLocation(Position position) throws MismatchedDimensionException {
        AbstractPosition.ensureDimensionMatch("position", position.getDimension(), 1);
        this.setCoordinateReferenceSystem(position.getCoordinateReferenceSystem());
        this.ordinate = position.getOrdinate(0);
    }

    @Override
    public int hashCode() {
        long value = Double.doubleToLongBits(this.ordinate);
        int code = 31 + ((int)value ^ (int)(value >>> 32));
        if (this.crs != null) {
            code += this.crs.hashCode();
        }
        assert (code == super.hashCode());
        return code;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Position1D that = (Position1D)o;
        return Double.compare(that.ordinate, this.ordinate) == 0 && Objects.equals(this.crs, that.crs);
    }

    public Position1D clone() {
        try {
            return (Position1D)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError((Object)exception);
        }
    }
}

