/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.geometry.Position;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.util.Cloneable;
import org.geotools.geometry.AbstractPosition;
import org.geotools.util.SuppressFBWarnings;

public class GeneralPosition
extends AbstractPosition
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 9071833698385715524L;
    public final double[] ordinates;
    private CoordinateReferenceSystem crs;

    public GeneralPosition(CoordinateReferenceSystem crs) {
        this(crs.getCoordinateSystem().getDimension());
        this.crs = crs;
    }

    public GeneralPosition(int numDim) throws NegativeArraySizeException {
        this.ordinates = new double[numDim];
    }

    public GeneralPosition(double[] ordinates) {
        this.ordinates = (double[])ordinates.clone();
    }

    public GeneralPosition(double x, double y) {
        this.ordinates = new double[]{x, y};
    }

    public GeneralPosition(double x, double y, double z) {
        this.ordinates = new double[]{x, y, z};
    }

    public GeneralPosition(Point2D point) {
        this(point.getX(), point.getY());
    }

    public GeneralPosition(Position point) {
        this.ordinates = point.getCoordinate();
        this.crs = point.getCoordinateReferenceSystem();
    }

    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        GeneralPosition.checkCoordinateReferenceSystemDimension(crs, this.getDimension());
        this.crs = crs;
    }

    public final int getDimension() {
        return this.ordinates.length;
    }

    @Override
    public final double[] getCoordinate() {
        return (double[])this.ordinates.clone();
    }

    public final double getOrdinate(int dimension) throws IndexOutOfBoundsException {
        return this.ordinates[dimension];
    }

    public final void setOrdinate(int dimension, double value) throws IndexOutOfBoundsException {
        this.ordinates[dimension] = value;
    }

    public final void setLocation(Position position) throws MismatchedDimensionException {
        GeneralPosition.ensureDimensionMatch("position", position.getDimension(), this.ordinates.length);
        this.setCoordinateReferenceSystem(position.getCoordinateReferenceSystem());
        for (int i = 0; i < this.ordinates.length; ++i) {
            this.ordinates[i] = position.getOrdinate(i);
        }
    }

    public final void setLocation(GeneralPosition position) throws MismatchedDimensionException {
        GeneralPosition.ensureDimensionMatch("position", position.ordinates.length, this.ordinates.length);
        this.setCoordinateReferenceSystem(position.crs);
        System.arraycopy(position.ordinates, 0, this.ordinates, 0, this.ordinates.length);
    }

    public final void setLocation(Point2D point) throws MismatchedDimensionException {
        if (this.ordinates.length != 2) {
            throw new MismatchedDimensionException(MessageFormat.format("Can't wrap a {0} dimensional object into a 2 dimensional one.", this.ordinates.length));
        }
        this.ordinates[0] = point.getX();
        this.ordinates[1] = point.getY();
    }

    public Point2D toPoint2D() throws IllegalStateException {
        if (this.ordinates.length != 2) {
            throw new IllegalStateException(MessageFormat.format("Can't wrap a {0} dimensional object into a 2 dimensional one.", this.ordinates.length));
        }
        return new Point2D.Double(this.ordinates[0], this.ordinates[1]);
    }

    @Override
    public int hashCode() {
        int code = Arrays.hashCode(this.ordinates);
        if (this.crs != null) {
            code += this.crs.hashCode();
        }
        assert (code == super.hashCode());
        return code;
    }

    @SuppressFBWarnings(value={"CN_IDIOM_NO_SUPER_CALL"})
    public GeneralPosition clone() {
        return new GeneralPosition(this.ordinates);
    }
}

