/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.And;
import org.geotools.api.filter.BinaryComparisonOperator;
import org.geotools.api.filter.ExcludeFilter;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.api.filter.NativeFilter;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsGreaterThan;
import org.geotools.api.filter.PropertyIsGreaterThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLessThan;
import org.geotools.api.filter.PropertyIsLessThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.PropertyIsNil;
import org.geotools.api.filter.PropertyIsNotEqualTo;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.expression.Add;
import org.geotools.api.filter.expression.BinaryExpression;
import org.geotools.api.filter.expression.Divide;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.Multiply;
import org.geotools.api.filter.expression.NilExpression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.expression.Subtract;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.BBOX3D;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.BinarySpatialOperator;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.api.filter.temporal.After;
import org.geotools.api.filter.temporal.AnyInteracts;
import org.geotools.api.filter.temporal.Before;
import org.geotools.api.filter.temporal.Begins;
import org.geotools.api.filter.temporal.BegunBy;
import org.geotools.api.filter.temporal.BinaryTemporalOperator;
import org.geotools.api.filter.temporal.During;
import org.geotools.api.filter.temporal.EndedBy;
import org.geotools.api.filter.temporal.Ends;
import org.geotools.api.filter.temporal.Meets;
import org.geotools.api.filter.temporal.MetBy;
import org.geotools.api.filter.temporal.OverlappedBy;
import org.geotools.api.filter.temporal.TContains;
import org.geotools.api.filter.temporal.TEquals;
import org.geotools.api.filter.temporal.TOverlaps;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.visitor.ClientTransactionAccessor;
import org.geotools.util.logging.Logging;

public class PostPreProcessFilterSplittingVisitor
implements FilterVisitor,
ExpressionVisitor {
    private static final Logger logger = Logging.getLogger(PostPreProcessFilterSplittingVisitor.class);
    protected Stack<Object> postStack = new Stack();
    protected Stack<Object> preStack = new Stack();
    private Set<Object> changedStack = new HashSet<Object>();
    protected FilterCapabilities fcs = null;
    private SimpleFeatureType parent = null;
    protected Filter original = null;
    private ClientTransactionAccessor transactionAccessor;
    private FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);

    private PostPreProcessFilterSplittingVisitor() {
    }

    public PostPreProcessFilterSplittingVisitor(FilterCapabilities fcs, SimpleFeatureType parent, ClientTransactionAccessor transactionAccessor) {
        this.fcs = fcs;
        this.parent = parent;
        this.transactionAccessor = transactionAccessor;
    }

    public Filter getFilterPost() {
        if (!this.changedStack.isEmpty()) {
            return this.original;
        }
        if (this.postStack.size() > 1) {
            logger.warning("Too many post stack items after run: " + this.postStack.size());
        }
        IncludeFilter f = this.postStack.isEmpty() ? Filter.INCLUDE : (Filter)this.postStack.peek();
        return f;
    }

    public Filter getFilterPre() {
        Filter deleteFilter;
        Object f;
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        if (this.preStack.isEmpty()) {
            return Filter.INCLUDE;
        }
        if (this.preStack.size() > 1) {
            logger.warning("Too many pre stack items after run: " + this.preStack.size());
        }
        Object object = f = this.preStack.isEmpty() ? Filter.INCLUDE : (Filter)this.preStack.peek();
        if (this.transactionAccessor != null && f != null && f != Filter.EXCLUDE && (deleteFilter = this.transactionAccessor.getDeleteFilter()) != null) {
            f = deleteFilter == Filter.EXCLUDE ? Filter.EXCLUDE : ff.and((Filter)f, (Filter)ff.not(deleteFilter));
        }
        if (this.changedStack.isEmpty()) {
            return f;
        }
        Iterator<Object> iter = this.changedStack.iterator();
        Filter updateFilter = (Filter)iter.next();
        while (iter.hasNext()) {
            Filter next = (Filter)iter.next();
            if (next == Filter.INCLUDE) {
                updateFilter = next;
                break;
            }
            updateFilter = ff.or(updateFilter, next);
        }
        if (updateFilter == Filter.INCLUDE || f == Filter.INCLUDE) {
            return Filter.INCLUDE;
        }
        return ff.or((Filter)f, updateFilter);
    }

    public void visit(IncludeFilter filter) {
    }

    public void visit(ExcludeFilter filter) {
        if (this.supports(Filter.EXCLUDE)) {
            this.preStack.push(filter);
        } else {
            this.postStack.push(filter);
        }
    }

    public Object visit(PropertyIsBetween filter, Object extradata) {
        if (this.original == null) {
            this.original = filter;
        }
        if (this.supports(PropertyIsBetween.class)) {
            int i = this.postStack.size();
            Expression lowerBound = filter.getLowerBoundary();
            Expression expr = filter.getExpression();
            Expression upperBound = filter.getUpperBoundary();
            if (lowerBound == null || upperBound == null || expr == null) {
                this.postStack.push(filter);
                return null;
            }
            lowerBound.accept((ExpressionVisitor)this, null);
            if (i < this.postStack.size()) {
                this.postStack.pop();
                this.postStack.push(filter);
                return null;
            }
            expr.accept((ExpressionVisitor)this, null);
            if (i < this.postStack.size()) {
                this.preStack.pop();
                this.postStack.pop();
                this.postStack.push(filter);
                return null;
            }
            upperBound.accept((ExpressionVisitor)this, null);
            if (i < this.postStack.size()) {
                this.postStack.pop();
                this.preStack.pop();
                this.preStack.pop();
                this.postStack.push(filter);
                return null;
            }
            this.preStack.pop();
            this.preStack.pop();
            this.preStack.pop();
            this.preStack.push(filter);
        } else {
            this.postStack.push(filter);
        }
        return null;
    }

    public Object visit(PropertyIsEqualTo filter, Object notUsed) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter);
        return null;
    }

    public Object visit(PropertyIsGreaterThan filter, Object notUsed) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter);
        return null;
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object notUsed) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter);
        return null;
    }

    public Object visit(PropertyIsLessThan filter, Object notUsed) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter);
        return null;
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object notUsed) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter);
        return null;
    }

    public Object visit(PropertyIsNotEqualTo filter, Object notUsed) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter);
        return null;
    }

    protected void visitBinaryComparisonOperator(BinaryComparisonOperator filter) {
        if (this.original == null) {
            this.original = filter;
        }
        if (!this.supports(FilterCapabilities.SIMPLE_COMPARISONS_OPENGIS)) {
            this.postStack.push(filter);
            return;
        }
        int i = this.postStack.size();
        Expression leftValue = filter.getExpression1();
        Expression rightValue = filter.getExpression2();
        if (leftValue == null || rightValue == null) {
            this.postStack.push(filter);
            return;
        }
        leftValue.accept((ExpressionVisitor)this, null);
        if (i < this.postStack.size()) {
            this.postStack.pop();
            this.postStack.push(filter);
            return;
        }
        rightValue.accept((ExpressionVisitor)this, null);
        if (i < this.postStack.size()) {
            this.preStack.pop();
            this.postStack.pop();
            this.postStack.push(filter);
            return;
        }
        this.preStack.pop();
        this.preStack.pop();
        this.preStack.push(filter);
    }

    public Object visit(BBOX filter, Object notUsed) {
        if (filter instanceof BBOX3D && !this.supports(BBOX3D.class)) {
            this.postStack.push(filter);
        } else if (!this.supports(BBOX.class)) {
            this.postStack.push(filter);
        } else {
            this.preStack.push(filter);
        }
        return null;
    }

    public Object visit(Beyond filter, Object notUsed) {
        this.visitBinarySpatialOperator((BinarySpatialOperator)filter);
        return null;
    }

    public Object visit(Contains filter, Object notUsed) {
        this.visitBinarySpatialOperator((BinarySpatialOperator)filter);
        return null;
    }

    public Object visit(Crosses filter, Object notUsed) {
        this.visitBinarySpatialOperator((BinarySpatialOperator)filter);
        return null;
    }

    public Object visit(Disjoint filter, Object notUsed) {
        this.visitBinarySpatialOperator((BinarySpatialOperator)filter);
        return null;
    }

    public Object visit(DWithin filter, Object notUsed) {
        this.visitBinarySpatialOperator((BinarySpatialOperator)filter);
        return null;
    }

    public Object visit(Equals filter, Object notUsed) {
        this.visitBinarySpatialOperator((BinarySpatialOperator)filter);
        return null;
    }

    public Object visit(Intersects filter, Object notUsed) {
        this.visitBinarySpatialOperator((BinarySpatialOperator)filter);
        return null;
    }

    public Object visit(Overlaps filter, Object notUsed) {
        this.visitBinarySpatialOperator((BinarySpatialOperator)filter);
        return null;
    }

    public Object visit(Touches filter, Object notUsed) {
        this.visitBinarySpatialOperator((BinarySpatialOperator)filter);
        return null;
    }

    public Object visit(Within filter, Object notUsed) {
        this.visitBinarySpatialOperator((BinarySpatialOperator)filter);
        return null;
    }

    protected void visitBinarySpatialOperator(BinarySpatialOperator filter) {
        Class[] spatialOps;
        if (this.original == null) {
            this.original = filter;
        }
        for (Class spatialOp : spatialOps = new Class[]{Beyond.class, Contains.class, Crosses.class, Disjoint.class, DWithin.class, Equals.class, Intersects.class, Overlaps.class, Touches.class, Within.class}) {
            if (!spatialOp.isAssignableFrom(filter.getClass())) continue;
            if (this.supports(spatialOp)) break;
            this.postStack.push(filter);
            return;
        }
        int i = this.postStack.size();
        Expression leftGeometry = filter.getExpression1();
        Expression rightGeometry = filter.getExpression2();
        if (leftGeometry == null || rightGeometry == null) {
            this.postStack.push(filter);
            return;
        }
        leftGeometry.accept((ExpressionVisitor)this, null);
        if (i < this.postStack.size()) {
            this.postStack.pop();
            this.postStack.push(filter);
            return;
        }
        rightGeometry.accept((ExpressionVisitor)this, null);
        if (i < this.postStack.size()) {
            this.preStack.pop();
            this.postStack.pop();
            this.postStack.push(filter);
            return;
        }
        this.preStack.pop();
        this.preStack.pop();
        this.preStack.push(filter);
    }

    public Object visit(PropertyIsLike filter, Object notUsed) {
        if (this.original == null) {
            this.original = filter;
        }
        if (!this.supports(PropertyIsLike.class)) {
            this.postStack.push(filter);
            return null;
        }
        int i = this.postStack.size();
        filter.getExpression().accept((ExpressionVisitor)this, null);
        if (i < this.postStack.size()) {
            this.postStack.pop();
            this.postStack.push(filter);
            return null;
        }
        this.preStack.pop();
        this.preStack.push(filter);
        return null;
    }

    public Object visit(And filter, Object notUsed) {
        this.visitLogicOperator((Filter)filter, And.class);
        return null;
    }

    public Object visit(Not filter, Object notUsed) {
        this.visitLogicOperator((Filter)filter, Not.class);
        return null;
    }

    public Object visit(Or filter, Object notUsed) {
        this.visitLogicOperator((Filter)filter, Or.class);
        return null;
    }

    private void visitLogicOperator(Filter filter, Class filterInterface) {
        if (this.original == null) {
            this.original = filter;
        }
        if (!this.supports(filterInterface)) {
            this.postStack.push(filter);
            return;
        }
        int i = this.postStack.size();
        int j = this.preStack.size();
        if (filter instanceof Not) {
            if (((Not)filter).getFilter() != null) {
                Filter next = ((Not)filter).getFilter();
                next.accept((FilterVisitor)this, null);
                if (i < this.postStack.size()) {
                    this.popToSize(this.postStack, i);
                    this.popToSize(this.preStack, j);
                    this.postStack.push(filter);
                } else {
                    this.popToSize(this.preStack, j);
                    this.preStack.push(filter);
                }
            }
        } else if (filter instanceof Or) {
            try {
                Filter orReplacement = this.translateOr((Or)filter);
                orReplacement.accept((FilterVisitor)this, null);
            }
            catch (IllegalFilterException e) {
                this.popToSize(this.preStack, j);
                this.postStack.push(filter);
                return;
            }
            if (this.postStack.size() > i) {
                this.popToSize(this.postStack, i);
                this.postStack.push(filter);
                return;
            }
            this.preStack.pop();
            this.preStack.push(filter);
        } else {
            for (Filter next : ((And)filter).getChildren()) {
                next.accept((FilterVisitor)this, null);
            }
            if (i < this.postStack.size()) {
                if (filter instanceof And) {
                    Filter f = (Filter)this.postStack.pop();
                    while (this.postStack.size() > i) {
                        f = this.ff.and(f, (Filter)this.postStack.pop());
                    }
                    this.postStack.push(f);
                    if (j < this.preStack.size()) {
                        f = (Filter)this.preStack.pop();
                        while (this.preStack.size() > j) {
                            f = this.ff.and(f, (Filter)this.preStack.pop());
                        }
                        this.preStack.push(f);
                    }
                } else {
                    logger.warning("LogicFilter found which is not 'and, or, not");
                    this.popToSize(this.postStack, i);
                    this.popToSize(this.preStack, j);
                    this.postStack.push(filter);
                }
            } else {
                this.popToSize(this.preStack, j);
                this.preStack.push(filter);
            }
        }
    }

    private void popToSize(Stack stack, int j) {
        while (j < stack.size()) {
            stack.pop();
        }
    }

    public Object visitNullFilter(Object notUsed) {
        return null;
    }

    public Object visit(IncludeFilter filter, Object notUsed) {
        return null;
    }

    public Object visit(ExcludeFilter filter, Object notUsed) {
        if (this.supports(Filter.EXCLUDE)) {
            this.preStack.push(filter);
        } else {
            this.postStack.push(filter);
        }
        return null;
    }

    public Object visit(PropertyIsNil filter, Object extraData) {
        return this.visitNullNil((Filter)filter, filter.getExpression());
    }

    public Object visit(PropertyIsNull filter, Object notUsed) {
        return this.visitNullNil((Filter)filter, filter.getExpression());
    }

    Object visitNullNil(Filter filter, Expression e) {
        if (this.original == null) {
            this.original = filter;
        }
        if (!this.supports(PropertyIsNull.class)) {
            this.postStack.push(filter);
            return null;
        }
        int i = this.postStack.size();
        e.accept((ExpressionVisitor)this, null);
        if (i < this.postStack.size()) {
            this.postStack.pop();
            this.postStack.push(filter);
            return null;
        }
        this.preStack.pop();
        this.preStack.push(filter);
        return null;
    }

    public Object visit(Id filter, Object notUsed) {
        if (this.original == null) {
            this.original = filter;
        }
        if (!this.supports(filter)) {
            this.postStack.push(filter);
        } else {
            this.preStack.push(filter);
        }
        return null;
    }

    public Object visit(PropertyName expression, Object notUsed) {
        if (this.parent != null && expression.evaluate((Object)this.parent) == null) {
            throw new IllegalArgumentException("Property '" + expression.getPropertyName() + "' could not be found in " + this.parent.getTypeName());
        }
        if (this.transactionAccessor != null) {
            Filter updateFilter = this.transactionAccessor.getUpdateFilter(expression.getPropertyName());
            if (updateFilter != null) {
                this.changedStack.add(updateFilter);
                this.preStack.push(updateFilter);
            } else {
                this.preStack.push(expression);
            }
        } else {
            this.preStack.push(expression);
        }
        return null;
    }

    public Object visit(Literal expression, Object notUsed) {
        this.preStack.push(expression);
        return null;
    }

    public Object visit(Add filter, Object notUsed) {
        this.visitMathExpression((BinaryExpression)filter);
        return null;
    }

    public Object visit(Divide filter, Object notUsed) {
        this.visitMathExpression((BinaryExpression)filter);
        return null;
    }

    public Object visit(Multiply filter, Object notUsed) {
        this.visitMathExpression((BinaryExpression)filter);
        return null;
    }

    public Object visit(Subtract filter, Object notUsed) {
        this.visitMathExpression((BinaryExpression)filter);
        return null;
    }

    protected void visitMathExpression(BinaryExpression expression) {
        if (!(this.supports(Add.class) || this.supports(Subtract.class) || this.supports(Multiply.class) || this.supports(Divide.class))) {
            this.postStack.push(expression);
            return;
        }
        int i = this.postStack.size();
        Expression leftValue = expression.getExpression1();
        Expression rightValue = expression.getExpression2();
        if (leftValue == null || rightValue == null) {
            this.postStack.push(expression);
            return;
        }
        leftValue.accept((ExpressionVisitor)this, null);
        if (i < this.postStack.size()) {
            this.postStack.pop();
            this.postStack.push(expression);
            return;
        }
        rightValue.accept((ExpressionVisitor)this, null);
        if (i < this.postStack.size()) {
            this.preStack.pop();
            this.postStack.pop();
            this.postStack.push(expression);
            return;
        }
        this.preStack.pop();
        this.preStack.pop();
        this.preStack.push(expression);
    }

    public Object visit(Function expression, Object notUsed) {
        if (!this.supports(expression)) {
            this.postStack.push(expression);
            return null;
        }
        if (expression.getName() == null) {
            this.postStack.push(expression);
            return null;
        }
        int i = this.postStack.size();
        int j = this.preStack.size();
        for (int k = 0; k < expression.getParameters().size(); ++k) {
            ((Expression)expression.getParameters().get(k)).accept((ExpressionVisitor)this, null);
            if (i >= this.postStack.size()) continue;
            while (j < this.preStack.size()) {
                this.preStack.pop();
            }
            this.postStack.pop();
            this.postStack.push(expression);
            return null;
        }
        while (j < this.preStack.size()) {
            this.preStack.pop();
        }
        this.preStack.push(expression);
        return null;
    }

    public Object visit(NilExpression nilExpression, Object notUsed) {
        this.postStack.push(nilExpression);
        return null;
    }

    private Filter translateOr(Or filter) throws IllegalFilterException {
        if (!(filter instanceof Or)) {
            return filter;
        }
        Iterator i = filter.getChildren().iterator();
        ArrayList<Object> translated = new ArrayList<Object>();
        while (i.hasNext()) {
            Filter f = (Filter)i.next();
            if (f instanceof Not) {
                Not logic = (Not)f;
                Filter next = logic.getFilter();
                translated.add(next);
                continue;
            }
            translated.add(this.ff.not(f));
        }
        And and = this.ff.and(translated);
        return this.ff.not((Filter)and);
    }

    public Object visit(After after, Object extraData) {
        return this.visit((BinaryTemporalOperator)after, extraData);
    }

    public Object visit(AnyInteracts anyInteracts, Object extraData) {
        return this.visit((BinaryTemporalOperator)anyInteracts, extraData);
    }

    public Object visit(Before before, Object extraData) {
        return this.visit((BinaryTemporalOperator)before, extraData);
    }

    public Object visit(Begins begins, Object extraData) {
        return this.visit((BinaryTemporalOperator)begins, extraData);
    }

    public Object visit(BegunBy begunBy, Object extraData) {
        return this.visit((BinaryTemporalOperator)begunBy, extraData);
    }

    public Object visit(During during, Object extraData) {
        return this.visit((BinaryTemporalOperator)during, extraData);
    }

    public Object visit(EndedBy endedBy, Object extraData) {
        return this.visit((BinaryTemporalOperator)endedBy, extraData);
    }

    public Object visit(Ends ends, Object extraData) {
        return this.visit((BinaryTemporalOperator)ends, extraData);
    }

    public Object visit(Meets meets, Object extraData) {
        return this.visit((BinaryTemporalOperator)meets, extraData);
    }

    public Object visit(MetBy metBy, Object extraData) {
        return this.visit((BinaryTemporalOperator)metBy, extraData);
    }

    public Object visit(OverlappedBy overlappedBy, Object extraData) {
        return this.visit((BinaryTemporalOperator)overlappedBy, extraData);
    }

    public Object visit(TContains contains, Object extraData) {
        return this.visit((BinaryTemporalOperator)contains, extraData);
    }

    public Object visit(TEquals equals, Object extraData) {
        return this.visit((BinaryTemporalOperator)equals, extraData);
    }

    public Object visit(TOverlaps contains, Object extraData) {
        return this.visit((BinaryTemporalOperator)contains, extraData);
    }

    protected Object visit(BinaryTemporalOperator filter, Object data) {
        if (this.original == null) {
            this.original = filter;
        }
        if (!this.supports(filter)) {
            this.postStack.push(filter);
            return null;
        }
        Expression leftValue = filter.getExpression1();
        Expression rightValue = filter.getExpression2();
        int i = this.postStack.size();
        if (leftValue == null || rightValue == null) {
            this.postStack.push(filter);
            return null;
        }
        leftValue.accept((ExpressionVisitor)this, null);
        if (i < this.postStack.size()) {
            this.postStack.pop();
            this.postStack.push(filter);
            return null;
        }
        rightValue.accept((ExpressionVisitor)this, null);
        if (i < this.postStack.size()) {
            this.preStack.pop();
            this.postStack.pop();
            this.postStack.push(filter);
            return null;
        }
        this.preStack.pop();
        this.preStack.pop();
        this.preStack.push(filter);
        return null;
    }

    public Object visit(NativeFilter nativeFilter, Object extraData) {
        this.preStack.push(nativeFilter);
        return null;
    }

    protected boolean supports(Object value) {
        boolean supports = false;
        if (value instanceof Class) {
            supports = this.fcs.supports((Class)value);
        } else if (value instanceof Filter) {
            supports = this.fcs.supports((Filter)value);
        } else if (value instanceof Expression) {
            supports = this.fcs.supports(value.getClass());
        } else if (value instanceof FilterCapabilities) {
            supports = this.fcs.supports((FilterCapabilities)value);
        }
        return supports;
    }
}

