/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.identity;

import org.geotools.api.filter.identity.FeatureId;
import org.geotools.filter.identity.FeatureIdImpl;

public class FeatureIdVersionedImpl
extends FeatureIdImpl {
    protected String featureVersion;
    protected String previousRid;

    public FeatureIdVersionedImpl(String fid, String version) {
        this(fid, version, null);
    }

    public FeatureIdVersionedImpl(String fid, String version, String previousRid) {
        super(fid);
        this.featureVersion = version;
        this.previousRid = previousRid;
    }

    @Override
    public String toString() {
        return this.fid;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof FeatureId) {
            return this.fid.equals(((FeatureId)obj).getID());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.fid.hashCode();
    }

    @Override
    public boolean equalsExact(FeatureId id) {
        if (id instanceof FeatureId) {
            return this.fid.equals(id.getID()) && this.fid.equals(id.getRid()) && id.getPreviousRid() == null && id.getFeatureVersion() == null;
        }
        return false;
    }

    @Override
    public boolean equalsFID(FeatureId id) {
        if (id == null) {
            return false;
        }
        return this.getID().equals(id.getID());
    }

    @Override
    public String getRid() {
        return this.featureVersion == null ? this.getID() : this.getID() + '@' + this.featureVersion;
    }

    @Override
    public String getPreviousRid() {
        return this.previousRid;
    }

    @Override
    public String getFeatureVersion() {
        return this.featureVersion;
    }
}

