/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.util.logging.Logging;

public class LikeToRegexConverter {
    static final Logger LOGGER = Logging.getLogger(String.class);
    String pattern;

    public LikeToRegexConverter(PropertyIsLike like) {
        char esc;
        String pattern = like.getLiteral();
        String wildcardMulti = like.getWildCard();
        String wildcardSingle = like.getSingleChar();
        String escape = like.getEscape();
        char c = esc = escape.isEmpty() ? (char)'\u0000' : escape.charAt(0);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("wildcard " + wildcardMulti + " single " + wildcardSingle);
            LOGGER.finer("escape " + escape + " esc " + esc + " esc == \\ " + (esc == '\\'));
        }
        String escapedWildcardMulti = this.fixSpecials(wildcardMulti, escape);
        String escapedWildcardSingle = this.fixSpecials(wildcardSingle, escape);
        StringBuffer tmp = new StringBuffer("");
        boolean escapedMode = false;
        for (int i = 0; i < pattern.length(); ++i) {
            char chr = pattern.charAt(i);
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("tmp = " + tmp + " looking at " + chr);
            }
            if (!escape.isEmpty() && pattern.regionMatches(false, i, escape, 0, escape.length())) {
                LOGGER.finer("escape ");
                escapedMode = true;
                chr = pattern.charAt(i += escape.length());
            }
            if (pattern.regionMatches(false, i, wildcardMulti, 0, wildcardMulti.length())) {
                LOGGER.finer("multi wildcard");
                if (escapedMode) {
                    LOGGER.finer("escaped ");
                    tmp.append(escapedWildcardMulti);
                } else {
                    tmp.append(".*");
                }
                i += wildcardMulti.length() - 1;
                escapedMode = false;
                continue;
            }
            if (pattern.regionMatches(false, i, wildcardSingle, 0, wildcardSingle.length())) {
                LOGGER.finer("single wildcard");
                if (escapedMode) {
                    LOGGER.finer("escaped ");
                    tmp.append(escapedWildcardSingle);
                } else {
                    tmp.append(".{1}");
                }
                i += wildcardSingle.length() - 1;
                escapedMode = false;
                continue;
            }
            if (this.isSpecial(chr) && !escape.isEmpty()) {
                LOGGER.finer("special");
                tmp.append(escape + chr);
                escapedMode = false;
                continue;
            }
            tmp.append(chr);
            escapedMode = false;
        }
        pattern = tmp.toString();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("final pattern " + pattern);
        }
        this.pattern = pattern;
    }

    private boolean isSpecial(char chr) {
        return chr == '.' || chr == '?' || chr == '*' || chr == '^' || chr == '$' || chr == '+' || chr == '[' || chr == ']' || chr == '(' || chr == ')' || chr == '|' || chr == '\\';
    }

    private String fixSpecials(String inString, String escape) {
        StringBuffer tmp = new StringBuffer("");
        for (int i = 0; i < inString.length(); ++i) {
            char chr = inString.charAt(i);
            if (this.isSpecial(chr)) {
                tmp.append(escape + chr);
                continue;
            }
            tmp.append(chr);
        }
        return tmp.toString();
    }

    public String getPattern() {
        return this.pattern;
    }
}

