/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.MultiValuedFilter;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.BinarySpatialOperator;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.filter.BinaryComparisonAbstract;
import org.geotools.util.Converters;
import org.locationtech.jts.geom.Geometry;

public abstract class GeometryFilterImpl
extends BinaryComparisonAbstract
implements BinarySpatialOperator {
    protected MultiValuedFilter.MatchAction matchAction;

    protected GeometryFilterImpl(MultiValuedFilter.MatchAction matchAction) {
        this.matchAction = matchAction;
    }

    protected GeometryFilterImpl(Expression e1, Expression e2, MultiValuedFilter.MatchAction matchAction) {
        super(e1, e2);
        this.matchAction = matchAction;
    }

    protected GeometryFilterImpl(FilterFactory factory) {
        this(MultiValuedFilter.MatchAction.ANY);
    }

    protected GeometryFilterImpl(Expression e1, Expression e2) {
        this(e1, e2, MultiValuedFilter.MatchAction.ANY);
    }

    protected static Object getGeometries(Expression expr, Object feature) {
        Object o = expr.evaluate(feature);
        if (o instanceof Collection) {
            ArrayList<Geometry> list = new ArrayList<Geometry>();
            Collection cast = (Collection)o;
            for (Object item : cast) {
                Geometry geometry = (Geometry)Converters.convert(item, Geometry.class);
                if (geometry == null) continue;
                list.add(geometry);
            }
            return list.isEmpty() ? null : list;
        }
        return Converters.convert((Object)o, Geometry.class);
    }

    public String toString() {
        String operator = null;
        if (this instanceof Equals) {
            operator = " equals ";
        } else if (this instanceof Disjoint) {
            operator = " disjoint ";
        } else if (this instanceof Intersects) {
            operator = " intersects ";
        } else if (this instanceof Touches) {
            operator = " touches ";
        } else if (this instanceof Crosses) {
            operator = " crosses ";
        } else if (this instanceof Within) {
            operator = " within ";
        } else if (this instanceof Contains) {
            operator = " contains ";
        } else if (this instanceof Overlaps) {
            operator = " overlaps ";
        } else if (this instanceof Beyond) {
            operator = " beyond ";
        } else if (this instanceof BBOX) {
            operator = " bbox ";
        }
        Expression leftGeometry = this.getExpression1();
        Expression rightGeometry = this.getExpression2();
        if (this.expression1 == null && rightGeometry == null) {
            return "[ null" + operator + "null ]";
        }
        if (leftGeometry == null) {
            return "[ null" + operator + rightGeometry.toString() + " ]";
        }
        if (rightGeometry == null) {
            return "[ " + leftGeometry.toString() + operator + "null ]";
        }
        return "[ " + leftGeometry.toString() + operator + rightGeometry.toString() + " ]";
    }

    public boolean equals(Object obj) {
        if (this.getClass().isInstance(obj)) {
            GeometryFilterImpl geomFilter = (GeometryFilterImpl)obj;
            return Objects.equals(geomFilter.expression1, this.expression1) && Objects.equals(geomFilter.expression2, this.expression2);
        }
        return false;
    }

    public int hashCode() {
        Expression leftGeometry = this.getExpression1();
        Expression rightGeometry = this.getExpression2();
        int result = 17;
        result = 37 * result + this.getClass().hashCode();
        result = 37 * result + (leftGeometry == null ? 0 : leftGeometry.hashCode());
        result = 37 * result + (rightGeometry == null ? 0 : rightGeometry.hashCode());
        return result;
    }

    @Override
    public MultiValuedFilter.MatchAction getMatchAction() {
        return this.matchAction;
    }

    public final boolean evaluate(Object feature) {
        Object object1 = GeometryFilterImpl.getGeometries(this.getExpression1(), feature);
        Object object2 = GeometryFilterImpl.getGeometries(this.getExpression2(), feature);
        if (object1 == null || object2 == null) {
            return false;
        }
        if (!(object1 instanceof Collection) && !(object2 instanceof Collection)) {
            return this.evaluateInternal((Geometry)object1, (Geometry)object2);
        }
        List<Geometry> leftValues = object1 instanceof Collection ? (List<Geometry>)object1 : Collections.singletonList((Geometry)object1);
        List<Geometry> rightValues = object2 instanceof Collection ? (List<Geometry>)object2 : Collections.singletonList((Geometry)object2);
        int count = 0;
        for (Geometry leftValue : leftValues) {
            for (Geometry rightValue : rightValues) {
                boolean temp = this.evaluateInternal(leftValue, rightValue);
                if (temp) {
                    ++count;
                }
                switch (this.matchAction) {
                    case ONE: {
                        if (count <= 1) break;
                        return false;
                    }
                    case ALL: {
                        if (temp) break;
                        return false;
                    }
                    case ANY: {
                        if (!temp) break;
                        return true;
                    }
                }
            }
        }
        switch (this.matchAction) {
            case ONE: {
                return count == 1;
            }
            case ALL: {
                return true;
            }
            case ANY: {
                return false;
            }
        }
        return false;
    }

    protected abstract boolean evaluateInternal(Geometry var1, Geometry var2);
}

