/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.filter.expression.Expression;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.FeatureCalc;

public class QuantileListVisitor
implements FeatureCalc {
    private Expression expr;
    private int count = 0;
    private int bins;
    private List<Comparable> items = new ArrayList<Comparable>();
    private List<Comparable>[] bin;
    boolean visited = false;
    int countNull = 0;
    int countNaN = 0;

    public QuantileListVisitor(Expression expr, int bins) {
        this.expr = expr;
        this.bins = bins;
        this.bin = new ArrayList[bins];
    }

    public void init(SimpleFeatureCollection collection) {
    }

    @Override
    public CalcResult getResult() {
        if (this.bins == 0 || this.count == 0) {
            return CalcResult.NULL_RESULT;
        }
        Collections.sort(this.items);
        if (this.bins > this.count) {
            this.bins = this.count;
            this.bin = new ArrayList[this.bins];
        }
        int binPop = (int)Math.ceil((double)this.count / (double)this.bins);
        int lastBigBin = this.count % this.bins;
        lastBigBin = lastBigBin == 0 ? this.bins : --lastBigBin;
        int item = 0;
        for (int binIndex = 0; binIndex < this.bins; ++binIndex) {
            this.bin[binIndex] = new ArrayList<Comparable>();
            for (int binMember = 0; binMember < binPop; ++binMember) {
                this.bin[binIndex].add(this.items.get(item++));
            }
            if (lastBigBin != binIndex) continue;
            --binPop;
        }
        return new AbstractCalcResult(){

            @Override
            public Object getValue() {
                return QuantileListVisitor.this.bin;
            }
        };
    }

    public void visit(SimpleFeature feature) {
        this.visit((Feature)feature);
    }

    public void visit(Feature feature) {
        double doubleVal;
        Object value = this.expr.evaluate((Object)feature);
        if (value == null) {
            ++this.countNull;
            return;
        }
        if (value instanceof Double && (Double.isNaN(doubleVal = ((Double)value).doubleValue()) || Double.isInfinite(doubleVal))) {
            ++this.countNaN;
            return;
        }
        ++this.count;
        Comparable cast = (Comparable)value;
        this.items.add(cast);
    }

    public void reset(int bins) {
        this.bins = bins;
        this.count = 0;
        this.items = new ArrayList<Comparable>();
        this.bin = new List[bins];
        this.countNull = 0;
        this.countNaN = 0;
    }

    public int getNaNCount() {
        return this.countNaN;
    }

    public int getNullCount() {
        return this.countNull;
    }
}

