/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import org.geotools.api.feature.type.Name;
import org.geotools.feature.NameImpl;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.factory.Hints;

public class NameConverterFactory
implements ConverterFactory {
    public Converter createConverter(Class source, Class target, Hints hints) {
        if (target.equals(String.class) && source.equals(Name.class)) {
            return new Converter(){

                public <T> T convert(Object source, Class<T> target) throws Exception {
                    Name name = (Name)source;
                    return target.cast(name.getURI());
                }
            };
        }
        if (target.equals(Name.class) && source.equals(String.class)) {
            return new Converter(){

                public <T> T convert(Object source, Class<T> target) throws Exception {
                    String str = (String)source;
                    String[] split = str.split(":");
                    if (split.length == 2) {
                        return target.cast(new NameImpl(split[0], split[1]));
                    }
                    if (split.length == 1) {
                        return target.cast(new NameImpl(str));
                    }
                    return null;
                }
            };
        }
        return null;
    }
}

