/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.geotools.api.feature.IllegalAttributeException;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.OperationNotFoundException;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.util.factory.FactoryRegistryException;
import org.locationtech.jts.geom.Geometry;

public class ReprojectingIterator
implements Iterator<SimpleFeature> {
    Iterator<SimpleFeature> delegate;
    CoordinateReferenceSystem target;
    SimpleFeatureType schema;
    GeometryCoordinateSequenceTransformer tx;

    public ReprojectingIterator(Iterator<SimpleFeature> delegate, MathTransform transform, SimpleFeatureType schema, GeometryCoordinateSequenceTransformer transformer) throws OperationNotFoundException, FactoryRegistryException, FactoryException {
        this.delegate = delegate;
        this.schema = schema;
        this.tx = transformer;
        this.tx.setMathTransform(transform);
    }

    public ReprojectingIterator(Iterator<SimpleFeature> delegate, CoordinateReferenceSystem source, CoordinateReferenceSystem target, SimpleFeatureType schema, GeometryCoordinateSequenceTransformer transformer) throws OperationNotFoundException, FactoryRegistryException, FactoryException {
        this.delegate = delegate;
        this.target = target;
        this.schema = schema;
        this.tx = transformer;
        MathTransform transform = ReferencingFactoryFinder.getCoordinateOperationFactory(null).createOperation(source, target).getMathTransform();
        this.tx.setMathTransform(transform);
    }

    public Iterator<SimpleFeature> getDelegate() {
        return this.delegate;
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public SimpleFeature next() {
        SimpleFeature feature = this.delegate.next();
        try {
            return this.reproject(feature);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    SimpleFeature reproject(SimpleFeature feature) throws IOException {
        List attributes = feature.getAttributes();
        for (int i = 0; i < attributes.size(); ++i) {
            Object object = attributes.get(i);
            if (!(object instanceof Geometry)) continue;
            Geometry geometry = (Geometry)object;
            try {
                attributes.set(i, this.tx.transform(geometry));
                continue;
            }
            catch (TransformException e) {
                String msg = "Error occured transforming " + geometry.toString();
                throw (IOException)new IOException(msg).initCause(e);
            }
        }
        try {
            return SimpleFeatureBuilder.build(this.schema, attributes, feature.getID());
        }
        catch (IllegalAttributeException e) {
            String msg = "Error creating reprojeced feature";
            throw (IOException)new IOException(msg).initCause(e);
        }
    }
}

