/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.sort;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ByteArrayInStream;
import org.locationtech.jts.io.InStream;
import org.locationtech.jts.io.OutStream;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;

public class SimpleFeatureIO {
    public static final int MAX_BYTES_LENGTH = 65535;
    public static final String BIG_STRING = "bigString";
    public static final String ENABLE_DESERIALIZATION = "geotools.simplefeatureio.deserialization";
    RandomAccessFile raf;
    SimpleFeatureType schema;
    SimpleFeatureBuilder builder;
    File file;
    WKBWriter writer = new WKBWriter();
    WKBReader reader = new WKBReader();
    ByteArrayInStream bis;
    ByteArrayOutStream bos;
    byte[] buffer = new byte[8192];
    private final boolean initialFileEmpty;
    private final String enableDeserialization;

    public SimpleFeatureIO(File file, SimpleFeatureType schema) throws FileNotFoundException {
        this.file = file;
        this.raf = new RandomAccessFile(file, "rw");
        this.schema = schema;
        this.builder = new SimpleFeatureBuilder(schema);
        this.initialFileEmpty = this.file.length() <= 0L;
        this.enableDeserialization = System.getProperty(ENABLE_DESERIALIZATION);
    }

    public void write(SimpleFeature sf) throws IOException {
        List attributes = this.schema.getAttributeDescriptors();
        this.raf.writeUTF(sf.getID());
        for (AttributeDescriptor ad : attributes) {
            Object value = sf.getAttribute(ad.getLocalName());
            this.writeAttribute(ad, value);
        }
    }

    void writeAttribute(AttributeDescriptor ad, Object value) throws IOException {
        if (value == null) {
            this.raf.writeBoolean(true);
        } else {
            this.raf.writeBoolean(false);
            Class binding = ad.getType().getBinding();
            if (binding == Boolean.class) {
                this.raf.writeBoolean((Boolean)value);
            } else if (binding == Byte.class || binding == Byte.TYPE) {
                this.raf.writeByte(((Byte)value).byteValue());
            } else if (binding == Short.class || binding == Short.TYPE) {
                this.raf.writeShort(((Short)value).shortValue());
            } else if (binding == Integer.class || binding == Integer.TYPE) {
                this.raf.writeInt((Integer)value);
            } else if (binding == Long.class || binding == Long.TYPE) {
                this.raf.writeLong((Long)value);
            } else if (binding == Float.class || binding == Float.TYPE) {
                this.raf.writeFloat(((Float)value).floatValue());
            } else if (binding == Double.class || binding == Double.TYPE) {
                this.raf.writeDouble((Double)value);
            } else if (binding == String.class) {
                if (this.isBigString(ad)) {
                    String strVal = (String)value;
                    ArrayList<String> values = new ArrayList<String>();
                    if (strVal.getBytes().length >= 65535) {
                        values.addAll(this.split(strVal, Short.MAX_VALUE));
                    } else {
                        values.add(strVal);
                    }
                    this.raf.writeInt(values.size());
                    for (String evalue : values) {
                        this.raf.writeUTF(evalue);
                    }
                } else {
                    this.raf.writeUTF((String)value);
                }
            } else if (binding == Date.class || binding == Time.class || binding == Timestamp.class || binding == java.util.Date.class) {
                this.raf.writeLong(((java.util.Date)value).getTime());
            } else if (Geometry.class.isAssignableFrom(binding)) {
                ByteArrayOutStream os = this.getOutStream(this.buffer);
                this.writer.write((Geometry)value, (OutStream)os);
                int len = os.getPosition();
                this.raf.writeInt(len);
                this.raf.write(os.getBuffer(), 0, len);
            } else {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(value);
                oos.flush();
                byte[] bytes = bos.toByteArray();
                this.raf.writeInt(bytes.length);
                this.raf.write(bytes);
            }
        }
    }

    private boolean isBigString(AttributeDescriptor ad) {
        return ad.getUserData() != null && ad.getUserData().containsKey(BIG_STRING) && ad.getUserData().get(BIG_STRING) instanceof Boolean && (Boolean)ad.getUserData().get(BIG_STRING) != false;
    }

    public SimpleFeature read() throws IOException {
        String fid = this.raf.readUTF();
        for (AttributeDescriptor ad : this.schema.getAttributeDescriptors()) {
            Object att = this.readAttribute(ad);
            this.builder.add(att);
        }
        return this.builder.buildFeature(fid);
    }

    Object readAttribute(AttributeDescriptor ad) throws IOException {
        boolean isNull = this.raf.readBoolean();
        if (isNull) {
            return null;
        }
        Class binding = ad.getType().getBinding();
        if (binding == Boolean.class) {
            return this.raf.readBoolean();
        }
        if (binding == Byte.class || binding == Byte.TYPE) {
            return this.raf.readByte();
        }
        if (binding == Short.class || binding == Short.TYPE) {
            return this.raf.readShort();
        }
        if (binding == Integer.class || binding == Integer.TYPE) {
            return this.raf.readInt();
        }
        if (binding == Long.class || binding == Long.TYPE) {
            return this.raf.readLong();
        }
        if (binding == Float.class || binding == Float.TYPE) {
            return Float.valueOf(this.raf.readFloat());
        }
        if (binding == Double.class || binding == Double.TYPE) {
            return this.raf.readDouble();
        }
        if (binding == String.class) {
            if (this.isBigString(ad)) {
                int parts = this.raf.readInt();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < parts; ++i) {
                    sb.append(this.raf.readUTF());
                }
                return sb.toString();
            }
            return this.raf.readUTF();
        }
        if (binding == Date.class) {
            return new Date(this.raf.readLong());
        }
        if (binding == Time.class) {
            return new Time(this.raf.readLong());
        }
        if (binding == Timestamp.class) {
            return new Timestamp(this.raf.readLong());
        }
        if (binding == java.util.Date.class) {
            return new java.util.Date(this.raf.readLong());
        }
        if (Geometry.class.isAssignableFrom(binding)) {
            int length = this.raf.readInt();
            byte[] buffer = this.getByteBuffer(length);
            this.raf.read(buffer, 0, length);
            try {
                return this.reader.read(this.getInStream(buffer));
            }
            catch (ParseException e) {
                throw new IOException("Failed to parse the geometry WKB", e);
            }
        }
        return this.readObject();
    }

    private ByteArrayOutStream getOutStream(byte[] buffer) {
        if (this.bos == null) {
            this.bos = new ByteArrayOutStream(buffer);
        } else {
            this.bos.setBuffer(buffer);
        }
        return this.bos;
    }

    private InStream getInStream(byte[] buffer) {
        if (this.bis == null) {
            this.bis = new ByteArrayInStream(buffer);
        } else {
            this.bis.setBytes(buffer);
        }
        return this.bis;
    }

    private byte[] getByteBuffer(int length) {
        byte[] buffer = length < this.buffer.length ? this.buffer : new byte[length];
        return buffer;
    }

    private Object readObject() throws IOException {
        if ("false".equalsIgnoreCase(this.enableDeserialization)) {
            throw new IllegalStateException("Object deserialization is not allowed");
        }
        if (!this.initialFileEmpty && !"true".equalsIgnoreCase(this.enableDeserialization)) {
            throw new IllegalStateException("Object deserialization is only allowed when created with an empty file");
        }
        int length = this.raf.readInt();
        byte[] buffer = new byte[length];
        this.raf.read(buffer);
        ByteArrayInputStream bis = new ByteArrayInputStream(buffer);
        ObjectInputStream ois = new ObjectInputStream(bis);
        try {
            return ois.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Could not read back object", e);
        }
    }

    public void seek(long offset) throws IOException {
        this.raf.seek(offset);
    }

    public long getOffset() throws IOException {
        return this.raf.getFilePointer();
    }

    public boolean endOfFile() throws IOException {
        return this.getOffset() >= this.raf.length();
    }

    public void close(boolean deleteFile) throws IOException {
        try {
            this.raf.close();
        }
        finally {
            if (deleteFile) {
                this.file.delete();
            }
        }
    }

    public String toString() {
        return "SimpleFeatureIO [schema=" + this.schema + ", file=" + this.file + "]";
    }

    private Collection<String> split(String value, int charSize) {
        ArrayList<String> strings = new ArrayList<String>();
        for (int index = 0; index < value.length(); index += charSize) {
            strings.add(value.substring(index, Math.min(index + charSize, value.length())));
        }
        return strings;
    }

    private class ByteArrayOutStream
    implements OutStream {
        byte[] buffer;
        int position;

        public ByteArrayOutStream(byte[] buffer) {
            this.setBuffer(buffer);
        }

        public void setBuffer(byte[] buffer) {
            this.buffer = buffer;
            this.position = 0;
        }

        public void write(byte[] bytes, int len) throws IOException {
            if (this.position + len >= this.buffer.length) {
                this.grow(this.position + len);
            }
            System.arraycopy(bytes, 0, this.buffer, this.position, len);
            this.position += len;
        }

        private void grow(int minCapacity) {
            if (minCapacity < 0) {
                throw new OutOfMemoryError();
            }
            int oldCapacity = this.buffer.length;
            int newCapacity = oldCapacity << 1;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            this.buffer = Arrays.copyOf(this.buffer, newCapacity);
        }

        public int getPosition() {
            return this.position;
        }

        public byte[] getBuffer() {
            return this.buffer;
        }
    }
}

