/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfpatch.changes;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.rdfpatch.RDFChanges;

public class RDFChangesN
implements RDFChanges {
    private final List<RDFChanges> changes = new ArrayList<RDFChanges>();

    public static RDFChanges multi(RDFChanges sc1, RDFChanges sc2) {
        if (sc1 == null) {
            return sc2;
        }
        if (sc2 == null) {
            return sc1;
        }
        if (sc1 instanceof RDFChangesN) {
            ((RDFChangesN)sc1).add(sc2);
            return sc1;
        }
        return new RDFChangesN(sc1, sc2);
    }

    public RDFChangesN(RDFChanges ... changes) {
        for (RDFChanges sc : changes) {
            this.add(sc);
        }
    }

    public RDFChangesN(List<RDFChanges> changes) {
        for (RDFChanges sc : changes) {
            this.add(sc);
        }
    }

    private void add(RDFChanges sc) {
        this.changes.add(sc);
    }

    @Override
    public void start() {
        this.changes.forEach(RDFChanges::start);
    }

    @Override
    public void finish() {
        this.changes.forEach(RDFChanges::finish);
    }

    @Override
    public void header(String field, Node value) {
        this.changes.forEach(c -> c.header(field, value));
    }

    @Override
    public void add(Node g, Node s, Node p, Node o) {
        this.changes.forEach(sc -> sc.add(g, s, p, o));
    }

    @Override
    public void delete(Node g, Node s, Node p, Node o) {
        this.changes.forEach(sc -> sc.delete(g, s, p, o));
    }

    @Override
    public void addPrefix(Node graph, String prefix, String uriStr) {
        this.changes.forEach(sc -> sc.addPrefix(graph, prefix, uriStr));
    }

    @Override
    public void deletePrefix(Node graph, String prefix) {
        this.changes.forEach(sc -> sc.deletePrefix(graph, prefix));
    }

    @Override
    public void txnBegin() {
        this.changes.forEach(sc -> sc.txnBegin());
    }

    @Override
    public void txnCommit() {
        this.changes.forEach(RDFChanges::txnCommit);
    }

    @Override
    public void txnAbort() {
        this.changes.forEach(RDFChanges::txnAbort);
    }

    @Override
    public void segment() {
        this.changes.forEach(RDFChanges::segment);
    }
}

