/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.entitylistener;

import java.util.Map;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.entitylistener.GeonetworkEntityListener;
import org.fao.geonet.entitylistener.PersistentEventType;
import org.fao.geonet.utils.Log;
import org.springframework.context.ConfigurableApplicationContext;

public class AbstractEntityListenerManager<T> {
    private static boolean systemRunning = false;

    public static void setSystemRunning(boolean systemRunning) {
        AbstractEntityListenerManager.systemRunning = systemRunning;
    }

    protected void handleEvent(PersistentEventType type, T entity) {
        ConfigurableApplicationContext context = ApplicationContextHolder.get();
        if (context != null) {
            Map listeners = context.getBeansOfType(GeonetworkEntityListener.class);
            for (GeonetworkEntityListener listener : listeners.values()) {
                if (listener.getEntityClass() != entity.getClass()) continue;
                listener.handleEvent(type, entity);
            }
        } else if (systemRunning) {
            Log.error((String)"geonetwork.domain", (String)("An event occurred that was not handled because the " + ApplicationContextHolder.class.getName() + " has not been set in this thread"), (Throwable)new IllegalStateException("No ApplicationContext set in thread local"));
        }
    }
}

