/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.fao.geonet.domain.GeonetEntity;
import org.fao.geonet.domain.Group;
import org.fao.geonet.entitylistener.DoiServerEntityListenerManager;
import org.hibernate.annotations.Type;

@Entity
@Table(name="Doiservers")
@Cacheable
@Access(value=AccessType.PROPERTY)
@EntityListeners(value={DoiServerEntityListenerManager.class})
@SequenceGenerator(name="doiserver_id_seq", initialValue=100, allocationSize=1)
public class DoiServer
extends GeonetEntity {
    static final String ID_SEQ_NAME = "doiserver_id_seq";
    private int id;
    private String name;
    private String description;
    private String url;
    private String username;
    private String password;
    private String landingPageTemplate;
    private String publicUrl;
    private String pattern = "{{uuid}}";
    private String prefix;
    private Set<Group> publicationGroups = new HashSet<Group>();

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="doiserver_id_seq")
    @Column(nullable=false)
    public int getId() {
        return this.id;
    }

    public DoiServer setId(int id) {
        this.id = id;
        return this;
    }

    @Column(nullable=false, length=32)
    public String getName() {
        return this.name;
    }

    public DoiServer setName(String name) {
        this.name = name;
        return this;
    }

    @Column(length=255)
    public String getDescription() {
        return this.description;
    }

    public DoiServer setDescription(String description) {
        this.description = description;
        return this;
    }

    @Column(nullable=false, length=255)
    public String getUrl() {
        return this.url;
    }

    public DoiServer setUrl(String url) {
        this.url = url;
        return this;
    }

    @Column(length=128)
    public String getUsername() {
        return this.username;
    }

    public DoiServer setUsername(String username) {
        this.username = username;
        return this;
    }

    @Column(length=128)
    @Type(type="encryptedString")
    public String getPassword() {
        return this.password;
    }

    public DoiServer setPassword(String password) {
        this.password = password;
        return this;
    }

    public DoiServer setLandingPageTemplate(String landingPageTemplate) {
        this.landingPageTemplate = landingPageTemplate;
        return this;
    }

    @Column(nullable=false, length=255)
    public String getLandingPageTemplate() {
        return this.landingPageTemplate;
    }

    public DoiServer setPublicUrl(String publicUrl) {
        this.publicUrl = publicUrl;
        return this;
    }

    @Column(nullable=false, length=255)
    public String getPublicUrl() {
        return this.publicUrl;
    }

    public DoiServer setPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    @Column(nullable=false, length=255)
    public String getPattern() {
        return this.pattern;
    }

    public DoiServer setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Column(nullable=false, length=15)
    public String getPrefix() {
        return this.prefix;
    }

    public void setPublicationGroups(Set<Group> publicationGroups) {
        this.publicationGroups = publicationGroups;
    }

    @ManyToMany(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST})
    @JoinTable(name="doiservers_group", joinColumns={@JoinColumn(name="doiserver_id")}, inverseJoinColumns={@JoinColumn(name="group_id")})
    public Set<Group> getPublicationGroups() {
        return this.publicationGroups;
    }
}

