/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Map;
import java.util.StringJoiner;
import org.geotools.http.DefaultHttpResponse;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPResponse;

public abstract class AbstractHttpClient
implements HTTPClient {
    protected String user;
    protected String password;
    protected Map<String, String> extraParams = Collections.emptyMap();
    protected int connectTimeout;
    protected int readTimeout;
    protected boolean tryGzip;

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setExtraParams(Map<String, String> extraParams) {
        this.extraParams = extraParams;
    }

    @Override
    public Map<String, String> getExtraParams() {
        return this.extraParams;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public void setTryGzip(boolean tryGZIP) {
        this.tryGzip = tryGZIP;
    }

    @Override
    public boolean isTryGzip() {
        return this.tryGzip;
    }

    protected static URL appendURL(URL oldUrl, Map<String, String> appendQuery) throws MalformedURLException {
        String oldQuery = oldUrl.getQuery();
        StringJoiner stringJoiner = new StringJoiner("&");
        appendQuery.forEach((key, value) -> {
            try {
                stringJoiner.add(URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new UncheckedIOException(e);
            }
        });
        String query = stringJoiner.toString();
        String newQuery = oldQuery != null ? oldQuery + "&" + query : query;
        return new URL(oldUrl.getProtocol(), oldUrl.getHost(), oldUrl.getPort(), oldUrl.getPath() + "?" + newQuery);
    }

    protected boolean isFile(URL url) {
        return "file".equalsIgnoreCase(url.getProtocol());
    }

    protected HTTPResponse createFileResponse(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.connect();
        return new DefaultHttpResponse(connection);
    }

    @Override
    public abstract HTTPResponse post(URL var1, InputStream var2, String var3) throws IOException;
}

