/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.a2j.codec.comp;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jzkit.a2j.codec.comp.ModuleInfo;
import org.jzkit.a2j.codec.comp.TaggedMember;
import org.jzkit.a2j.codec.comp.TypeInfo;

public class ChoiceTypeInfo
extends TypeInfo {
    private static Logger log = Logger.getLogger(ChoiceTypeInfo.class.getName());

    public ChoiceTypeInfo(String type_reference, boolean builtin_type, int tag_class, int tag_number, boolean is_implicit, String basetype, String internal_type, ModuleInfo mi) {
        super(type_reference, builtin_type, tag_class, tag_number, is_implicit, basetype, internal_type, mi);
        this.internal_type = this.type_class_name;
    }

    public ChoiceTypeInfo(String type_reference, boolean builtin_type, String basetype, String internal_type, ModuleInfo mi) {
        super(type_reference, builtin_type, basetype, internal_type, mi);
        this.internal_type = this.type_class_name;
    }

    public void writeTypeSpecificStaticInitialisationCode(StringWriter func, StringWriter declarations) {
        int cid_counter = 0;
        declarations.write("\n");
        declarations.write("  private static Object[][] choice_info = { \n");
        Enumeration e = this.cons_members.elements();
        while (e.hasMoreElements()) {
            TaggedMember t = (TaggedMember)e.nextElement();
            TypeInfo ti = this.parent.lookup(t.getModuleReference(), t.getTypeReference(), true);
            if (null != ti) {
                declarations.write("    { " + (t.getTagClass() == -1 ? "SerializationManager.TAGMODE_NONE, " : (t.isImplicit() ? "SerializationManager.IMPLICIT, " : "SerializationManager.EXPLICIT,")) + "new Integer(" + t.getTagClass() + "), new Integer(" + t.getTagNumber() + "), " + ti.getCodecClassName() + ".getCodec() , \"" + t.getMemberName() + "\", new Integer(" + cid_counter++ + ") }" + (e.hasMoreElements() ? "," : "") + "\n");
                continue;
            }
            log.log(Level.WARNING, "Unable to lookup type info for Choice Member " + t.getTypeReference() + " module is " + t.getModuleReference());
        }
        declarations.write("  };\n\n");
        func.write("\n");
    }

    public void createTypeClassFile() {
        int cid_counter = 0;
        String type_file_name = this.parent.getModulePackageDir() + File.separatorChar + this.type_reference.replace('-', '_') + "_type.java";
        File type_source_file = new File(type_file_name);
        FileWriter type_writer = null;
        try {
            if (type_source_file.exists()) {
                log.fine(type_file_name + " type already exists");
            } else {
                log.fine("            create type source file : " + type_file_name);
                type_source_file.createNewFile();
            }
            type_writer = new FileWriter(type_source_file);
            log.fine("Create Class, package is " + this.parent.getModulePackageName() + "." + this.type_reference.replace('-', '_'));
            StringWriter declarations_stream = new StringWriter();
            type_writer.write("package " + this.parent.getModulePackageName() + ";\n\n");
            type_writer.write("import java.util.logging.*;\n");
            type_writer.write("import java.io.Serializable;\n");
            type_writer.write("import org.jzkit.a2j.codec.runtime.*;\n\n");
            type_writer.write("/** \n *  A Java holder for the ASN type : " + this.type_class_name + " \n");
            type_writer.write(" *  @author Auto generated by A2J: An ASN to Java Precompiler - http://developer.k-int.com/projects/a2j\n");
            type_writer.write(" */ \n");
            type_writer.write("public class " + this.type_class_name + " extends ChoiceType implements Serializable \n{\n");
            type_writer.write("  private transient static Logger cat = Logger.getLogger(" + this.type_class_name + ".class.getName());\n");
            Enumeration e = this.cons_members.elements();
            while (e.hasMoreElements()) {
                TaggedMember t = (TaggedMember)e.nextElement();
                String var_name = t.getMemberName().replace('-', '_');
                String id_var_name = var_name.toLowerCase();
                id_var_name = id_var_name.replace('-', '_') + "_CID";
                declarations_stream.write("  public transient static final int " + id_var_name + " = " + cid_counter + ";\n");
                ++cid_counter;
            }
            declarations_stream.write("\n");
            type_writer.write(declarations_stream.toString());
            type_writer.write("\n\n    public " + this.type_class_name + "(int which, Object o)\n");
            type_writer.write("    {\n");
            type_writer.write("      this.which = which;\n");
            type_writer.write("      this.o = o;\n");
            type_writer.write("    }\n\n");
            type_writer.write("    public " + this.type_class_name + "() {}\n\n");
            type_writer.write("\n");
            type_writer.write("\n}\n");
            type_writer.flush();
            type_writer.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(0);
        }
    }

    public void writeSerializeMethod(StringWriter func, StringWriter declarations) {
        func.write("  public Object serialize(SerializationManager sm,\n");
        func.write("                          Object type_instance,\n");
        func.write("                          boolean is_optional,\n");
        func.write("                          String type_name) throws java.io.IOException\n");
        func.write("  {\n");
        func.write("    " + this.type_class_name + " retval = (" + this.type_class_name + ")type_instance;\n\n");
        if (this.tag_class != -1) {
            func.write("    if ( sm.constructedBegin(" + this.tag_class + ", " + this.tag_number + ") )\n    {\n");
        }
        func.write("      if ( sm.getDirection() == SerializationManager.DIRECTION_DECODE )\n      {\n");
        func.write("        retval = new " + this.type_class_name + "();\n");
        func.write("        retval = (" + this.type_class_name + ")sm.choice(retval, choice_info, type_name);\n");
        func.write("      }\n      else\n      {\n");
        func.write("        if ( retval != null )\n");
        func.write("          sm.choice(retval, choice_info, type_name);\n");
        func.write("      }\n\n");
        func.write("      if ( ( retval==null ) && ( !is_optional ) )\n      {\n");
        func.write("        cat.info(\"Missing mandatory choice for \"+type_name);\n      }\n\n");
        if (this.tag_class != -1) {
            func.write("    }\n    sm.constructedEnd();\n");
        }
        func.write("    return retval;\n");
        func.write("  }\n");
    }
}

