/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.UpdateDataFrameAnalyticsResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class UpdateDataFrameAnalyticsRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean allowLazyStart;
    @Nullable
    private final String description;
    private final String id;
    @Nullable
    private final Integer maxNumThreads;
    @Nullable
    private final String modelMemoryLimit;
    public static final JsonpDeserializer<UpdateDataFrameAnalyticsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateDataFrameAnalyticsRequest::setupUpdateDataFrameAnalyticsRequestDeserializer);
    public static final Endpoint<UpdateDataFrameAnalyticsRequest, UpdateDataFrameAnalyticsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<UpdateDataFrameAnalyticsRequest, UpdateDataFrameAnalyticsResponse>("es/ml.update_data_frame_analytics", request -> "POST", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/data_frame");
            buf.append("/analytics");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            buf.append("/_update");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("id", request.id);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, UpdateDataFrameAnalyticsResponse._DESERIALIZER);

    private UpdateDataFrameAnalyticsRequest(Builder builder) {
        this.allowLazyStart = builder.allowLazyStart;
        this.description = builder.description;
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.maxNumThreads = builder.maxNumThreads;
        this.modelMemoryLimit = builder.modelMemoryLimit;
    }

    public static UpdateDataFrameAnalyticsRequest of(Function<Builder, ObjectBuilder<UpdateDataFrameAnalyticsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowLazyStart() {
        return this.allowLazyStart;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    public final String id() {
        return this.id;
    }

    @Nullable
    public final Integer maxNumThreads() {
        return this.maxNumThreads;
    }

    @Nullable
    public final String modelMemoryLimit() {
        return this.modelMemoryLimit;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.allowLazyStart != null) {
            generator.writeKey("allow_lazy_start");
            generator.write(this.allowLazyStart.booleanValue());
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.maxNumThreads != null) {
            generator.writeKey("max_num_threads");
            generator.write(this.maxNumThreads.intValue());
        }
        if (this.modelMemoryLimit != null) {
            generator.writeKey("model_memory_limit");
            generator.write(this.modelMemoryLimit);
        }
    }

    protected static void setupUpdateDataFrameAnalyticsRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allowLazyStart, JsonpDeserializer.booleanDeserializer(), "allow_lazy_start");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::maxNumThreads, JsonpDeserializer.integerDeserializer(), "max_num_threads");
        op.add(Builder::modelMemoryLimit, JsonpDeserializer.stringDeserializer(), "model_memory_limit");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<UpdateDataFrameAnalyticsRequest> {
        @Nullable
        private Boolean allowLazyStart;
        @Nullable
        private String description;
        private String id;
        @Nullable
        private Integer maxNumThreads;
        @Nullable
        private String modelMemoryLimit;

        public final Builder allowLazyStart(@Nullable Boolean value) {
            this.allowLazyStart = value;
            return this;
        }

        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder maxNumThreads(@Nullable Integer value) {
            this.maxNumThreads = value;
            return this;
        }

        public final Builder modelMemoryLimit(@Nullable String value) {
            this.modelMemoryLimit = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UpdateDataFrameAnalyticsRequest build() {
            this._checkSingleUse();
            return new UpdateDataFrameAnalyticsRequest(this);
        }
    }
}

