/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.locator;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webjars.WebJarAssetLocator;
import ro.isdc.wro.model.resource.locator.ClasspathUriLocator;
import ro.isdc.wro.model.resource.locator.UriLocator;
import ro.isdc.wro.model.resource.locator.wildcard.DefaultWildcardStreamLocator;
import ro.isdc.wro.util.WroUtil;

public class WebjarsUriLocator
implements UriLocator {
    private static final Logger LOG = LoggerFactory.getLogger(WebjarsUriLocator.class);
    public static final String ALIAS = "webjars";
    private static final String PREFIX = "webjars:";
    private final UriLocator classpathLocator = new ClasspathUriLocator();
    private final WebJarAssetLocator webjarAssetLocator = new WebJarAssetLocator();

    public static String createUri(String path) {
        Validate.notNull((Object)path);
        return WroUtil.joinPath((String)PREFIX, (String)path);
    }

    public InputStream locate(String uri) throws IOException {
        LOG.debug("Locating: {}", (Object)uri);
        try {
            String fullpath = this.webjarAssetLocator.getFullPath(this.extractPath(uri));
            return this.classpathLocator.locate(ClasspathUriLocator.createUri((String)fullpath));
        }
        catch (Exception e) {
            throw new IOException("No webjar with uri: " + uri + " available.", e);
        }
    }

    private String extractPath(String uri) {
        String uriWithUpdatedPrefix = uri.trim().replace(PREFIX, "");
        return DefaultWildcardStreamLocator.stripQueryPath((String)uriWithUpdatedPrefix);
    }

    public boolean accept(String uri) {
        return uri.trim().startsWith(PREFIX);
    }
}

