/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.commons;

import java.util.List;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.filter.text.commons.AbstractCompilerFactory;
import org.geotools.filter.text.commons.CompilerFactory;
import org.geotools.filter.text.commons.ICompiler;
import org.geotools.filter.text.commons.Language;
import org.geotools.filter.text.cql2.CQLException;

public final class CompilerUtil {
    private CompilerUtil() {
    }

    public static final Filter parseFilter(Language language, String predicate, FilterFactory filterFactory) throws CQLException {
        assert (language != null) : "language cannot be null";
        assert (predicate != null) : "predicate cannot be null";
        ICompiler compiler = CompilerFactory.makeCompiler(language, predicate, filterFactory);
        compiler.compileFilter();
        Filter result = compiler.getFilter();
        return result;
    }

    public static final Filter parseFilter(Language language, String predicate) throws CQLException {
        assert (language != null) : "language cannot be null";
        assert (predicate != null) : "predicate cannot be null";
        Filter result = CompilerUtil.parseFilter(language, predicate, null);
        return result;
    }

    public static final Expression parseExpression(Language language, String predicate, FilterFactory filterFactory) throws CQLException {
        assert (language != null) : "language cannot be null";
        assert (predicate != null) : "predicate cannot be null";
        ICompiler compiler = CompilerFactory.makeCompiler(language, predicate, filterFactory);
        compiler.compileExpression();
        Expression result = compiler.getExpression();
        return result;
    }

    public static final Expression parseExpression(Language language, String predicate) throws CQLException {
        Expression result = CompilerUtil.parseExpression(language, predicate, null);
        return result;
    }

    public static List<Filter> parseFilterList(Language language, String predicate, FilterFactory filterFactory) throws CQLException {
        assert (language != null) : "language cannot be null";
        assert (predicate != null) : "predicate cannot be null";
        ICompiler compiler = CompilerFactory.makeCompiler(language, predicate, filterFactory);
        compiler.compileFilterList();
        List<Filter> results = compiler.getFilterList();
        return results;
    }

    public static List<Filter> parseFilterList(Language language, String predicate) throws CQLException {
        List<Filter> results = CompilerUtil.parseFilterList(language, predicate, null);
        return results;
    }

    public static Expression parseExpression(String source, AbstractCompilerFactory compilerFactory, FilterFactory filterFactory) throws CQLException {
        ICompiler compiler = compilerFactory.makeCompiler(source, filterFactory);
        compiler.compileExpression();
        Expression expression = compiler.getExpression();
        return expression;
    }

    public static Filter parseFilter(String source, AbstractCompilerFactory compilerFactory, FilterFactory filterFactory) throws CQLException {
        ICompiler compiler = compilerFactory.makeCompiler(source, filterFactory);
        compiler.compileFilter();
        Filter result = compiler.getFilter();
        return result;
    }

    public static List<Filter> parseFilterList(String predicateSequence, AbstractCompilerFactory compilerFactory, FilterFactory filterFactory) throws CQLException {
        ICompiler compiler = compilerFactory.makeCompiler(predicateSequence, filterFactory);
        compiler.compileFilterList();
        List<Filter> filters = compiler.getFilterList();
        return filters;
    }
}

