/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import org.geotools.api.coverage.grid.GridCoverageReader;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.coverage.grid.GridGeometry;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.metadata.extent.GeographicBoundingBox;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.ReferenceIdentifier;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.MathTransform2D;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.CoverageReadingTransformation;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.coverage.util.FeatureUtilities;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.feature.collection.ClippingFeatureCollection;
import org.geotools.filter.function.RenderingTransformation;
import org.geotools.filter.visitor.ExtractBoundsFilterVisitor;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.renderer.lite.FastBBOX;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;

public abstract class RenderingTransformationHelper {
    private static final FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);
    private static final CoverageProcessor PROCESSOR = CoverageProcessor.getInstance();
    public static final int TRANSFORM_READ_BUFFER_PIXELS = 10;
    protected boolean oversample;

    public Object applyRenderingTransformation(Expression transformation, FeatureSource featureSource, Query layerQuery, Query renderingQuery, GridGeometry2D gridGeometry, CoordinateReferenceSystem sourceCrs, RenderingHints hints) throws IOException, SchemaException, TransformException, FactoryException {
        SimpleFeatureType simpleSchema;
        Object result = null;
        Object schema = featureSource.getSchema();
        boolean isRasterSource = false;
        if (featureSource instanceof SimpleFeatureSource && (FeatureUtilities.isWrappedCoverage((SimpleFeatureType)(simpleSchema = (SimpleFeatureType)schema)) || FeatureUtilities.isWrappedCoverageReader((SimpleFeatureType)simpleSchema))) {
            isRasterSource = true;
            result = this.readFromRaster(transformation, (SimpleFeatureSource)featureSource, renderingQuery, gridGeometry, hints);
        }
        if (result == null && !isRasterSource) {
            Query optimizedQuery = null;
            if (transformation instanceof RenderingTransformation) {
                RenderingTransformation tx = (RenderingTransformation)transformation;
                optimizedQuery = tx.invertQuery(renderingQuery, (GridGeometry)gridGeometry);
            }
            if (optimizedQuery == null) {
                Envelope bounds = (Envelope)renderingQuery.getFilter().accept((FilterVisitor)ExtractBoundsFilterVisitor.BOUNDS_VISITOR, null);
                FastBBOX bbox = new FastBBOX(filterFactory.property(""), bounds, filterFactory);
                optimizedQuery = new Query(null, (Filter)bbox);
                optimizedQuery.setHints(layerQuery.getHints());
            }
            Query mixedQuery = DataUtilities.mixQueries(layerQuery, optimizedQuery, null);
            FeatureCollection originalFeatures = featureSource.getFeatures(mixedQuery);
            if (featureSource.getSupportedHints().contains(Hints.GEOMETRY_CLIP) && originalFeatures instanceof SimpleFeatureCollection) {
                originalFeatures = new ClippingFeatureCollection((SimpleFeatureCollection)originalFeatures);
            }
            originalFeatures = RendererUtilities.fixFeatureCollectionReferencing(originalFeatures, sourceCrs);
            result = transformation.evaluate((Object)originalFeatures);
        }
        return result;
    }

    private Object readFromRaster(Expression transformation, SimpleFeatureSource featureSource, Query renderingQuery, GridGeometry2D gridGeometry, RenderingHints hints) throws IOException, TransformException, FactoryException {
        GridGeometry2D readGG = gridGeometry;
        ReferencedEnvelope originalRendingEnvelope = readGG != null ? readGG.getEnvelope2D() : null;
        SimpleFeatureCollection sample = featureSource.getFeatures();
        SimpleFeature gridWrapper = DataUtilities.first(sample);
        Interpolation interpolation = hints != null ? (Interpolation)hints.get(JAI.KEY_INTERPOLATION) : null;
        Object coverage = null;
        if (FeatureUtilities.isWrappedCoverageReader((SimpleFeatureType)((SimpleFeatureType)featureSource.getSchema()))) {
            GeneralParameterValue[] params = (GeneralParameterValue[])FeatureUtilities.PARAMS_PROPERTY_NAME.evaluate((Object)gridWrapper, GeneralParameterValue[].class);
            GridCoverage2DReader reader = (GridCoverage2DReader)FeatureUtilities.GRID_PROPERTY_NAME.evaluate((Object)gridWrapper);
            if (transformation instanceof CoverageReadingTransformation) {
                CoverageReadingTransformation.ReaderAndParams context = new CoverageReadingTransformation.ReaderAndParams(reader, params);
                return transformation.evaluate((Object)context);
            }
            if (CRS.isEquivalent(reader.getCoordinateReferenceSystem(), gridGeometry.getCoordinateReferenceSystem()) && !this.oversample) {
                readGG = RenderingTransformationHelper.updateGridGeometryToNativeResolution(gridGeometry, reader, readGG);
            }
            if (transformation instanceof RenderingTransformation) {
                RenderingTransformation tx = (RenderingTransformation)transformation;
                Query invertQuery = new Query(renderingQuery);
                if (hints != null && hints.containsKey(JAI.KEY_INTERPOLATION)) {
                    invertQuery.getHints().put((Object)JAI.KEY_INTERPOLATION, hints.get(JAI.KEY_INTERPOLATION));
                }
                readGG = (GridGeometry2D)tx.invertGridGeometry(invertQuery, (GridGeometry)readGG);
                params = tx.customizeReadParams((GridCoverageReader)reader, params);
            }
            if (params != null) {
                RenderingTransformationHelper.updateGridGeometryParam(params, readGG);
            }
            coverage = this.readCoverage(reader, params, readGG);
        } else {
            coverage = (GridCoverage2D)FeatureUtilities.GRID_PROPERTY_NAME.evaluate((Object)gridWrapper);
        }
        if (coverage != null) {
            RenderingTransformation tx;
            if (readGG != null) {
                MathTransform2D coverageTx;
                GeographicBoundingBox crsLatLonBoundingBox;
                ReferencedEnvelope renderingEnvelope = new ReferencedEnvelope(readGG.getEnvelope());
                CoordinateReferenceSystem coverageCRS = coverage.getCoordinateReferenceSystem2D();
                if (!CRS.isEquivalent(renderingEnvelope.getCoordinateReferenceSystem(), coverageCRS)) {
                    renderingEnvelope = renderingEnvelope.transform(coverageCRS, true);
                }
                if (null == (crsLatLonBoundingBox = CRS.getGeographicBoundingBox(coverageCRS)) || crsLatLonBoundingBox.getEastBoundLongitude() - crsLatLonBoundingBox.getWestBoundLongitude() >= 360.0) {
                    if (coverage.getEnvelope2D().contains((BoundingBox)renderingEnvelope)) {
                        coverage = RenderingTransformationHelper.cropCoverage(coverage, renderingEnvelope);
                    }
                } else {
                    coverage = coverage.getEnvelope2D().intersects(renderingEnvelope) ? RenderingTransformationHelper.cropCoverage(coverage, renderingEnvelope) : null;
                }
                if (coverage != null && (coverageTx = readGG.getGridToCRS2D()) instanceof AffineTransform) {
                    AffineTransform coverageAt = (AffineTransform)coverageTx;
                    AffineTransform renderingAt = (AffineTransform)gridGeometry.getGridToCRS2D();
                    double ratioX = coverageAt.getScaleX() / renderingAt.getScaleX();
                    double ratioY = coverageAt.getScaleY() / renderingAt.getScaleY();
                    if (ratioX < 0.7 && ratioY < 0.7) {
                        ParameterValueGroup param = PROCESSOR.getOperation("Scale").getParameters();
                        param.parameter("Source").setValue(coverage);
                        param.parameter("xScale").setValue(ratioX);
                        param.parameter("yScale").setValue(ratioY);
                        if (interpolation != null) {
                            param.parameter("Interpolation").setValue((Object)interpolation);
                        }
                        coverage = (GridCoverage2D)PROCESSOR.doOperation(param);
                    }
                }
            }
            if (transformation instanceof RenderingTransformation && (tx = (RenderingTransformation)transformation).clipOnRenderingArea() && originalRendingEnvelope != null) {
                coverage = RenderingTransformationHelper.cropCoverage(coverage, originalRendingEnvelope);
            }
            if (coverage != null) {
                return transformation.evaluate(coverage);
            }
        }
        return null;
    }

    private static void updateGridGeometryParam(GeneralParameterValue[] params, GridGeometry2D readGG) {
        for (GeneralParameterValue gp : params) {
            ParameterValue param;
            ReferenceIdentifier name;
            if (!(gp instanceof ParameterValue) || !(name = (param = (ParameterValue)gp).getDescriptor().getName()).equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName())) continue;
            param.setValue((Object)readGG);
        }
    }

    private static GridGeometry2D updateGridGeometryToNativeResolution(GridGeometry2D gridGeometry, GridCoverage2DReader reader, GridGeometry2D readGG) throws TransformException {
        MathTransform g2w = reader.getOriginalGridToWorld(PixelInCell.CELL_CORNER);
        if (g2w instanceof AffineTransform2D && readGG.getGridToCRS2D() instanceof AffineTransform2D) {
            AffineTransform2D atOriginal = (AffineTransform2D)g2w;
            AffineTransform2D atMap = (AffineTransform2D)readGG.getGridToCRS2D();
            if (XAffineTransform.getScale(atMap) < XAffineTransform.getScale(atOriginal)) {
                Bounds worldEnvelope = gridGeometry.getEnvelope();
                GeneralBounds transformed = CRS.transform((MathTransform)atOriginal.inverse(), worldEnvelope);
                int minx = (int)Math.floor(transformed.getMinimum(0));
                int miny = (int)Math.floor(transformed.getMinimum(1));
                int maxx = (int)Math.ceil(transformed.getMaximum(0));
                int maxy = (int)Math.ceil(transformed.getMaximum(1));
                Rectangle rect = new Rectangle(minx - 10, miny - 10, maxx - minx + 20, maxy - miny + 20);
                GridEnvelope2D gridEnvelope = new GridEnvelope2D(rect);
                readGG = new GridGeometry2D((GridEnvelope)gridEnvelope, PixelInCell.CELL_CORNER, (MathTransform)atOriginal, worldEnvelope.getCoordinateReferenceSystem(), null);
            }
        }
        return readGG;
    }

    private static GridCoverage2D cropCoverage(GridCoverage2D coverage, ReferencedEnvelope renderingEnvelope) {
        ParameterValueGroup param = PROCESSOR.getOperation("CoverageCrop").getParameters();
        param.parameter("Source").setValue((Object)coverage);
        param.parameter("Envelope").setValue((Object)renderingEnvelope);
        coverage = (GridCoverage2D)PROCESSOR.doOperation(param);
        return coverage;
    }

    protected abstract GridCoverage2D readCoverage(GridCoverage2DReader var1, Object var2, GridGeometry2D var3) throws IOException;

    public void setOversampleEnabled(boolean oversample) {
        this.oversample = oversample;
    }
}

