/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.style.AnchorPoint;
import org.geotools.api.style.ChannelSelection;
import org.geotools.api.style.ColorMap;
import org.geotools.api.style.ColorMapEntry;
import org.geotools.api.style.ContrastEnhancement;
import org.geotools.api.style.Displacement;
import org.geotools.api.style.ExternalGraphic;
import org.geotools.api.style.FeatureTypeConstraint;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Fill;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.Halo;
import org.geotools.api.style.ImageOutline;
import org.geotools.api.style.LinePlacement;
import org.geotools.api.style.LineSymbolizer;
import org.geotools.api.style.Mark;
import org.geotools.api.style.NamedLayer;
import org.geotools.api.style.OverlapBehavior;
import org.geotools.api.style.PointPlacement;
import org.geotools.api.style.PointSymbolizer;
import org.geotools.api.style.PolygonSymbolizer;
import org.geotools.api.style.RasterSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.SelectedChannelType;
import org.geotools.api.style.ShadedRelief;
import org.geotools.api.style.Stroke;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.api.style.Symbolizer;
import org.geotools.api.style.TextSymbolizer;
import org.geotools.api.style.UserLayer;
import org.geotools.styling.AbstractStyleVisitor;

public class OpacityFinder
extends AbstractStyleVisitor
implements StyleVisitor {
    private final Class<?>[] acceptableTypes;
    public boolean hasOpacity;

    public OpacityFinder(Class<?>[] acceptableTypes) {
        this.acceptableTypes = acceptableTypes;
    }

    @Override
    public void visit(Style style) {
        for (FeatureTypeStyle featureTypeStyle : style.featureTypeStyles()) {
            if (this.hasOpacity) break;
            featureTypeStyle.accept((StyleVisitor)this);
        }
    }

    @Override
    public void visit(Rule rule) {
        for (Symbolizer symbolizer : rule.symbolizers()) {
            if (this.hasOpacity) break;
            symbolizer.accept((StyleVisitor)this);
        }
    }

    @Override
    public void visit(FeatureTypeStyle fts) {
        for (Rule rule : fts.rules()) {
            if (this.hasOpacity) break;
            rule.accept((StyleVisitor)this);
        }
    }

    @Override
    public void visit(Fill fill) {
        this.checkOpacity(fill.getOpacity());
    }

    private void checkOpacity(Expression exp) {
        if (exp != null && exp instanceof Literal) {
            float opacity;
            Literal literal = (Literal)exp;
            Object obj = literal.getValue();
            if (obj instanceof Integer) {
                Integer i = (Integer)obj;
                opacity = i.floatValue();
            } else if (obj instanceof Float) {
                Float i = (Float)obj;
                opacity = i.floatValue();
            } else if (obj instanceof Double) {
                Double i = (Double)obj;
                opacity = i.floatValue();
            } else if (obj instanceof Short) {
                Short i = (Short)obj;
                opacity = i.floatValue();
            } else if (obj instanceof Byte) {
                Byte i = (Byte)obj;
                opacity = i.floatValue();
            } else if (obj instanceof String) {
                try {
                    Double value = Double.valueOf((String)obj);
                    opacity = value.floatValue();
                }
                catch (NumberFormatException e) {
                    return;
                }
            } else {
                return;
            }
            if ((double)opacity > 0.01 && (double)opacity < 0.99) {
                this.hasOpacity = true;
            }
        }
    }

    @Override
    public void visit(Stroke stroke) {
        this.checkOpacity(stroke.getOpacity());
    }

    @Override
    public void visit(Symbolizer sym) {
        PointSymbolizer ps;
        if (sym instanceof PointSymbolizer) {
            ps = (PointSymbolizer)sym;
            ps.accept((StyleVisitor)this);
        }
        if (sym instanceof LineSymbolizer) {
            ps = (LineSymbolizer)sym;
            ps.accept((StyleVisitor)this);
        }
        if (sym instanceof PolygonSymbolizer) {
            ps = (PolygonSymbolizer)sym;
            ps.accept((StyleVisitor)this);
        }
        if (sym instanceof RasterSymbolizer) {
            RasterSymbolizer rs = (RasterSymbolizer)sym;
            rs.accept((StyleVisitor)this);
        }
    }

    @Override
    public void visit(PointSymbolizer ps) {
        if (this.isAcceptable((Symbolizer)ps)) {
            ps.getGraphic().accept((StyleVisitor)this);
        }
    }

    private boolean isAcceptable(Symbolizer s) {
        for (Class<?> type : this.acceptableTypes) {
            if (!type.isAssignableFrom(s.getClass())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visit(LineSymbolizer line) {
        if (this.isAcceptable((Symbolizer)line) && line.getStroke() != null) {
            line.getStroke().accept((StyleVisitor)this);
        }
    }

    @Override
    public void visit(PolygonSymbolizer poly) {
        if (this.isAcceptable((Symbolizer)poly)) {
            if (poly.getStroke() != null) {
                poly.getStroke().accept((StyleVisitor)this);
            }
            if (poly.getFill() != null) {
                poly.getFill().accept((StyleVisitor)this);
            }
        }
    }

    @Override
    public void visit(TextSymbolizer text) {
    }

    @Override
    public void visit(RasterSymbolizer raster) {
        if (this.isAcceptable((Symbolizer)raster)) {
            if (raster.getOpacity() != null) {
                this.checkOpacity(raster.getOpacity());
            }
            if (raster.getColorMap() != null) {
                raster.getColorMap().accept((StyleVisitor)this);
            }
        }
    }

    @Override
    public void visit(Graphic gr) {
    }

    @Override
    public void visit(Mark mark) {
    }

    @Override
    public void visit(ExternalGraphic exgr) {
    }

    @Override
    public void visit(PointPlacement pp) {
    }

    @Override
    public void visit(AnchorPoint ap) {
    }

    @Override
    public void visit(Displacement dis) {
    }

    @Override
    public void visit(LinePlacement lp) {
    }

    @Override
    public void visit(Halo halo) {
    }

    public static void main(String[] args) {
    }

    @Override
    public void visit(StyledLayerDescriptor sld) {
    }

    @Override
    public void visit(NamedLayer layer) {
    }

    @Override
    public void visit(UserLayer layer) {
    }

    @Override
    public void visit(FeatureTypeConstraint ftc) {
    }

    @Override
    public void visit(ColorMap cm) {
        for (ColorMapEntry cme : cm.getColorMapEntries()) {
            cme.accept((StyleVisitor)this);
        }
    }

    @Override
    public void visit(ColorMapEntry cme) {
        if (cme.getOpacity() != null) {
            this.checkOpacity(cme.getOpacity());
        }
    }

    @Override
    public void visit(ContrastEnhancement contrastEnhancement) {
    }

    @Override
    public void visit(ImageOutline outline) {
    }

    @Override
    public void visit(ChannelSelection cs) {
    }

    @Override
    public void visit(OverlapBehavior ob) {
    }

    @Override
    public void visit(SelectedChannelType sct) {
    }

    @Override
    public void visit(ShadedRelief sr) {
    }
}

