/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import org.geotools.api.filter.BinaryComparisonOperator;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.MultiValuedFilter;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.BinarySpatialOperator;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

class FastBBOX
implements BBOX,
BinarySpatialOperator,
BinaryComparisonOperator {
    PropertyName property;
    Envelope envelope;
    FilterFactory factory;

    public FastBBOX(PropertyName propertyName, Envelope env, FilterFactory factory) {
        this.property = propertyName;
        this.envelope = env;
        this.factory = factory;
    }

    public PropertyName getProperty() {
        return this.property;
    }

    public Envelope getEnvelope() {
        return this.envelope;
    }

    public BoundingBox getBounds() {
        return ReferencedEnvelope.reference(this.envelope);
    }

    public Expression getExpression1() {
        return this.property;
    }

    public Expression getExpression2() {
        return this.factory.literal((Object)this.envelope);
    }

    public Object accept(FilterVisitor visitor, Object context) {
        Object result = visitor.visit((BBOX)this, context);
        if (!(result instanceof BBOX)) {
            return result;
        }
        BBOX clone = (BBOX)result;
        if (clone.getExpression1().equals(this.getExpression1()) && clone.getExpression2().equals(this.getExpression2())) {
            return new FastBBOX(this.property, this.envelope, this.factory);
        }
        return result;
    }

    public boolean evaluate(Object feature) {
        if (feature == null) {
            return false;
        }
        Geometry other = (Geometry)this.property.evaluate(feature, Geometry.class);
        if (other == null) {
            return false;
        }
        return other.getEnvelopeInternal().intersects(this.envelope);
    }

    public boolean isMatchingCase() {
        return false;
    }

    public MultiValuedFilter.MatchAction getMatchAction() {
        return MultiValuedFilter.MatchAction.ANY;
    }

    public String toString() {
        return "FastBBOX [property=" + this.property + ", envelope=" + this.envelope + "]";
    }
}

