/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.Layer;
import org.geotools.map.MapBoundsListener;
import org.geotools.map.MapLayerEvent;
import org.geotools.map.MapLayerListEvent;
import org.geotools.map.MapLayerListListener;
import org.geotools.map.MapLayerListener;
import org.geotools.map.MapViewport;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;

public class MapContent {
    protected static final Logger LOGGER = Logging.getLogger(MapContent.class);
    static final String UNDISPOSED_MAPCONTENT_ERROR = "Call MapContent dispose() to prevent memory leaks";
    private final LayerList layerList = new LayerList();
    private CopyOnWriteArrayList<MapLayerListListener> mapListeners;
    private HashMap<String, Object> userData;
    private String title;
    private CopyOnWriteArrayList<PropertyChangeListener> propertyListeners;
    protected MapViewport viewport;
    private MapLayerListener layerListener;
    private final ReadWriteLock monitor = new ReentrantReadWriteLock();

    protected void finalize() throws Throwable {
        if (this.layerList != null && !this.layerList.isEmpty()) {
            LOGGER.severe(UNDISPOSED_MAPCONTENT_ERROR);
        }
        super.finalize();
    }

    public void dispose() {
        for (Layer layer : this.layerList) {
            if (layer == null) continue;
            layer.preDispose();
            layer.dispose();
        }
        this.layerList.clear();
        if (this.mapListeners != null) {
            this.mapListeners.clear();
            this.mapListeners = null;
        }
        if (this.layerListener != null) {
            this.layerListener = null;
        }
        if (this.propertyListeners != null) {
            this.propertyListeners.clear();
            this.propertyListeners = null;
        }
        this.title = null;
        if (this.userData != null) {
            this.userData.clear();
            this.userData = null;
        }
    }

    public void addMapLayerListListener(MapLayerListListener listener) {
        this.monitor.writeLock().lock();
        try {
            boolean added;
            if (this.mapListeners == null) {
                this.mapListeners = new CopyOnWriteArrayList();
            }
            if ((added = this.mapListeners.addIfAbsent(listener)) && this.mapListeners.size() == 1) {
                this.listenToMapLayers(true);
            }
        }
        finally {
            this.monitor.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void listenToMapLayers(boolean listen) {
        this.monitor.writeLock().lock();
        try {
            if (this.mapListeners == null || this.mapListeners.isEmpty()) {
                return;
            }
            if (this.layerListener == null) {
                this.layerListener = new MapLayerListener(){

                    @Override
                    public void layerShown(MapLayerEvent event) {
                        Layer layer = (Layer)event.getSource();
                        int index = MapContent.this.layerList.indexOf(layer);
                        MapContent.this.fireLayerEvent(layer, index, event);
                    }

                    @Override
                    public void layerSelected(MapLayerEvent event) {
                        Layer layer = (Layer)event.getSource();
                        int index = MapContent.this.layerList.indexOf(layer);
                        MapContent.this.fireLayerEvent(layer, index, event);
                    }

                    @Override
                    public void layerHidden(MapLayerEvent event) {
                        Layer layer = (Layer)event.getSource();
                        int index = MapContent.this.layerList.indexOf(layer);
                        MapContent.this.fireLayerEvent(layer, index, event);
                    }

                    @Override
                    public void layerDeselected(MapLayerEvent event) {
                        Layer layer = (Layer)event.getSource();
                        int index = MapContent.this.layerList.indexOf(layer);
                        MapContent.this.fireLayerEvent(layer, index, event);
                    }

                    @Override
                    public void layerChanged(MapLayerEvent event) {
                        Layer layer = (Layer)event.getSource();
                        int index = MapContent.this.layerList.indexOf(layer);
                        MapContent.this.fireLayerEvent(layer, index, event);
                    }

                    @Override
                    public void layerPreDispose(MapLayerEvent event) {
                        Layer layer = (Layer)event.getSource();
                        int index = MapContent.this.layerList.indexOf(layer);
                        MapContent.this.fireLayerEvent(layer, index, event);
                    }
                };
            }
            if (listen) {
                for (Layer layer : this.layerList) {
                    layer.addMapLayerListener(this.layerListener);
                }
            } else {
                for (Layer layer : this.layerList) {
                    layer.removeMapLayerListener(this.layerListener);
                }
            }
        }
        finally {
            this.monitor.writeLock().unlock();
        }
    }

    public void removeMapLayerListListener(MapLayerListListener listener) {
        this.monitor.writeLock().lock();
        try {
            if (this.mapListeners != null) {
                this.mapListeners.remove(listener);
            }
        }
        finally {
            this.monitor.writeLock().unlock();
        }
    }

    public boolean addLayer(Layer layer) {
        this.monitor.writeLock().lock();
        try {
            boolean bl = this.layerList.addIfAbsent(layer);
            return bl;
        }
        finally {
            this.monitor.writeLock().unlock();
        }
    }

    public int addLayers(Collection<? extends Layer> layers) {
        this.monitor.writeLock().lock();
        try {
            if (layers == null || layers.isEmpty()) {
                int n = 0;
                return n;
            }
            int n = this.layerList.addAllAbsent(layers);
            return n;
        }
        finally {
            this.monitor.writeLock().unlock();
        }
    }

    public boolean removeLayer(Layer layer) {
        this.monitor.writeLock().lock();
        try {
            boolean bl = this.layerList.remove(layer);
            return bl;
        }
        finally {
            this.monitor.writeLock().unlock();
        }
    }

    public void moveLayer(int sourcePosition, int destPosition) {
        this.monitor.writeLock().lock();
        try {
            this.layerList.move(sourcePosition, destPosition);
        }
        finally {
            this.monitor.writeLock().unlock();
        }
    }

    public List<Layer> layers() {
        this.monitor.readLock().lock();
        try {
            LayerList layerList = this.layerList;
            return layerList;
        }
        finally {
            this.monitor.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireLayerAdded(Layer element, int fromIndex, int toIndex) {
        this.monitor.readLock().lock();
        try {
            if (this.mapListeners == null) {
                return;
            }
            MapLayerListEvent event = new MapLayerListEvent(this, element, fromIndex, toIndex);
            for (MapLayerListListener mapLayerListListener : this.mapListeners) {
                try {
                    mapLayerListListener.layerAdded(event);
                }
                catch (Throwable t) {
                    if (!LOGGER.isLoggable(Level.FINER)) continue;
                    LOGGER.logp(Level.FINE, mapLayerListListener.getClass().getName(), "layerAdded", t.getLocalizedMessage(), t);
                }
            }
        }
        finally {
            this.monitor.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireLayerRemoved(Layer element, int fromIndex, int toIndex) {
        this.monitor.readLock().lock();
        try {
            if (this.mapListeners == null) {
                return;
            }
            MapLayerListEvent event = new MapLayerListEvent(this, element, fromIndex, toIndex);
            for (MapLayerListListener mapLayerListListener : this.mapListeners) {
                try {
                    mapLayerListListener.layerRemoved(event);
                }
                catch (Throwable t) {
                    if (!LOGGER.isLoggable(Level.FINER)) continue;
                    LOGGER.logp(Level.FINE, mapLayerListListener.getClass().getName(), "layerAdded", t.getLocalizedMessage(), t);
                }
            }
        }
        finally {
            this.monitor.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireLayerMoved(Layer element, int toIndex) {
        this.monitor.readLock().lock();
        try {
            if (this.mapListeners == null) {
                return;
            }
            MapLayerListEvent event = new MapLayerListEvent(this, element, toIndex);
            for (MapLayerListListener mapLayerListListener : this.mapListeners) {
                try {
                    mapLayerListListener.layerMoved(event);
                }
                catch (Throwable t) {
                    if (!LOGGER.isLoggable(Level.FINER)) continue;
                    LOGGER.logp(Level.FINE, mapLayerListListener.getClass().getName(), "layerMoved", t.getLocalizedMessage(), t);
                }
            }
        }
        finally {
            this.monitor.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireLayerPreDispose(Layer element, int toIndex) {
        this.monitor.readLock().lock();
        try {
            if (this.mapListeners == null) {
                return;
            }
            MapLayerListEvent event = new MapLayerListEvent(this, element, toIndex);
            for (MapLayerListListener mapLayerListListener : this.mapListeners) {
                try {
                    mapLayerListListener.layerPreDispose(event);
                }
                catch (Throwable t) {
                    if (!LOGGER.isLoggable(Level.FINER)) continue;
                    LOGGER.logp(Level.FINE, mapLayerListListener.getClass().getName(), "layerMoved", t.getLocalizedMessage(), t);
                }
            }
        }
        finally {
            this.monitor.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireLayerEvent(Layer element, int index, MapLayerEvent layerEvent) {
        this.monitor.readLock().lock();
        try {
            if (this.mapListeners == null) {
                return;
            }
            MapLayerListEvent mapEvent = new MapLayerListEvent(this, element, index, layerEvent);
            for (MapLayerListListener mapLayerListListener : this.mapListeners) {
                try {
                    switch (layerEvent.getReason()) {
                        case 7: {
                            mapLayerListListener.layerPreDispose(mapEvent);
                            break;
                        }
                        default: {
                            mapLayerListListener.layerChanged(mapEvent);
                            break;
                        }
                    }
                }
                catch (Throwable t) {
                    if (!LOGGER.isLoggable(Level.FINER)) continue;
                    LOGGER.logp(Level.FINE, mapLayerListListener.getClass().getName(), "layerAdded", t.getLocalizedMessage(), t);
                }
            }
        }
        finally {
            this.monitor.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferencedEnvelope getMaxBounds() {
        this.monitor.readLock().lock();
        try {
            CoordinateReferenceSystem mapCrs = null;
            if (this.viewport != null) {
                mapCrs = this.viewport.getCoordinateReferenceSystem();
            }
            ReferencedEnvelope maxBounds = null;
            for (Layer layer : this.layerList) {
                if (layer == null) continue;
                try {
                    ReferencedEnvelope normalized;
                    ReferencedEnvelope layerBounds = layer.getBounds();
                    if (layerBounds == null || layerBounds.isEmpty() || layerBounds.isNull()) continue;
                    if (mapCrs == null) {
                        maxBounds = new ReferencedEnvelope(layerBounds);
                        mapCrs = layerBounds.getCoordinateReferenceSystem();
                        continue;
                    }
                    if (CRS.equalsIgnoreMetadata(mapCrs, layerBounds.getCoordinateReferenceSystem())) {
                        normalized = layerBounds;
                    } else {
                        try {
                            normalized = layerBounds.transform(mapCrs, true);
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.FINE, "Unable to transform: {0}", e);
                            continue;
                        }
                    }
                    if (maxBounds == null) {
                        maxBounds = normalized;
                        continue;
                    }
                    maxBounds.expandToInclude(normalized);
                }
                catch (Throwable eek) {
                    LOGGER.log(Level.WARNING, "Unable to determine bounds of " + layer, eek);
                }
            }
            if (maxBounds == null) {
                maxBounds = new ReferencedEnvelope(mapCrs);
            }
            Iterator iterator = maxBounds;
            return iterator;
        }
        finally {
            this.monitor.readLock().unlock();
        }
    }

    public MapViewport getViewport() {
        this.monitor.readLock().lock();
        try {
            if (this.viewport == null) {
                this.viewport = new MapViewport(this.getMaxBounds());
            }
            MapViewport mapViewport = this.viewport;
            return mapViewport;
        }
        finally {
            this.monitor.readLock().unlock();
        }
    }

    public void setViewport(MapViewport viewport) {
        this.monitor.writeLock().lock();
        try {
            this.viewport = viewport;
        }
        finally {
            this.monitor.writeLock().unlock();
        }
    }

    public void addMapBoundsListener(MapBoundsListener listener) {
        this.monitor.writeLock().lock();
        try {
            this.getViewport().addMapBoundsListener(listener);
        }
        finally {
            this.monitor.writeLock().unlock();
        }
    }

    public void removeMapBoundsListener(MapBoundsListener listener) {
        this.monitor.writeLock().lock();
        try {
            this.getViewport().removeMapBoundsListener(listener);
        }
        finally {
            this.monitor.writeLock().unlock();
        }
    }

    ReferencedEnvelope getBounds() {
        this.monitor.readLock().lock();
        try {
            ReferencedEnvelope referencedEnvelope = this.getViewport().getBounds();
            return referencedEnvelope;
        }
        finally {
            this.monitor.readLock().unlock();
        }
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        this.monitor.readLock().lock();
        try {
            CoordinateReferenceSystem coordinateReferenceSystem = this.getViewport().getCoordinateReferenceSystem();
            return coordinateReferenceSystem;
        }
        finally {
            this.monitor.readLock().unlock();
        }
    }

    void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        this.monitor.writeLock().lock();
        try {
            this.getViewport().setCoordinateReferenceSystem(crs);
        }
        finally {
            this.monitor.writeLock().unlock();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.monitor.writeLock().lock();
        try {
            if (this.propertyListeners == null) {
                this.propertyListeners = new CopyOnWriteArrayList();
            }
            if (!this.propertyListeners.contains(listener)) {
                this.propertyListeners.add(listener);
            }
        }
        finally {
            this.monitor.writeLock().unlock();
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.monitor.writeLock().lock();
        try {
            if (this.propertyListeners != null) {
                this.propertyListeners.remove(listener);
            }
        }
        finally {
            this.monitor.writeLock().unlock();
        }
    }

    public Map<String, Object> getUserData() {
        this.monitor.writeLock().lock();
        try {
            if (this.userData == null) {
                this.userData = new HashMap<String, Object>(){
                    private static final long serialVersionUID = 8011733882551971475L;

                    @Override
                    public Object put(String key, Object value) {
                        Object old = super.put(key, value);
                        MapContent.this.fireProperty(key, old, value);
                        return old;
                    }

                    @Override
                    public Object remove(Object key) {
                        Object old = super.remove(key);
                        MapContent.this.fireProperty((String)key, old, null);
                        return old;
                    }

                    @Override
                    public void putAll(Map<? extends String, ? extends Object> m) {
                        super.putAll(m);
                        MapContent.this.fireProperty("userData", null, null);
                    }

                    @Override
                    public void clear() {
                        super.clear();
                        MapContent.this.fireProperty("userData", null, null);
                    }
                };
            }
            HashMap<String, Object> hashMap = this.userData;
            return hashMap;
        }
        finally {
            this.monitor.writeLock().unlock();
        }
    }

    public String getTitle() {
        this.monitor.readLock().lock();
        try {
            String string = this.title;
            return string;
        }
        finally {
            this.monitor.readLock().unlock();
        }
    }

    public void setTitle(String title) {
        this.monitor.writeLock().lock();
        try {
            String old = this.title;
            this.title = title;
            this.fireProperty("title", old, title);
        }
        finally {
            this.monitor.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireProperty(String propertyName, Object old, Object value) {
        this.monitor.readLock().lock();
        try {
            if (this.propertyListeners == null) {
                return;
            }
            PropertyChangeEvent event = new PropertyChangeEvent(this, "propertyName", old, value);
            for (PropertyChangeListener propertyChangeListener : this.propertyListeners) {
                try {
                    propertyChangeListener.propertyChange(event);
                }
                catch (Throwable t) {
                    if (!LOGGER.isLoggable(Level.FINER)) continue;
                    LOGGER.logp(Level.FINE, propertyChangeListener.getClass().getName(), "propertyChange", t.getLocalizedMessage(), t);
                }
            }
        }
        finally {
            this.monitor.readLock().unlock();
        }
    }

    private void checkViewportCRS() {
        if (this.viewport != null && this.getCoordinateReferenceSystem() == null && this.viewport.isEditable()) {
            for (Layer layer : this.layerList) {
                CoordinateReferenceSystem crs;
                ReferencedEnvelope bounds = layer.getBounds();
                if (bounds == null || (crs = bounds.getCoordinateReferenceSystem()) == null) continue;
                this.viewport.setCoordinateReferenceSystem(crs);
                return;
            }
        }
    }

    private class LayerList
    extends CopyOnWriteArrayList<Layer> {
        private static final long serialVersionUID = 8011733882551971475L;

        private LayerList() {
        }

        @Override
        public void add(int index, Layer element) {
            if (!this.contains(element)) {
                super.add(index, element);
                if (MapContent.this.layerListener != null) {
                    element.addMapLayerListener(MapContent.this.layerListener);
                }
                MapContent.this.checkViewportCRS();
                MapContent.this.fireLayerAdded(element, index, index);
            }
        }

        @Override
        public boolean add(Layer element) {
            return this.addIfAbsent(element);
        }

        @Override
        public boolean addAll(Collection<? extends Layer> layers) {
            return this.addAllAbsent(layers) > 0;
        }

        @Override
        public boolean addAll(int index, Collection<? extends Layer> layers) {
            boolean added = false;
            int pos = index;
            for (Layer layer : layers) {
                if (this.contains(layer)) continue;
                this.add(pos, layer);
                if (MapContent.this.layerListener != null) {
                    layer.addMapLayerListener(MapContent.this.layerListener);
                }
                added = true;
                ++pos;
            }
            if (added) {
                MapContent.this.checkViewportCRS();
                MapContent.this.fireLayerAdded(null, index, this.size() - 1);
            }
            return added;
        }

        @Override
        public int addAllAbsent(Collection<? extends Layer> layers) {
            int start = this.size();
            int added = super.addAllAbsent(layers);
            if (added > 0) {
                if (MapContent.this.layerListener != null) {
                    for (int i = start; i < this.size(); ++i) {
                        ((Layer)this.get(i)).addMapLayerListener(MapContent.this.layerListener);
                    }
                }
                MapContent.this.checkViewportCRS();
                MapContent.this.fireLayerAdded(null, start, this.size() - 1);
            }
            return added;
        }

        @Override
        public boolean addIfAbsent(Layer element) {
            boolean added = super.addIfAbsent(element);
            if (added) {
                if (MapContent.this.layerListener != null) {
                    element.addMapLayerListener(MapContent.this.layerListener);
                }
                MapContent.this.checkViewportCRS();
                MapContent.this.fireLayerAdded(element, this.size() - 1, this.size() - 1);
            }
            return added;
        }

        @Override
        public void clear() {
            for (Layer element : this) {
                if (MapContent.this.layerListener != null) {
                    element.removeMapLayerListener(MapContent.this.layerListener);
                }
                element.dispose();
            }
            super.clear();
            MapContent.this.fireLayerRemoved(null, -1, -1);
        }

        @Override
        public Layer remove(int index) {
            Layer removed = (Layer)super.remove(index);
            MapContent.this.fireLayerRemoved(removed, index, index);
            if (MapContent.this.layerListener != null) {
                removed.removeMapLayerListener(MapContent.this.layerListener);
            }
            removed.dispose();
            return removed;
        }

        @Override
        public boolean remove(Object element) {
            boolean removed = super.remove(element);
            if (removed) {
                MapContent.this.fireLayerRemoved((Layer)element, -1, -1);
                if (element instanceof Layer) {
                    Layer layer = (Layer)element;
                    if (MapContent.this.layerListener != null) {
                        layer.removeMapLayerListener(MapContent.this.layerListener);
                    }
                    layer.dispose();
                }
            }
            return removed;
        }

        @Override
        public boolean removeAll(Collection<?> layers) {
            for (Object obj : layers) {
                Layer element = (Layer)obj;
                if (!this.contains(element)) continue;
                if (MapContent.this.layerListener != null) {
                    element.removeMapLayerListener(MapContent.this.layerListener);
                }
                element.dispose();
            }
            boolean removed = super.removeAll(layers);
            MapContent.this.fireLayerRemoved(null, 0, this.size() - 1);
            return removed;
        }

        @Override
        public boolean retainAll(Collection<?> layers) {
            for (Layer element : this) {
                if (layers.contains(element)) continue;
                if (MapContent.this.layerListener != null) {
                    element.removeMapLayerListener(MapContent.this.layerListener);
                }
                element.dispose();
            }
            boolean removed = super.retainAll(layers);
            if (removed) {
                MapContent.this.fireLayerRemoved(null, 0, this.size() - 1);
            }
            return removed;
        }

        @Override
        public Layer set(int index, Layer element) {
            Layer removed = this.remove(index);
            this.add(index, element);
            MapContent.this.checkViewportCRS();
            return removed;
        }

        private void move(int sourcePosition, int destPosition) {
            Layer layer = (Layer)super.remove(sourcePosition);
            super.add(destPosition, layer);
            MapContent.this.fireLayerMoved(layer, destPosition);
        }
    }
}

