/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.readers;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.Transformer;
import org.mapfish.print.map.readers.MapReader;
import org.mapfish.print.map.readers.MapReaderFactory;
import org.mapfish.print.map.readers.TileCacheLayerInfo;
import org.mapfish.print.map.readers.TileableMapReader;
import org.mapfish.print.map.readers.XyzLayerInfo;
import org.mapfish.print.map.renderers.TileRenderer;
import org.mapfish.print.utils.PJsonArray;
import org.mapfish.print.utils.PJsonObject;

public class XyzMapReader
extends TileableMapReader {
    protected final String layer;
    protected final String path_format;

    protected XyzMapReader(String layer, RenderingContext context, PJsonObject params) {
        super(context, params);
        float tileOriginY;
        float tileOriginX;
        this.layer = layer;
        PJsonArray maxExtent = params.getJSONArray("maxExtent");
        PJsonArray tileSize = params.getJSONArray("tileSize");
        PJsonArray tileOrigin = params.optJSONArray("tileOrigin");
        String tileOriginCorner = params.optString("tileOriginCorner", "bl");
        if (tileOrigin == null) {
            tileOriginX = maxExtent.getFloat(0);
            tileOriginY = maxExtent.getFloat(tileOriginCorner.charAt(0) == 't' ? 3 : 1);
        } else {
            tileOriginX = tileOrigin.getFloat(0);
            tileOriginY = tileOrigin.getFloat(1);
        }
        this.path_format = params.optString("path_format", null);
        this.tileCacheLayerInfo = new XyzLayerInfo(params.getJSONArray("resolutions"), tileSize.getInt(0), tileSize.getInt(1), maxExtent.getFloat(0), maxExtent.getFloat(1), maxExtent.getFloat(2), maxExtent.getFloat(3), params.getString("extension"), tileOriginX, tileOriginY);
    }

    @Override
    protected TileRenderer.Format getFormat() {
        return TileRenderer.Format.BITMAP;
    }

    @Override
    protected void addCommonQueryParams(Map<String, List<String>> result, Transformer transformer, String srs, boolean first) {
    }

    @Override
    protected URI getTileUri(URI commonUri, Transformer transformer, double minGeoX, double minGeoY, double maxGeoX, double maxGeoY, long w, long h) throws URISyntaxException, UnsupportedEncodingException {
        double targetResolution = (maxGeoX - minGeoX) / (double)w;
        TileCacheLayerInfo.ResolutionInfo resolution = this.tileCacheLayerInfo.getNearestResolution(targetResolution);
        int tileX = (int)Math.round((minGeoX - this.tileCacheLayerInfo.getMinX()) / (resolution.value * (double)w));
        int tileY = (int)Math.round((this.tileCacheLayerInfo.getMaxY() - minGeoY) / (resolution.value * (double)h));
        int[] tileCoords = this.handleWrapDateLine(tileX, tileY, resolution, -1);
        StringBuilder path = new StringBuilder();
        if (!commonUri.getPath().endsWith("/")) {
            path.append('/');
        }
        if (this.path_format == null) {
            path.append(String.format("%d", resolution.index));
            path.append('/').append(tileCoords[0]);
            path.append('/').append(tileCoords[1]);
            path.append('.').append(this.tileCacheLayerInfo.getExtension());
        } else {
            if (this.path_format.startsWith("/")) {
                path.append(this.path_format.substring(1));
            } else {
                path.append(this.path_format);
            }
            this.url_regex_replace("z", path, resolution.index);
            this.url_regex_replace("x", path, tileCoords[0]);
            this.url_regex_replace("y", path, tileCoords[1]);
            this.url_regex_replace("extension", path, this.tileCacheLayerInfo.getExtension());
        }
        return new URI(commonUri.getScheme(), commonUri.getUserInfo(), commonUri.getHost(), commonUri.getPort(), commonUri.getPath() + path, commonUri.getQuery(), commonUri.getFragment());
    }

    @Override
    public boolean testMerge(MapReader other) {
        return false;
    }

    @Override
    public boolean canMerge(MapReader other) {
        return false;
    }

    @Override
    public String toString() {
        return this.layer;
    }

    private void url_regex_replace(String needle, StringBuilder haystack, Object replaceValue) {
        Pattern pattern = Pattern.compile("\\$\\{(" + needle + "+)\\}");
        Matcher matcher = pattern.matcher(haystack);
        while (matcher.find()) {
            int length = 1;
            if (matcher.groupCount() > 0) {
                length = matcher.group(1).length();
            }
            String value = "";
            value = needle.equals("extension") ? (String)replaceValue : String.format("%0" + length + "d", replaceValue);
            haystack.replace(matcher.start(), matcher.end(), value);
            matcher = pattern.matcher(haystack);
        }
    }

    public static class Factory
    implements MapReaderFactory {
        @Override
        public List<? extends MapReader> create(String type, RenderingContext context, PJsonObject params) {
            return Collections.singletonList(new XyzMapReader("t", context, params));
        }
    }
}

