/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config.layout;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import org.mapfish.print.InvalidValueException;
import org.mapfish.print.PDFUtils;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.config.layout.Block;
import org.mapfish.print.config.layout.FontBlock;
import org.mapfish.print.utils.PJsonObject;

public class TextBlock
extends FontBlock {
    private String text = "";
    private boolean asHTML = false;

    @Override
    public void render(PJsonObject params, Block.PdfElement target, RenderingContext context) throws DocumentException {
        Paragraph paragraph = new Paragraph();
        Font pdfFont = this.getPdfFont();
        paragraph.setFont(pdfFont);
        Phrase text = PDFUtils.renderString(context, params, this.text, Integer.MAX_VALUE, pdfFont, null, this.asHTML);
        paragraph.add((Element)text);
        if (this.getAlign() != null) {
            paragraph.setAlignment(this.getAlign().getCode());
        }
        paragraph.setSpacingAfter((float)this.spacingAfter);
        target.add((Element)paragraph);
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public boolean isAsHTML() {
        return this.asHTML;
    }

    public void setAsHTML(boolean asHTML) {
        this.asHTML = asHTML;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.text == null) {
            throw new InvalidValueException("text", "null");
        }
    }
}

