/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config.layout;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfPCell;
import org.mapfish.print.InvalidValueException;
import org.mapfish.print.PDFUtils;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.config.layout.Block;
import org.mapfish.print.config.layout.TableConfig;
import org.mapfish.print.utils.PJsonObject;

public class ColumnDef {
    private int columnWeight = 0;
    private Block header;
    private Block cell;

    public void setHeader(Block header) {
        this.header = header;
    }

    public void setCell(Block cell) {
        this.cell = cell;
    }

    public PdfPCell createHeaderPdfCell(PJsonObject params, RenderingContext context, int col, int nbRows, int nbCols, TableConfig config) throws DocumentException {
        return PDFUtils.createCell(params, context, this.header, 0, col, nbRows, nbCols, config);
    }

    public PdfPCell createContentPdfCell(PJsonObject params, RenderingContext context, int row, int col, int nbRows, int nbCols, TableConfig config) throws DocumentException {
        return PDFUtils.createCell(params, context, this.cell, row, col, nbRows, nbCols, config);
    }

    public boolean isVisible(RenderingContext context, PJsonObject params) {
        return this.header.isVisible(context, params);
    }

    public void validate() {
        if (this.header == null) {
            throw new InvalidValueException("header", "null");
        }
        if (this.cell == null) {
            throw new InvalidValueException("header", "null");
        }
        this.header.validate();
        this.cell.validate();
    }

    public void setColumnWeight(int columnWeight) {
        this.columnWeight = columnWeight;
        if (columnWeight < 0) {
            throw new InvalidValueException("columnWeight", columnWeight);
        }
    }

    public int getColumnWeight() {
        return this.columnWeight;
    }
}

