/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config.layout;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.pdf.PdfPTable;
import java.util.ArrayList;
import java.util.List;
import org.mapfish.print.InvalidJsonValueException;
import org.mapfish.print.InvalidValueException;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.config.layout.Block;
import org.mapfish.print.config.layout.ColumnDef;
import org.mapfish.print.config.layout.ColumnDefs;
import org.mapfish.print.config.layout.TableConfig;
import org.mapfish.print.utils.PJsonArray;
import org.mapfish.print.utils.PJsonObject;

public class AttributesBlock
extends Block {
    private String source;
    private ColumnDefs columnDefs = new ColumnDefs();
    private boolean includeHeader = true;
    private String groupBy = null;
    private Block groupTitle = null;
    private boolean groupsOnNewPage = false;
    private String currentGroup = null;
    private TableConfig tableConfig = null;

    @Override
    public void render(PJsonObject params, Block.PdfElement target, RenderingContext context) throws DocumentException {
        PJsonObject sourceJson = params.optJSONObject(this.source);
        if (sourceJson == null) {
            sourceJson = context.getGlobalParams().optJSONObject(this.source);
        }
        if (sourceJson == null || sourceJson.size() == 0) {
            return;
        }
        PJsonArray originalData = sourceJson.optJSONArray("data");
        PJsonArray firstLine = sourceJson.getJSONArray("columns");
        ArrayList<Integer> columnWidths = ((ColumnDef)this.columnDefs.values().iterator().next()).getColumnWeight() > 0 ? new ArrayList<Integer>() : null;
        int nbCols = 0;
        for (int colNum = 0; colNum < firstLine.size(); ++colNum) {
            String name = firstLine.getString(colNum);
            ColumnDef colDef = (ColumnDef)this.columnDefs.get(name);
            if (colDef != null && colDef.isVisible(context, params)) {
                ++nbCols;
                if (columnWidths == null) continue;
                columnWidths.add(colDef.getColumnWeight());
                continue;
            }
            context.addError(new InvalidJsonValueException(firstLine, name, "Unknown column"));
        }
        ArrayList groups = new ArrayList();
        ArrayList<PJsonObject> current = new ArrayList<PJsonObject>();
        for (int count = 0; count < originalData.size(); ++count) {
            PJsonObject pJsonObject = originalData.getJSONObject(count);
            if (this.groupBy != null) {
                String group = pJsonObject.getString(this.groupBy);
                if (this.currentGroup == null || !this.currentGroup.equals(group)) {
                    if (current.size() > 0) {
                        groups.add(current);
                        current = new ArrayList();
                    }
                    this.currentGroup = group;
                }
            }
            current.add(pJsonObject);
        }
        groups.add(current);
        for (List list : groups) {
            if (this.groupsOnNewPage) {
                context.getDocument().newPage();
            }
            if (this.groupTitle != null && list.size() > 0) {
                this.groupTitle.render((PJsonObject)list.get(0), target, context);
            }
            PdfPTable table = new PdfPTable(nbCols);
            table.setWidthPercentage(100.0f);
            if (columnWidths != null) {
                int[] array = new int[columnWidths.size()];
                for (int i = 0; i < columnWidths.size(); ++i) {
                    array[i] = (Integer)columnWidths.get(i);
                }
                table.setWidths(array);
            }
            int nbRows = list.size() + (this.includeHeader ? 1 : 0);
            if (this.includeHeader) {
                for (int colNum = 0; colNum < firstLine.size(); ++colNum) {
                    String name = firstLine.getString(colNum);
                    ColumnDef colDef = (ColumnDef)this.columnDefs.get(name);
                    if (colDef == null || !colDef.isVisible(context, params)) continue;
                    table.addCell(colDef.createHeaderPdfCell(params, context, colNum, nbRows, nbCols, this.tableConfig));
                }
                table.setHeaderRows(1);
            }
            for (int rowNum = 0; rowNum < list.size(); ++rowNum) {
                PJsonObject row = (PJsonObject)list.get(rowNum);
                int realColNum = 0;
                for (int colNum = 0; colNum < firstLine.size(); ++colNum) {
                    String name = firstLine.getString(colNum);
                    ColumnDef colDef = (ColumnDef)this.columnDefs.get(name);
                    if (colDef == null || !colDef.isVisible(context, params)) continue;
                    table.addCell(colDef.createContentPdfCell(row, context, rowNum + 1, realColNum, nbRows, nbCols, this.tableConfig));
                    ++realColNum;
                }
            }
            table.setSpacingAfter((float)this.spacingAfter);
            target.add((Element)table);
        }
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setColumnDefs(ColumnDefs columnDefs) {
        this.columnDefs = columnDefs;
    }

    public void setTableConfig(TableConfig tableConfig) {
        this.tableConfig = tableConfig;
    }

    public String getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(String groupBy) {
        this.groupBy = groupBy;
    }

    public Block getGroupTitle() {
        return this.groupTitle;
    }

    public void setGroupTitle(Block groupTitle) {
        this.groupTitle = groupTitle;
    }

    public boolean isIncludeHeader() {
        return this.includeHeader;
    }

    public void setIncludeHeader(boolean includeHeader) {
        this.includeHeader = includeHeader;
    }

    public boolean isGroupsOnNewPage() {
        return this.groupsOnNewPage;
    }

    public void setGroupsOnNewPage(boolean groupsOnNewPage) {
        this.groupsOnNewPage = groupsOnNewPage;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.source == null) {
            throw new InvalidValueException("source", "null");
        }
        if (this.columnDefs == null) {
            throw new InvalidValueException("columnDefs", "null");
        }
        this.columnDefs.validate();
        if (this.tableConfig != null) {
            this.tableConfig.validate();
        }
    }
}

