/*
 * Decompiled with CFR 0.152.
 */
package org.fao.oaipmh.util;

import java.util.Map;
import org.fao.geonet.domain.ISODate;
import org.fao.oaipmh.OaiPmh;
import org.jdom.Content;
import org.jdom.Element;

public class Lib {
    public static Element createOaiRoot() {
        Element root = new Element("OAI-PMH", OaiPmh.Namespaces.OAI_PMH);
        root.setAttribute("schemaLocation", "http://www.openarchives.org/OAI/2.0/ http://www.openarchives.org/OAI/2.0/OAI-PMH.xsd", OaiPmh.Namespaces.XSI);
        Element date = new Element("responseDate", OaiPmh.Namespaces.OAI_PMH).setText(new ISODate().getDateAndTime());
        root.addContent((Content)date);
        return root;
    }

    public static Element createOaiRoot(String url, Map<String, String> params, Element response) {
        Element root = Lib.createOaiRoot();
        Element req = new Element("request", OaiPmh.Namespaces.OAI_PMH).setText(url);
        if (params != null) {
            for (Map.Entry<String, String> param : params.entrySet()) {
                req.setAttribute(param.getKey(), param.getValue());
            }
        }
        root.addContent((Content)req);
        root.addContent((Content)response);
        return root;
    }

    public static void add(Element parent, String name, String value) {
        parent.addContent((Content)new Element(name, OaiPmh.Namespaces.OAI_PMH).setText(value));
    }

    public static boolean isRootValid(Element response) {
        if (!response.getName().equals("OAI-PMH")) {
            return false;
        }
        return response.getNamespace().equals((Object)OaiPmh.Namespaces.OAI_PMH);
    }

    public static boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

