/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.vec;

import java.util.Optional;
import org.apache.lucene.store.IndexInput;
import org.elasticsearch.nativeaccess.NativeAccess;
import org.elasticsearch.vec.VectorScorer;
import org.elasticsearch.vec.VectorScorerFactory;
import org.elasticsearch.vec.VectorSimilarityType;
import org.elasticsearch.vec.internal.DotProduct;
import org.elasticsearch.vec.internal.Euclidean;
import org.elasticsearch.vec.internal.IndexInputUtils;
import org.elasticsearch.vec.internal.MaximumInnerProduct;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class VectorScorerFactoryImpl
implements VectorScorerFactory {
    static final VectorScorerFactoryImpl INSTANCE = NativeAccess.instance().getVectorSimilarityFunctions().map(ignore -> new VectorScorerFactoryImpl()).orElse(null);

    private VectorScorerFactoryImpl() {
    }

    @Override
    public Optional<VectorScorer> getScalarQuantizedVectorScorer(int dims, int maxOrd, float scoreCorrectionConstant, VectorSimilarityType similarityType, IndexInput input) {
        if ((input = IndexInputUtils.unwrapAndCheckInputOrNull(input)) == null) {
            return Optional.empty();
        }
        return Optional.of(switch (similarityType) {
            default -> throw new MatchException(null, null);
            case VectorSimilarityType.COSINE, VectorSimilarityType.DOT_PRODUCT -> new DotProduct(dims, maxOrd, scoreCorrectionConstant, input);
            case VectorSimilarityType.EUCLIDEAN -> new Euclidean(dims, maxOrd, scoreCorrectionConstant, input);
            case VectorSimilarityType.MAXIMUM_INNER_PRODUCT -> new MaximumInnerProduct(dims, maxOrd, scoreCorrectionConstant, input);
        });
    }
}

