/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.doi.client;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.exception.ResourceAlreadyExistException;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.constants.Geonet;
import org.fao.geonet.doi.client.DoiBuilder;
import org.fao.geonet.doi.client.DoiClientException;
import org.fao.geonet.doi.client.DoiDataciteClient;
import org.fao.geonet.doi.client.DoiMedraClient;
import org.fao.geonet.doi.client.IDoiClient;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.DoiServer;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.MetadataStatus;
import org.fao.geonet.domain.SchematronRequirement;
import org.fao.geonet.domain.User;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.ApplicableSchematron;
import org.fao.geonet.kernel.SchematronValidator;
import org.fao.geonet.kernel.datamanager.IMetadataStatus;
import org.fao.geonet.kernel.datamanager.base.BaseMetadataManager;
import org.fao.geonet.kernel.datamanager.base.BaseMetadataSchemaUtils;
import org.fao.geonet.kernel.datamanager.base.BaseMetadataUtils;
import org.fao.geonet.kernel.schema.MetadataSchema;
import org.fao.geonet.kernel.search.IndexingMode;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.languages.FeedbackLanguages;
import org.fao.geonet.repository.SchematronRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.util.LocalizedEmail;
import org.fao.geonet.util.LocalizedEmailComponent;
import org.fao.geonet.util.LocalizedEmailParameter;
import org.fao.geonet.util.MailUtil;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;

public class DoiManager {
    private static final String DOI_ADD_XSL_PROCESS = "process/doi-add.xsl";
    private static final String DOI_REMOVE_XSL_PROCESS = "process/doi-remove.xsl";
    public static final String DATACITE_XSL_CONVERSION_FILE = "formatter/datacite/view.xsl";
    public static final String DATACITE_MEDRA_XSL_CONVERSION_FILE = "formatter/eu-po-doi/view.xsl";
    public static final String DOI_ID_PARAMETER = "doiId";
    public static final String DOI_DEFAULT_URL = "https://doi.org/";
    public static final String DOI_DEFAULT_PATTERN = "{{uuid}}";
    private final SettingManager sm;
    private final BaseMetadataSchemaUtils schemaUtils;
    private final BaseMetadataManager metadataManager;
    private final BaseMetadataUtils metadataUtils;
    private final SchematronValidator validator;
    private final DoiBuilder doiBuilder;
    private final SchematronRepository schematronRepository;

    public DoiManager(SettingManager sm, BaseMetadataSchemaUtils schemaUtils, BaseMetadataManager metadataManager, BaseMetadataUtils metadataUtils, SchematronValidator validator, DoiBuilder doiBuilder, SchematronRepository schematronRepository) {
        this.sm = sm;
        this.schemaUtils = schemaUtils;
        this.metadataManager = metadataManager;
        this.metadataUtils = metadataUtils;
        this.validator = validator;
        this.doiBuilder = doiBuilder;
        this.schematronRepository = schematronRepository;
    }

    private IDoiClient createDoiClient(DoiServer doiServer) {
        boolean isMedra = this.isMedraServer(doiServer);
        return isMedra ? new DoiMedraClient(doiServer.getUrl(), doiServer.getUsername(), doiServer.getPassword(), doiServer.getPublicUrl()) : new DoiDataciteClient(doiServer.getUrl(), doiServer.getUsername(), doiServer.getPassword(), doiServer.getPublicUrl());
    }

    public String checkDoiUrl(DoiServer doiServer, AbstractMetadata metadata) throws DoiClientException {
        this.checkInitialised(doiServer);
        this.checkCanHandleMetadata(doiServer, metadata);
        return this.doiBuilder.create(doiServer.getPattern(), doiServer.getPrefix(), metadata);
    }

    public Map<String, Boolean> check(ServiceContext serviceContext, DoiServer doiServer, AbstractMetadata metadata, Element dataciteMetadata) throws Exception {
        HashMap<String, Boolean> conditions = new HashMap<String, Boolean>();
        this.checkInitialised(doiServer);
        this.checkCanHandleMetadata(doiServer, metadata);
        conditions.put("doiConditionAPIConfigured", true);
        IDoiClient doiClient = this.createDoiClient(doiServer);
        String doi = this.doiBuilder.create(doiServer.getPattern(), doiServer.getPrefix(), metadata);
        this.checkPreConditions(doiClient, metadata, doi);
        conditions.put("doiConditionRecordIsPublic", true);
        conditions.put("doiConditionStandardSupportDoiCreation", true);
        Element dataciteFormatMetadata = dataciteMetadata == null ? this.convertXmlToDataCiteFormat(doiServer, metadata.getDataInfo().getSchemaId(), metadata.getXmlData(false), doi) : dataciteMetadata;
        this.checkPreConditionsOnDataCite(doiClient, metadata, doi, dataciteFormatMetadata, serviceContext.getLanguage());
        conditions.put("doiConditionDataCiteFormatIsValid", true);
        return conditions;
    }

    public Map<String, String> register(ServiceContext context, DoiServer doiServer, AbstractMetadata metadata) throws Exception {
        HashMap<String, String> doiInfo = new HashMap<String, String>(3);
        String doi = this.doiBuilder.create(doiServer.getPattern(), doiServer.getPrefix(), metadata);
        doiInfo.put("doi", doi);
        Element dataciteFormatMetadata = this.convertXmlToDataCiteFormat(doiServer, metadata.getDataInfo().getSchemaId(), metadata.getXmlData(false), doi);
        try {
            this.check(context, doiServer, metadata, dataciteFormatMetadata);
        }
        catch (ResourceAlreadyExistException ignore) {
            doiInfo.put("update", "true");
        }
        catch (Exception e) {
            throw e;
        }
        IDoiClient doiClient = this.createDoiClient(doiServer);
        this.createDoi(context, doiClient, doiServer, metadata, doiInfo, dataciteFormatMetadata);
        this.checkDoiCreation(metadata, doiInfo);
        return doiInfo;
    }

    private void checkPreConditions(IDoiClient doiClient, AbstractMetadata metadata, String doi) throws DoiClientException, IOException, JDOMException, ResourceAlreadyExistException {
        AccessManager am = (AccessManager)ApplicationContextHolder.get().getBean(AccessManager.class);
        boolean visibleToAll = false;
        try {
            visibleToAll = am.isVisibleToAll("" + metadata.getId());
        }
        catch (Exception e) {
            throw new DoiClientException(String.format("Failed to check if record '%s' is visible to all for DOI creation. Error is %s.", metadata.getUuid(), e.getMessage())).withMessageKey("exception.doi.failedVisibilityCheck").withDescriptionKey("exception.doi.failedVisibilityCheck.description", new String[]{metadata.getUuid(), e.getMessage()});
        }
        if (!visibleToAll) {
            throw new DoiClientException(String.format("Record '%s' is not public and we cannot request a DOI for such a record. Publish this record first.", metadata.getUuid())).withMessageKey("exception.doi.recordNotPublic").withDescriptionKey("exception.doi.recordNotPublic.description", new String[]{metadata.getUuid()});
        }
        try {
            String currentDoi = this.metadataUtils.getDoi(metadata.getUuid());
            if (StringUtils.isNotEmpty((String)currentDoi)) {
                String newDoi = doiClient.createPublicUrl(doi);
                if (!currentDoi.equals(newDoi)) {
                    throw new DoiClientException(String.format("Record '%s' already contains a DOI <a href='%s'>%s</a> which is not equal to the DOI about to be created (ie. '%s'). Maybe current DOI does not correspond to that record? This may happen when creating a copy of a record having an existing DOI.", metadata.getUuid(), currentDoi, currentDoi, newDoi)).withMessageKey("exception.doi.resourcesContainsDoiNotEqual").withDescriptionKey("exception.doi.resourcesContainsDoiNotEqual.description", new String[]{metadata.getUuid(), currentDoi, currentDoi, newDoi});
                }
                throw new ResourceAlreadyExistException(String.format("Record '%s' already contains a DOI. The DOI is <a href='%s'>%s</a>. You've to update existing DOI. Remove the DOI reference if it does not apply to that record.", metadata.getUuid(), currentDoi, currentDoi)).withMessageKey("exception.doi.resourceContainsDoi").withDescriptionKey("exception.doi.resourceContainsDoi.description", (Object[])new String[]{metadata.getUuid(), currentDoi, currentDoi});
            }
        }
        catch (ResourceNotFoundException e) {
            MetadataSchema schema = this.schemaUtils.getSchema(metadata.getDataInfo().getSchemaId());
            throw new DoiClientException(String.format("Record '%s' is in schema '%s' and we cannot find a saved query with id '%s' to retrieve the DOI. Error is %s. Check the schema %sSchemaPlugin and add the DOI get query.", metadata.getUuid(), schema.getName(), "doi-get", e.getMessage(), schema.getName())).withMessageKey("exception.doi.missingSavedquery").withDescriptionKey("exception.doi.missingSavedquery.description", new String[]{metadata.getUuid(), schema.getName(), "doi-get", e.getMessage(), schema.getName()});
        }
    }

    private void checkPreConditionsOnDataCite(IDoiClient doiClient, AbstractMetadata metadata, String doi, Element dataciteMetadata, String language) throws DoiClientException, ResourceAlreadyExistException {
        try {
            ArrayList validations = new ArrayList();
            ArrayList applicableSchematron = Lists.newArrayList();
            ApplicableSchematron schematron = new ApplicableSchematron(SchematronRequirement.REQUIRED, this.schematronRepository.findOneByFileAndSchemaName("schematron-rules-datacite.xsl", metadata.getDataInfo().getSchemaId()));
            applicableSchematron.add(schematron);
            Element rules = this.validator.applyCustomSchematronRules(metadata.getDataInfo().getSchemaId(), metadata.getId(), metadata.getXmlData(false), language, validations, (List)applicableSchematron);
            ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
            namespaces.add(Geonet.Namespaces.GEONET);
            namespaces.add(Geonet.Namespaces.SVRL);
            List failures = Xml.selectNodes((Element)rules, (String)".//svrl:failed-assert/svrl:text/*", namespaces);
            StringBuilder message = new StringBuilder();
            if (!failures.isEmpty()) {
                message.append("<ul>");
                failures.forEach(f -> message.append("<li>").append(((Element)f).getTextNormalize()).append("</li>"));
                message.append("</ul>");
                throw new DoiClientException(String.format("Record '%s' is not conform with DataCite format. %d mandatory field(s) missing. %s", metadata.getUuid(), failures.size(), message)).withMessageKey("exception.doi.recordNotConformantMissingInfo").withDescriptionKey("exception.doi.recordNotConformantMissingInfo.description", new String[]{metadata.getUuid(), String.valueOf(failures.size()), message.toString()});
            }
        }
        catch (IOException | JDOMException e) {
            throw new DoiClientException(String.format("Record '%s' is not conform with DataCite validation rules for mandatory fields. Error is: %s. Required fields in DataCite are: identifier, creators, titles, publisher, publicationYear, resourceType. <a href='%sapi/records/%s/formatters/datacite?output=xml'>Check the DataCite format output</a> and adapt the record content to add missing information.", metadata.getUuid(), e.getMessage(), this.sm.getNodeURL(), metadata.getUuid())).withMessageKey("exception.doi.recordNotConformantMissingMandatory").withDescriptionKey("exception.doi.recordNotConformantMissingMandatory.description", new String[]{metadata.getUuid(), e.getMessage(), this.sm.getNodeURL(), metadata.getUuid()});
        }
        try {
            Xml.validate((Element)dataciteMetadata);
        }
        catch (Exception e) {
            throw new DoiClientException(String.format("Record '%s' converted to DataCite format is invalid. Error is: %s. Required fields in DataCite are: identifier, creators, titles, publisher, publicationYear, resourceType. <a href='%sapi/records/%s/formatters/datacite?output=xml'>Check the DataCite format output</a> and adapt the record content to add missing information.", metadata.getUuid(), e.getMessage(), this.sm.getNodeURL(), metadata.getUuid())).withMessageKey("exception.doi.recordInvalid").withDescriptionKey("exception.doi.recordInvalid.description", new String[]{metadata.getUuid(), e.getMessage(), this.sm.getNodeURL(), metadata.getUuid()});
        }
        String doiResponse = doiClient.retrieveDoi(doi);
        if (doiResponse != null) {
            throw new ResourceAlreadyExistException(String.format("Record '%s' looks to be already published on DataCite with DOI <a href='%s'>'%s'</a>. DOI on Datacite point to: <a href='%s'>%s</a>. If the DOI is not correct, remove it from the record and ask for a new one.", metadata.getUuid(), doiClient.createUrl("doi") + "/" + doi, doi, doi, doiResponse)).withMessageKey("exception.doi.resourceAlreadyPublished").withDescriptionKey("exception.doi.resourceAlreadyPublished.description", (Object[])new String[]{metadata.getUuid(), doiClient.createUrl("doi") + "/" + doi, doi, doi, doiResponse});
        }
    }

    private void createDoi(ServiceContext context, IDoiClient doiClient, DoiServer doiServer, AbstractMetadata metadata, Map<String, String> doiInfo, Element dataciteMetadata) throws Exception {
        doiClient.createDoiMetadata(doiInfo.get("doi"), Xml.getString((Element)dataciteMetadata));
        String landingPage = doiServer.getLandingPageTemplate().replace(DOI_DEFAULT_PATTERN, metadata.getUuid());
        doiInfo.put("doiLandingPage", landingPage);
        doiInfo.put("doiUrl", doiClient.createPublicUrl(doiInfo.get("doi")));
        doiClient.createDoi(doiInfo.get("doi"), landingPage);
        Element recordWithDoi = this.setDOIValue(doiClient, doiInfo.get("doi"), metadata.getDataInfo().getSchemaId(), metadata.getXmlData(false));
        this.metadataManager.updateMetadata(context, "" + metadata.getId(), recordWithDoi, false, true, context.getLanguage(), new ISODate().toString(), true, IndexingMode.full);
        this.notifyByMail(context, metadata, doiClient.createPublicUrl(doiInfo.get("doi")));
    }

    private void checkDoiCreation(AbstractMetadata metadata, Map<String, String> doi) {
    }

    public void unregisterDoi(DoiServer doiServer, AbstractMetadata metadata, ServiceContext context) throws DoiClientException, ResourceNotFoundException {
        this.checkInitialised(doiServer);
        this.checkCanHandleMetadata(doiServer, metadata);
        IDoiClient doiClient = this.createDoiClient(doiServer);
        String doi = this.doiBuilder.create(doiServer.getPattern(), doiServer.getPrefix(), metadata);
        String doiResponse = doiClient.retrieveDoi(doi);
        if (doiResponse == null) {
            throw new ResourceNotFoundException(String.format("Record '%s' is not available on DataCite. DOI '%s' does not exist.", metadata.getUuid(), doi));
        }
        try {
            Element md = metadata.getXmlData(false);
            String doiUrl = this.metadataUtils.getDoi(metadata.getUuid());
            doiClient.deleteDoiMetadata(doi);
            doiClient.deleteDoi(doi);
            Element recordWithoutDoi = this.removeDOIValue(doiUrl, metadata.getDataInfo().getSchemaId(), md);
            this.metadataManager.updateMetadata(context, "" + metadata.getId(), recordWithoutDoi, false, true, context.getLanguage(), new ISODate().toString(), true, IndexingMode.full);
        }
        catch (Exception ex) {
            throw new DoiClientException(String.format("Error unregistering DOI: %s", ex.getMessage())).withMessageKey("exception.doi.serverErrorUnregister").withDescriptionKey("exception.doi.serverErrorUnregister.description", new String[]{ex.getMessage()});
        }
    }

    public Element setDOIValue(IDoiClient doiClient, String doi, String schema, Element md) throws Exception {
        Path styleSheet = this.schemaUtils.getSchemaDir(schema).resolve(DOI_ADD_XSL_PROCESS);
        boolean exists = Files.exists(styleSheet, new LinkOption[0]);
        if (!exists) {
            String message = String.format("To create a DOI, the schema has to defined how to insert a DOI in the record. The schema_plugins/%s/process/%s was not found. Create the XSL transformation.", schema, DOI_ADD_XSL_PROCESS);
            throw new DoiClientException(String.format("Error creating  DOI: %s", message)).withMessageKey("exception.doi.serverErrorCreate").withDescriptionKey("exception.doi.serverErrorCreate.description", new String[]{message});
        }
        String doiPublicUrl = doiClient.createPublicUrl("");
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("doi", doi);
        params.put("doiProxy", doiPublicUrl);
        return Xml.transform((Element)md, (Path)styleSheet, params);
    }

    public Element removeDOIValue(String doi, String schema, Element md) throws Exception {
        Path styleSheet = this.schemaUtils.getSchemaDir(schema).resolve(DOI_REMOVE_XSL_PROCESS);
        boolean exists = Files.exists(styleSheet, new LinkOption[0]);
        if (!exists) {
            String message = String.format("To remove a DOI, the schema has to defined how to remove a DOI in the record. The schema_plugins/%s/process/%s was not found. Create the XSL transformation.", schema, DOI_REMOVE_XSL_PROCESS);
            throw new DoiClientException(String.format("Error deleting  DOI: %s", message)).withMessageKey("exception.doi.serverErrorDelete").withDescriptionKey("exception.doi.serverErrorDelete.description", new String[]{message});
        }
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("doi", doi);
        return Xml.transform((Element)md, (Path)styleSheet, params);
    }

    private Element convertXmlToDataCiteFormat(DoiServer doiServer, String schema, Element md, String doi) throws Exception {
        Path styleSheet = this.schemaUtils.getSchemaDir(schema).resolve(this.isMedraServer(doiServer) ? DATACITE_MEDRA_XSL_CONVERSION_FILE : DATACITE_XSL_CONVERSION_FILE);
        boolean exists = Files.exists(styleSheet, new LinkOption[0]);
        if (!exists) {
            String message = String.format("To create a DOI, the record needs to be converted to the DataCite format (https://schema.datacite.org/). You need to create a formatter for this in schema_plugins/%s/%s. If the standard is a profile of ISO19139, you can simply point to the ISO19139 formatter.", schema, DATACITE_XSL_CONVERSION_FILE);
            throw new DoiClientException(String.format("Error creating  DOI: %s", message)).withMessageKey("exception.doi.serverErrorCreate").withDescriptionKey("exception.doi.serverErrorCreate.description", new String[]{message});
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(DOI_ID_PARAMETER, doi);
        params.put("doiServerId", "" + doiServer.getId());
        return Xml.transform((Element)md, (Path)styleSheet, params);
    }

    private void checkInitialised(DoiServer doiServer) throws DoiClientException {
        boolean emptyUrl = StringUtils.isEmpty((String)doiServer.getUrl());
        boolean emptyUsername = StringUtils.isEmpty((String)doiServer.getUsername());
        boolean emptyPassword = StringUtils.isEmpty((String)doiServer.getPassword());
        boolean emptyPrefix = StringUtils.isEmpty((String)doiServer.getPrefix());
        if (emptyUrl || emptyUsername || emptyPassword || emptyPrefix) {
            throw new DoiClientException("DOI server configuration is not complete. Check the DOI server configuration to complete it.").withMessageKey("exception.doi.configurationMissing").withDescriptionKey("exception.doi.configurationMissing.description", new String[0]);
        }
    }

    private void checkCanHandleMetadata(DoiServer doiServer, AbstractMetadata metadata) throws DoiClientException {
        if (!doiServer.getPublicationGroups().isEmpty()) {
            Integer groupOwner = metadata.getSourceInfo().getGroupOwner();
            if (doiServer.getPublicationGroups().stream().noneMatch(g -> g.getId() == groupOwner.intValue())) {
                throw new DoiClientException(String.format("DOI server '%s' can not handle the metadata with UUID '%s'.", doiServer.getName(), metadata.getUuid())).withMessageKey("exception.doi.serverCanNotHandleRecord").withDescriptionKey("exception.doi.serverCanNotHandleRecord.description", new String[]{doiServer.getName(), metadata.getUuid()});
            }
        }
    }

    private boolean isMedraServer(DoiServer doiServer) {
        return doiServer.getUrl().contains("medra.org");
    }

    private void notifyByMail(ServiceContext context, AbstractMetadata metadata, String doiUrl) {
        SettingManager sm = (SettingManager)context.getBean(SettingManager.class);
        boolean notifyToTaskOwner = sm.getValueAsBool("system/publication/doi/doimailnotification", false);
        if (notifyToTaskOwner) {
            IMetadataStatus metadataStatus = (IMetadataStatus)context.getBean(IMetadataStatus.class);
            try {
                UserRepository userRepository;
                Optional ownerUser;
                Integer taskOwner;
                List metadataStatuses = metadataStatus.getAllStatus(metadata.getId());
                Optional<MetadataStatus> msOpt = metadataStatuses.stream().filter(ms -> ms.getStatusValue().getName().equals("doiCreationTask") && ms.getCloseDate() == null).findFirst();
                if (msOpt.isPresent() && (taskOwner = Integer.valueOf(msOpt.get().getUserId())) != null && (ownerUser = (userRepository = (UserRepository)context.getBean(UserRepository.class)).findById((Object)taskOwner)).isPresent()) {
                    User user = (User)ownerUser.get();
                    if (StringUtils.isNotBlank((String)user.getEmail())) {
                        FeedbackLanguages feedbackLanguages = (FeedbackLanguages)context.getBean(FeedbackLanguages.class);
                        Locale[] feedbackLocales = feedbackLanguages.getLocales(new Locale(context.getLanguage()));
                        LocalizedEmailComponent emailSubjectComponent = new LocalizedEmailComponent(LocalizedEmailComponent.ComponentType.SUBJECT, "doi_publication_subject", LocalizedEmailComponent.KeyType.MESSAGE_KEY, LocalizedEmailComponent.ReplacementType.POSITIONAL_FORMAT);
                        emailSubjectComponent.enableCompileWithIndexFields(metadata.getUuid());
                        LocalizedEmailComponent emailMessageComponent = new LocalizedEmailComponent(LocalizedEmailComponent.ComponentType.MESSAGE, "doi_publication_message", LocalizedEmailComponent.KeyType.MESSAGE_KEY, LocalizedEmailComponent.ReplacementType.POSITIONAL_FORMAT);
                        emailMessageComponent.enableCompileWithIndexFields(metadata.getUuid());
                        emailMessageComponent.enableReplaceLinks(Boolean.valueOf(true));
                        for (Locale feedbackLocale : feedbackLocales) {
                            emailSubjectComponent.addParameters(feedbackLocale, new LocalizedEmailParameter[]{new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)1, (Object)sm.getSiteName())});
                            emailMessageComponent.addParameters(feedbackLocale, new LocalizedEmailParameter[]{new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)1, (Object)doiUrl)});
                            emailMessageComponent.addParameters(feedbackLocale, new LocalizedEmailParameter[]{new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)2, (Object)doiUrl)});
                            emailMessageComponent.addParameters(feedbackLocale, new LocalizedEmailParameter[]{new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)3, (Object)sm.getSiteName())});
                        }
                        LocalizedEmail localizedEmail = new LocalizedEmail(Boolean.valueOf(true));
                        localizedEmail.addComponents(new LocalizedEmailComponent[]{emailSubjectComponent, emailMessageComponent});
                        String mailSubject = localizedEmail.getParsedSubject(feedbackLocales);
                        String htmlMessage = localizedEmail.getParsedMessage(feedbackLocales);
                        MailUtil.sendHtmlMail(Arrays.asList(user.getEmail()), (String)mailSubject, (String)htmlMessage, (SettingManager)sm);
                    } else {
                        Log.warning((String)"geonetwork.doi", (Object)"   -- Can not send DOI publication mail notification. Error: user does not have an email address.");
                    }
                }
            }
            catch (Exception ex) {
                Log.warning((String)"geonetwork.doi", (Object)("   -- Can not send DOI publication mail notification. User does not have a mail. Error: " + ex.getMessage()));
            }
        }
    }
}

