/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.geotools.api.feature.ComplexAttribute;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.api.filter.identity.Identifier;
import org.geotools.feature.FeatureImpl;
import org.geotools.feature.NameImpl;
import org.geotools.gml3.GML;
import org.geotools.gml3.XSDIdRegistry;
import org.geotools.util.Converters;
import org.geotools.xlink.XLINK;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class FeaturePropertyTypeBinding
extends AbstractComplexBinding {
    private XSDIdRegistry idSet;

    public FeaturePropertyTypeBinding(XSDIdRegistry idSet) {
        this.idSet = idSet;
    }

    public QName getTarget() {
        return GML.FeaturePropertyType;
    }

    public Class getType() {
        return Feature.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        return node.getChildValue(Feature.class);
    }

    public Object getProperty(Object object, QName name) throws Exception {
        if (GML._Feature.equals(name)) {
            if (object instanceof SimpleFeature) {
                return object;
            }
            if (object instanceof FeatureImpl) {
                ComplexAttribute complex = (ComplexAttribute)object;
                Identifier ident = complex.getIdentifier();
                if (ident == null) {
                    return object;
                }
                String id = ident instanceof FeatureId ? ((FeatureId)ident).getRid() : (String)Converters.convert((Object)ident.getID(), String.class);
                if (this.idSet.idExists(id)) {
                    return null;
                }
                return object;
            }
            if (object instanceof ComplexAttribute) {
                return ((ComplexAttribute)object).getProperties().iterator().next();
            }
        }
        return null;
    }

    public Element encode(Object object, Document document, Element value) throws Exception {
        if (object instanceof ComplexAttribute) {
            ComplexAttribute complex = (ComplexAttribute)object;
            this.checkXlinkHref(complex);
        }
        return value;
    }

    private void checkXlinkHref(ComplexAttribute att) {
        Identifier ident = att.getIdentifier();
        if (ident == null) {
            return;
        }
        String id = ident instanceof FeatureId ? ((FeatureId)ident).getRid() : (String)Converters.convert((Object)ident.getID(), String.class);
        if (this.idSet.idExists(id)) {
            Object clientProperties = att.getUserData().get(Attributes.class);
            Map<Name, CallSite> map = null;
            if (clientProperties == null) {
                map = new HashMap();
                att.getUserData().put(Attributes.class, map);
            } else {
                Map cast = (Map)clientProperties;
                map = cast;
            }
            map.put(FeaturePropertyTypeBinding.toTypeName(XLINK.HREF), (CallSite)((Object)("#" + id.toString())));
            att.setValue(Collections.emptyList());
        }
    }

    private static Name toTypeName(QName name) {
        if ("".equals(name.getNamespaceURI())) {
            return new NameImpl(name.getLocalPart());
        }
        return new NameImpl(name.getNamespaceURI(), name.getLocalPart());
    }
}

