/*
 * Decompiled with CFR 0.152.
 */
package net.opengis.gml311;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum KnotTypesType implements Enumerator
{
    UNIFORM(0, "uniform", "uniform"),
    QUASI_UNIFORM(1, "quasiUniform", "quasiUniform"),
    PIECEWISE_BEZIER(2, "piecewiseBezier", "piecewiseBezier");

    public static final int UNIFORM_VALUE = 0;
    public static final int QUASI_UNIFORM_VALUE = 1;
    public static final int PIECEWISE_BEZIER_VALUE = 2;
    private static final KnotTypesType[] VALUES_ARRAY;
    public static final List<KnotTypesType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static KnotTypesType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            KnotTypesType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static KnotTypesType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            KnotTypesType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static KnotTypesType get(int value) {
        switch (value) {
            case 0: {
                return UNIFORM;
            }
            case 1: {
                return QUASI_UNIFORM;
            }
            case 2: {
                return PIECEWISE_BEZIER;
            }
        }
        return null;
    }

    private KnotTypesType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new KnotTypesType[]{UNIFORM, QUASI_UNIFORM, PIECEWISE_BEZIER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

