/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.util.regex.Pattern;

public class EscapeSql {
    private static final Pattern SINGLE_QUOTE_PATTERN = Pattern.compile("'");
    private static final Pattern DOUBLE_QUOTE_PATTERN = Pattern.compile("\"");
    private static final Pattern BACKSLASH_PATTERN = Pattern.compile("\\\\");

    public static String escapeLiteral(String literal, boolean escapeBackslash, boolean escapeDoubleQuote) {
        String escaped = SINGLE_QUOTE_PATTERN.matcher(literal).replaceAll("''");
        if (escapeBackslash) {
            escaped = BACKSLASH_PATTERN.matcher(escaped).replaceAll("\\\\\\\\");
        }
        if (escapeDoubleQuote) {
            escaped = DOUBLE_QUOTE_PATTERN.matcher(escaped).replaceAll("\\\\\"");
        }
        return escaped;
    }

    public static String escapeSql(String str) {
        str = str.replaceAll("'", "''");
        str = str.replaceAll("\"", "\"\"");
        str = str.replaceAll("\\\\", "");
        return str;
    }
}

