/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFWrapper;
import org.apache.jena.sparql.core.Quad;

public class StreamTriplesOnly
extends StreamRDFWrapper {
    private boolean seenQuads = false;
    private final Runnable action;

    public static StreamRDF actionIfQuads(StreamRDF stream, Runnable action) {
        return new StreamTriplesOnly(stream, action);
    }

    private StreamTriplesOnly(StreamRDF sink, Runnable action) {
        super(sink);
        this.action = action;
    }

    @Override
    public void quad(Quad quad) {
        if (quad.isTriple() || quad.isDefaultGraph() || quad.isUnionGraph()) {
            this.triple(quad.asTriple());
            return;
        }
        if (!this.seenQuads) {
            this.action.run();
            this.seenQuads = true;
        }
    }
}

