/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.atlas.lib.cache.CacheInfo;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.lang.LabelToNode;
import org.apache.jena.riot.system.FactoryRDFStd;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.SyntaxLabels;
import org.apache.jena.sparql.graph.NodeConst;

public class FactoryRDFCaching
extends FactoryRDFStd {
    public static final int DftNodeCacheSize = 5000;
    private final int cacheSize;
    private final Cache<String, Node> cache;

    public FactoryRDFCaching() {
        this(5000, SyntaxLabels.createLabelToNode());
    }

    public FactoryRDFCaching(int cacheSize, LabelToNode labelMapping) {
        super(labelMapping);
        this.cacheSize = cacheSize;
        this.cache = this.setCache(cacheSize);
    }

    private Cache<String, Node> setCache(int cacheSize) {
        return CacheFactory.createSimpleCache((int)cacheSize);
    }

    @Override
    public Node createURI(String uriStr) {
        return (Node)this.cache.get((Object)uriStr, RiotLib::createIRIorBNode);
    }

    @Override
    public Node createTypedLiteral(String lexical, RDFDatatype datatype) {
        if (XSDDatatype.XSDinteger.equals(datatype)) {
            switch (lexical) {
                case "0": {
                    return NodeConst.nodeZero;
                }
                case "1": {
                    return NodeConst.nodeOne;
                }
                case "2": {
                    return NodeConst.nodeTwo;
                }
                case "-1": {
                    return NodeConst.nodeMinusOne;
                }
            }
        } else if (XSDDatatype.XSDboolean.equals(datatype)) {
            switch (lexical) {
                case "true": {
                    return NodeConst.nodeTrue;
                }
                case "false": {
                    return NodeConst.nodeFalse;
                }
            }
        }
        return super.createTypedLiteral(lexical, datatype);
    }

    @Override
    public Node createStringLiteral(String lexical) {
        if (lexical.isEmpty()) {
            return NodeConst.emptyString;
        }
        return super.createStringLiteral(lexical);
    }

    public CacheInfo stats() {
        return this.cache.stats();
    }
}

