/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.cowwoc.diffmatchpatch;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DiffMatchPatch {
    public float diffTimeout = 1.0f;
    public short diffEditCost = (short)4;
    public float matchThreshold = 0.5f;
    public int matchDistance = 1000;
    public float patchDeleteThreshold = 0.5f;
    public short patchMargin = (short)4;
    private static final short MATCH_MAX_BITS = 32;
    private final Pattern BLANKLINEEND = Pattern.compile("\\n\\r?\\n\\Z", 32);
    private final Pattern BLANKLINESTART = Pattern.compile("\\A\\r?\\n\\r?\\n", 32);

    public LinkedList<Diff> diffMain(String text1, String text2) {
        return this.diffMain(text1, text2, true);
    }

    public LinkedList<Diff> diffMain(String text1, String text2, boolean checklines) {
        long deadline = this.diffTimeout <= 0.0f ? Long.MAX_VALUE : System.currentTimeMillis() + (long)(this.diffTimeout * 1000.0f);
        return this.diffMain(text1, text2, checklines, deadline);
    }

    private LinkedList<Diff> diffMain(String text1, String text2, boolean checklines, long deadline) {
        if (text1 == null || text2 == null) {
            throw new IllegalArgumentException("Null inputs. (diffMain)");
        }
        if (text1.equals(text2)) {
            LinkedList<Diff> diffs = new LinkedList<Diff>();
            if (text1.length() != 0) {
                diffs.add(new Diff(Operation.EQUAL, text1));
            }
            return diffs;
        }
        int commonlength = this.diffCommonPrefix(text1, text2);
        String commonprefix = text1.substring(0, commonlength);
        text1 = text1.substring(commonlength);
        text2 = text2.substring(commonlength);
        commonlength = this.diffCommonSuffix(text1, text2);
        String commonsuffix = text1.substring(text1.length() - commonlength);
        text1 = text1.substring(0, text1.length() - commonlength);
        text2 = text2.substring(0, text2.length() - commonlength);
        LinkedList<Diff> diffs = this.diffCompute(text1, text2, checklines, deadline);
        if (commonprefix.length() != 0) {
            diffs.addFirst(new Diff(Operation.EQUAL, commonprefix));
        }
        if (commonsuffix.length() != 0) {
            diffs.addLast(new Diff(Operation.EQUAL, commonsuffix));
        }
        this.diffCleanupMerge(diffs);
        return diffs;
    }

    private LinkedList<Diff> diffCompute(String text1, String text2, boolean checklines, long deadline) {
        String shorttext;
        LinkedList<Diff> diffs = new LinkedList<Diff>();
        if (text1.length() == 0) {
            diffs.add(new Diff(Operation.INSERT, text2));
            return diffs;
        }
        if (text2.length() == 0) {
            diffs.add(new Diff(Operation.DELETE, text1));
            return diffs;
        }
        String longtext = text1.length() > text2.length() ? text1 : text2;
        int i = longtext.indexOf(shorttext = text1.length() > text2.length() ? text2 : text1);
        if (i != -1) {
            Operation op = text1.length() > text2.length() ? Operation.DELETE : Operation.INSERT;
            diffs.add(new Diff(op, longtext.substring(0, i)));
            diffs.add(new Diff(Operation.EQUAL, shorttext));
            diffs.add(new Diff(op, longtext.substring(i + shorttext.length())));
            return diffs;
        }
        if (shorttext.length() == 1) {
            diffs.add(new Diff(Operation.DELETE, text1));
            diffs.add(new Diff(Operation.INSERT, text2));
            return diffs;
        }
        String[] hm = this.diffHalfMatch(text1, text2);
        if (hm != null) {
            String text1a = hm[0];
            String text1b = hm[1];
            String text2a = hm[2];
            String text2b = hm[3];
            String midCommon = hm[4];
            LinkedList<Diff> diffsA = this.diffMain(text1a, text2a, checklines, deadline);
            LinkedList<Diff> diffsB = this.diffMain(text1b, text2b, checklines, deadline);
            diffs = diffsA;
            diffs.add(new Diff(Operation.EQUAL, midCommon));
            diffs.addAll(diffsB);
            return diffs;
        }
        if (checklines && text1.length() > 100 && text2.length() > 100) {
            return this.diffLineMode(text1, text2, deadline);
        }
        return this.diffBisect(text1, text2, deadline);
    }

    private LinkedList<Diff> diffLineMode(String text1, String text2, long deadline) {
        LinesToCharsResult a = this.diffLinesToChars(text1, text2);
        text1 = a.chars1;
        text2 = a.chars2;
        List<String> linearray = a.lineArray;
        LinkedList<Diff> diffs = this.diffMain(text1, text2, false, deadline);
        this.diffCharsToLines(diffs, linearray);
        this.diffCleanupSemantic(diffs);
        diffs.add(new Diff(Operation.EQUAL, ""));
        int countDelete = 0;
        int countInsert = 0;
        String textDelete = "";
        String textInsert = "";
        ListIterator<Diff> pointer = diffs.listIterator();
        Diff thisDiff = (Diff)pointer.next();
        while (thisDiff != null) {
            switch (thisDiff.operation) {
                case INSERT: {
                    ++countInsert;
                    textInsert = textInsert + thisDiff.text;
                    break;
                }
                case DELETE: {
                    ++countDelete;
                    textDelete = textDelete + thisDiff.text;
                    break;
                }
                case EQUAL: {
                    if (countDelete >= 1 && countInsert >= 1) {
                        pointer.previous();
                        for (int j = 0; j < countDelete + countInsert; ++j) {
                            pointer.previous();
                            pointer.remove();
                        }
                        for (Diff newDiff : this.diffMain(textDelete, textInsert, false, deadline)) {
                            pointer.add(newDiff);
                        }
                    }
                    countInsert = 0;
                    countDelete = 0;
                    textDelete = "";
                    textInsert = "";
                }
            }
            thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
        diffs.removeLast();
        return diffs;
    }

    protected LinkedList<Diff> diffBisect(String text1, String text2, long deadline) {
        int maxD;
        int text1Length = text1.length();
        int text2Length = text2.length();
        int vOffset = maxD = (text1Length + text2Length + 1) / 2;
        int vLength = 2 * maxD;
        int[] v1 = new int[vLength];
        int[] v2 = new int[vLength];
        for (int x = 0; x < vLength; ++x) {
            v1[x] = -1;
            v2[x] = -1;
        }
        v1[vOffset + 1] = 0;
        v2[vOffset + 1] = 0;
        int delta = text1Length - text2Length;
        boolean front = delta % 2 != 0;
        int k1start = 0;
        int k1end = 0;
        int k2start = 0;
        int k2end = 0;
        for (int d = 0; d < maxD && System.currentTimeMillis() <= deadline; ++d) {
            for (int k1 = -d + k1start; k1 <= d - k1end; k1 += 2) {
                int x2;
                int k2Offset;
                int y1;
                int k1Offset = vOffset + k1;
                int x1 = k1 == -d || k1 != d && v1[k1Offset - 1] < v1[k1Offset + 1] ? v1[k1Offset + 1] : v1[k1Offset - 1] + 1;
                for (y1 = x1 - k1; x1 < text1Length && y1 < text2Length && text1.charAt(x1) == text2.charAt(y1); ++x1, ++y1) {
                }
                v1[k1Offset] = x1;
                if (x1 > text1Length) {
                    k1end += 2;
                    continue;
                }
                if (y1 > text2Length) {
                    k1start += 2;
                    continue;
                }
                if (!front || (k2Offset = vOffset + delta - k1) < 0 || k2Offset >= vLength || v2[k2Offset] == -1 || x1 < (x2 = text1Length - v2[k2Offset])) continue;
                return this.diffBisectSplit(text1, text2, x1, y1, deadline);
            }
            for (int k2 = -d + k2start; k2 <= d - k2end; k2 += 2) {
                int k1Offset;
                int y2;
                int k2Offset = vOffset + k2;
                int x2 = k2 == -d || k2 != d && v2[k2Offset - 1] < v2[k2Offset + 1] ? v2[k2Offset + 1] : v2[k2Offset - 1] + 1;
                for (y2 = x2 - k2; x2 < text1Length && y2 < text2Length && text1.charAt(text1Length - x2 - 1) == text2.charAt(text2Length - y2 - 1); ++x2, ++y2) {
                }
                v2[k2Offset] = x2;
                if (x2 > text1Length) {
                    k2end += 2;
                    continue;
                }
                if (y2 > text2Length) {
                    k2start += 2;
                    continue;
                }
                if (front || (k1Offset = vOffset + delta - k2) < 0 || k1Offset >= vLength || v1[k1Offset] == -1) continue;
                int x1 = v1[k1Offset];
                int y1 = vOffset + x1 - k1Offset;
                if (x1 < (x2 = text1Length - x2)) continue;
                return this.diffBisectSplit(text1, text2, x1, y1, deadline);
            }
        }
        LinkedList<Diff> diffs = new LinkedList<Diff>();
        diffs.add(new Diff(Operation.DELETE, text1));
        diffs.add(new Diff(Operation.INSERT, text2));
        return diffs;
    }

    private LinkedList<Diff> diffBisectSplit(String text1, String text2, int x, int y, long deadline) {
        String text1a = text1.substring(0, x);
        String text2a = text2.substring(0, y);
        String text1b = text1.substring(x);
        String text2b = text2.substring(y);
        LinkedList<Diff> diffs = this.diffMain(text1a, text2a, false, deadline);
        LinkedList<Diff> diffsb = this.diffMain(text1b, text2b, false, deadline);
        diffs.addAll(diffsb);
        return diffs;
    }

    protected LinesToCharsResult diffLinesToChars(String text1, String text2) {
        ArrayList<String> lineArray = new ArrayList<String>();
        HashMap<String, Integer> lineHash = new HashMap<String, Integer>();
        lineArray.add("");
        String chars1 = this.diffLinesToCharsMunge(text1, lineArray, lineHash, 40000);
        String chars2 = this.diffLinesToCharsMunge(text2, lineArray, lineHash, 65535);
        return new LinesToCharsResult(chars1, chars2, lineArray);
    }

    private String diffLinesToCharsMunge(String text, List<String> lineArray, Map<String, Integer> lineHash, int maxLines) {
        int lineStart = 0;
        int lineEnd = -1;
        StringBuilder chars = new StringBuilder();
        while (lineEnd < text.length() - 1) {
            String line;
            lineEnd = text.indexOf(10, lineStart);
            if (lineEnd == -1) {
                lineEnd = text.length() - 1;
            }
            if (lineHash.containsKey(line = text.substring(lineStart, lineEnd + 1))) {
                chars.append(String.valueOf((char)lineHash.get(line).intValue()));
            } else {
                if (lineArray.size() == maxLines) {
                    line = text.substring(lineStart);
                    lineEnd = text.length();
                }
                lineArray.add(line);
                lineHash.put(line, lineArray.size() - 1);
                chars.append(String.valueOf((char)(lineArray.size() - 1)));
            }
            lineStart = lineEnd + 1;
        }
        return chars.toString();
    }

    protected void diffCharsToLines(List<Diff> diffs, List<String> lineArray) {
        for (Diff diff : diffs) {
            StringBuilder text = new StringBuilder();
            for (int y = 0; y < diff.text.length(); ++y) {
                text.append(lineArray.get(diff.text.charAt(y)));
            }
            diff.text = text.toString();
        }
    }

    public int diffCommonPrefix(String text1, String text2) {
        int n = Math.min(text1.length(), text2.length());
        for (int i = 0; i < n; ++i) {
            if (text1.charAt(i) == text2.charAt(i)) continue;
            return i;
        }
        return n;
    }

    public int diffCommonSuffix(String text1, String text2) {
        int text1Length = text1.length();
        int text2Length = text2.length();
        int n = Math.min(text1Length, text2Length);
        for (int i = 1; i <= n; ++i) {
            if (text1.charAt(text1Length - i) == text2.charAt(text2Length - i)) continue;
            return i - 1;
        }
        return n;
    }

    int diffCommonOverlap(String text1, String text2) {
        int text1Length = text1.length();
        int text2Length = text2.length();
        if (text1Length == 0 || text2Length == 0) {
            return 0;
        }
        if (text1Length > text2Length) {
            text1 = text1.substring(text1Length - text2Length);
        } else if (text1Length < text2Length) {
            text2 = text2.substring(0, text1Length);
        }
        int textLength = Math.min(text1Length, text2Length);
        if (text1.equals(text2)) {
            return textLength;
        }
        int best = 0;
        int length = 1;
        String pattern;
        int found;
        while ((found = text2.indexOf(pattern = text1.substring(textLength - length))) != -1) {
            if (found != 0 && !text1.substring(textLength - (length += found)).equals(text2.substring(0, length))) continue;
            best = length++;
        }
        return best;
    }

    protected String[] diffHalfMatch(String text1, String text2) {
        String[] hm;
        String shorttext;
        if (this.diffTimeout <= 0.0f) {
            return null;
        }
        String longtext = text1.length() > text2.length() ? text1 : text2;
        String string = shorttext = text1.length() > text2.length() ? text2 : text1;
        if (longtext.length() < 4 || shorttext.length() * 2 < longtext.length()) {
            return null;
        }
        String[] hm1 = this.diffHalfMatchI(longtext, shorttext, (longtext.length() + 3) / 4);
        String[] hm2 = this.diffHalfMatchI(longtext, shorttext, (longtext.length() + 1) / 2);
        if (hm1 == null && hm2 == null) {
            return null;
        }
        if (hm2 == null) {
            hm = hm1;
        } else if (hm1 == null) {
            hm = hm2;
        } else {
            String[] stringArray = hm = hm1[4].length() > hm2[4].length() ? hm1 : hm2;
        }
        if (text1.length() > text2.length()) {
            return hm;
        }
        return new String[]{hm[2], hm[3], hm[0], hm[1], hm[4]};
    }

    private String[] diffHalfMatchI(String longtext, String shorttext, int i) {
        String seed = longtext.substring(i, i + longtext.length() / 4);
        int j = -1;
        String bestCommon = "";
        String bestLongtextA = "";
        String bestLongtextB = "";
        String bestShorttextA = "";
        String bestShorttextB = "";
        while ((j = shorttext.indexOf(seed, j + 1)) != -1) {
            int prefixLength = this.diffCommonPrefix(longtext.substring(i), shorttext.substring(j));
            int suffixLength = this.diffCommonSuffix(longtext.substring(0, i), shorttext.substring(0, j));
            if (bestCommon.length() >= suffixLength + prefixLength) continue;
            bestCommon = shorttext.substring(j - suffixLength, j) + shorttext.substring(j, j + prefixLength);
            bestLongtextA = longtext.substring(0, i - suffixLength);
            bestLongtextB = longtext.substring(i + prefixLength);
            bestShorttextA = shorttext.substring(0, j - suffixLength);
            bestShorttextB = shorttext.substring(j + prefixLength);
        }
        if (bestCommon.length() * 2 >= longtext.length()) {
            return new String[]{bestLongtextA, bestLongtextB, bestShorttextA, bestShorttextB, bestCommon};
        }
        return null;
    }

    public void diffCleanupSemantic(LinkedList<Diff> diffs) {
        if (diffs.isEmpty()) {
            return;
        }
        boolean changes = false;
        ArrayDeque<Diff> equalities = new ArrayDeque<Diff>();
        String lastEquality = null;
        ListIterator<Diff> pointer = diffs.listIterator();
        int lengthInsertions1 = 0;
        int lengthDeletions1 = 0;
        int lengthInsertions2 = 0;
        int lengthDeletions2 = 0;
        Diff thisDiff = (Diff)pointer.next();
        while (thisDiff != null) {
            if (thisDiff.operation == Operation.EQUAL) {
                equalities.push(thisDiff);
                lengthInsertions1 = lengthInsertions2;
                lengthDeletions1 = lengthDeletions2;
                lengthInsertions2 = 0;
                lengthDeletions2 = 0;
                lastEquality = thisDiff.text;
            } else {
                if (thisDiff.operation == Operation.INSERT) {
                    lengthInsertions2 += thisDiff.text.length();
                } else {
                    lengthDeletions2 += thisDiff.text.length();
                }
                if (lastEquality != null && lastEquality.length() <= Math.max(lengthInsertions1, lengthDeletions1) && lastEquality.length() <= Math.max(lengthInsertions2, lengthDeletions2)) {
                    while (thisDiff != equalities.peek()) {
                        thisDiff = (Diff)pointer.previous();
                    }
                    pointer.next();
                    pointer.set(new Diff(Operation.DELETE, lastEquality));
                    pointer.add(new Diff(Operation.INSERT, lastEquality));
                    equalities.pop();
                    if (!equalities.isEmpty()) {
                        equalities.pop();
                    }
                    if (equalities.isEmpty()) {
                        while (pointer.hasPrevious()) {
                            pointer.previous();
                        }
                    } else {
                        thisDiff = (Diff)equalities.peek();
                        while (thisDiff != pointer.previous()) {
                        }
                    }
                    lengthInsertions1 = 0;
                    lengthInsertions2 = 0;
                    lengthDeletions1 = 0;
                    lengthDeletions2 = 0;
                    lastEquality = null;
                    changes = true;
                }
            }
            thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
        if (changes) {
            this.diffCleanupMerge(diffs);
        }
        this.diffCleanupSemanticLossless(diffs);
        pointer = diffs.listIterator();
        Diff prevDiff = null;
        thisDiff = null;
        if (pointer.hasNext()) {
            prevDiff = (Diff)pointer.next();
            if (pointer.hasNext()) {
                thisDiff = (Diff)pointer.next();
            }
        }
        while (thisDiff != null) {
            if (prevDiff.operation == Operation.DELETE && thisDiff.operation == Operation.INSERT) {
                int overlapLength2;
                String deletion = prevDiff.text;
                String insertion = thisDiff.text;
                int overlapLength1 = this.diffCommonOverlap(deletion, insertion);
                if (overlapLength1 >= (overlapLength2 = this.diffCommonOverlap(insertion, deletion))) {
                    if ((double)overlapLength1 >= (double)deletion.length() / 2.0 || (double)overlapLength1 >= (double)insertion.length() / 2.0) {
                        pointer.previous();
                        pointer.add(new Diff(Operation.EQUAL, insertion.substring(0, overlapLength1)));
                        prevDiff.text = deletion.substring(0, deletion.length() - overlapLength1);
                        thisDiff.text = insertion.substring(overlapLength1);
                    }
                } else if ((double)overlapLength2 >= (double)deletion.length() / 2.0 || (double)overlapLength2 >= (double)insertion.length() / 2.0) {
                    pointer.previous();
                    pointer.add(new Diff(Operation.EQUAL, deletion.substring(0, overlapLength2)));
                    prevDiff.operation = Operation.INSERT;
                    prevDiff.text = insertion.substring(0, insertion.length() - overlapLength2);
                    thisDiff.operation = Operation.DELETE;
                    thisDiff.text = deletion.substring(overlapLength2);
                }
                thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
            }
            prevDiff = thisDiff;
            thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
    }

    public void diffCleanupSemanticLossless(LinkedList<Diff> diffs) {
        Diff nextDiff;
        ListIterator pointer = diffs.listIterator();
        Diff prevDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        Diff thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        Diff diff = nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        while (nextDiff != null) {
            if (prevDiff.operation == Operation.EQUAL && nextDiff.operation == Operation.EQUAL) {
                String equality1 = prevDiff.text;
                String edit = thisDiff.text;
                String equality2 = nextDiff.text;
                int commonOffset = this.diffCommonSuffix(equality1, edit);
                if (commonOffset != 0) {
                    String commonString = edit.substring(edit.length() - commonOffset);
                    equality1 = equality1.substring(0, equality1.length() - commonOffset);
                    edit = commonString + edit.substring(0, edit.length() - commonOffset);
                    equality2 = commonString + equality2;
                }
                String bestEquality1 = equality1;
                String bestEdit = edit;
                String bestEquality2 = equality2;
                int bestScore = this.diffCleanupSemanticScore(equality1, edit) + this.diffCleanupSemanticScore(edit, equality2);
                while (edit.length() != 0 && equality2.length() != 0 && edit.charAt(0) == equality2.charAt(0)) {
                    equality1 = equality1 + edit.charAt(0);
                    edit = edit.substring(1) + equality2.charAt(0);
                    equality2 = equality2.substring(1);
                    int score = this.diffCleanupSemanticScore(equality1, edit) + this.diffCleanupSemanticScore(edit, equality2);
                    if (score < bestScore) continue;
                    bestScore = score;
                    bestEquality1 = equality1;
                    bestEdit = edit;
                    bestEquality2 = equality2;
                }
                if (!prevDiff.text.equals(bestEquality1)) {
                    if (bestEquality1.length() != 0) {
                        prevDiff.text = bestEquality1;
                    } else {
                        pointer.previous();
                        pointer.previous();
                        pointer.previous();
                        pointer.remove();
                        pointer.next();
                        pointer.next();
                    }
                    thisDiff.text = bestEdit;
                    if (bestEquality2.length() != 0) {
                        nextDiff.text = bestEquality2;
                    } else {
                        pointer.remove();
                        nextDiff = thisDiff;
                        thisDiff = prevDiff;
                    }
                }
            }
            prevDiff = thisDiff;
            thisDiff = nextDiff;
            nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
    }

    private int diffCleanupSemanticScore(String one, String two) {
        boolean blankLine2;
        if (one.length() == 0 || two.length() == 0) {
            return 6;
        }
        char char1 = one.charAt(one.length() - 1);
        char char2 = two.charAt(0);
        boolean nonAlphaNumeric1 = !Character.isLetterOrDigit(char1);
        boolean nonAlphaNumeric2 = !Character.isLetterOrDigit(char2);
        boolean whitespace1 = nonAlphaNumeric1 && Character.isWhitespace(char1);
        boolean whitespace2 = nonAlphaNumeric2 && Character.isWhitespace(char2);
        boolean lineBreak1 = whitespace1 && Character.getType(char1) == 15;
        boolean lineBreak2 = whitespace2 && Character.getType(char2) == 15;
        boolean blankLine1 = lineBreak1 && this.BLANKLINEEND.matcher(one).find();
        boolean bl = blankLine2 = lineBreak2 && this.BLANKLINESTART.matcher(two).find();
        if (blankLine1 || blankLine2) {
            return 5;
        }
        if (lineBreak1 || lineBreak2) {
            return 4;
        }
        if (nonAlphaNumeric1 && !whitespace1 && whitespace2) {
            return 3;
        }
        if (whitespace1 || whitespace2) {
            return 2;
        }
        if (nonAlphaNumeric1 || nonAlphaNumeric2) {
            return 1;
        }
        return 0;
    }

    public void diffCleanupEfficiency(LinkedList<Diff> diffs) {
        Diff thisDiff;
        if (diffs.isEmpty()) {
            return;
        }
        boolean changes = false;
        ArrayDeque<Diff> equalities = new ArrayDeque<Diff>();
        String lastEquality = null;
        ListIterator<Diff> pointer = diffs.listIterator();
        boolean preIns = false;
        boolean preDel = false;
        boolean postIns = false;
        boolean postDel = false;
        Diff safeDiff = thisDiff = (Diff)pointer.next();
        while (thisDiff != null) {
            if (thisDiff.operation == Operation.EQUAL) {
                if (thisDiff.text.length() < this.diffEditCost && (postIns || postDel)) {
                    equalities.push(thisDiff);
                    preIns = postIns;
                    preDel = postDel;
                    lastEquality = thisDiff.text;
                } else {
                    equalities.clear();
                    lastEquality = null;
                    safeDiff = thisDiff;
                }
                postDel = false;
                postIns = false;
            } else {
                if (thisDiff.operation == Operation.DELETE) {
                    postDel = true;
                } else {
                    postIns = true;
                }
                if (lastEquality != null && (preIns && preDel && postIns && postDel || lastEquality.length() < this.diffEditCost / 2 && (preIns ? 1 : 0) + (preDel ? 1 : 0) + (postIns ? 1 : 0) + (postDel ? 1 : 0) == 3)) {
                    while (thisDiff != equalities.peek()) {
                        thisDiff = (Diff)pointer.previous();
                    }
                    pointer.next();
                    pointer.set(new Diff(Operation.DELETE, lastEquality));
                    thisDiff = new Diff(Operation.INSERT, lastEquality);
                    pointer.add(thisDiff);
                    equalities.pop();
                    lastEquality = null;
                    if (preIns && preDel) {
                        postDel = true;
                        postIns = true;
                        equalities.clear();
                        safeDiff = thisDiff;
                    } else {
                        if (!equalities.isEmpty()) {
                            equalities.pop();
                        }
                        thisDiff = equalities.isEmpty() ? safeDiff : (Diff)equalities.peek();
                        while (thisDiff != pointer.previous()) {
                        }
                        postDel = false;
                        postIns = false;
                    }
                    changes = true;
                }
            }
            thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
        if (changes) {
            this.diffCleanupMerge(diffs);
        }
    }

    public void diffCleanupMerge(LinkedList<Diff> diffs) {
        Diff nextDiff;
        diffs.add(new Diff(Operation.EQUAL, ""));
        ListIterator<Diff> pointer = diffs.listIterator();
        int countDelete = 0;
        int countInsert = 0;
        String textDelete = "";
        String textInsert = "";
        Diff thisDiff = (Diff)pointer.next();
        Diff prevEqual = null;
        while (thisDiff != null) {
            switch (thisDiff.operation) {
                case INSERT: {
                    ++countInsert;
                    textInsert = textInsert + thisDiff.text;
                    prevEqual = null;
                    break;
                }
                case DELETE: {
                    ++countDelete;
                    textDelete = textDelete + thisDiff.text;
                    prevEqual = null;
                    break;
                }
                case EQUAL: {
                    if (countDelete + countInsert > 1) {
                        boolean bothTypes = countDelete != 0 && countInsert != 0;
                        pointer.previous();
                        while (countDelete-- > 0) {
                            pointer.previous();
                            pointer.remove();
                        }
                        while (countInsert-- > 0) {
                            pointer.previous();
                            pointer.remove();
                        }
                        if (bothTypes) {
                            int commonlength = this.diffCommonPrefix(textInsert, textDelete);
                            if (commonlength != 0) {
                                if (pointer.hasPrevious()) {
                                    thisDiff = (Diff)pointer.previous();
                                    assert (thisDiff.operation == Operation.EQUAL) : "Previous diff should have been an equality.";
                                    thisDiff.text = thisDiff.text + textInsert.substring(0, commonlength);
                                    pointer.next();
                                } else {
                                    pointer.add(new Diff(Operation.EQUAL, textInsert.substring(0, commonlength)));
                                }
                                textInsert = textInsert.substring(commonlength);
                                textDelete = textDelete.substring(commonlength);
                            }
                            if ((commonlength = this.diffCommonSuffix(textInsert, textDelete)) != 0) {
                                thisDiff = (Diff)pointer.next();
                                thisDiff.text = textInsert.substring(textInsert.length() - commonlength) + thisDiff.text;
                                textInsert = textInsert.substring(0, textInsert.length() - commonlength);
                                textDelete = textDelete.substring(0, textDelete.length() - commonlength);
                                pointer.previous();
                            }
                        }
                        if (textDelete.length() != 0) {
                            pointer.add(new Diff(Operation.DELETE, textDelete));
                        }
                        if (textInsert.length() != 0) {
                            pointer.add(new Diff(Operation.INSERT, textInsert));
                        }
                        thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
                    } else if (prevEqual != null) {
                        prevEqual.text = prevEqual.text + thisDiff.text;
                        pointer.remove();
                        thisDiff = (Diff)pointer.previous();
                        pointer.next();
                    }
                    countInsert = 0;
                    countDelete = 0;
                    textDelete = "";
                    textInsert = "";
                    prevEqual = thisDiff;
                }
            }
            thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
        if (diffs.getLast().text.length() == 0) {
            diffs.removeLast();
        }
        boolean changes = false;
        pointer = diffs.listIterator();
        Diff prevDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        Diff diff = nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        while (nextDiff != null) {
            if (prevDiff.operation == Operation.EQUAL && nextDiff.operation == Operation.EQUAL) {
                if (thisDiff.text.endsWith(prevDiff.text)) {
                    thisDiff.text = prevDiff.text + thisDiff.text.substring(0, thisDiff.text.length() - prevDiff.text.length());
                    nextDiff.text = prevDiff.text + nextDiff.text;
                    pointer.previous();
                    pointer.previous();
                    pointer.previous();
                    pointer.remove();
                    pointer.next();
                    thisDiff = (Diff)pointer.next();
                    nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
                    changes = true;
                } else if (thisDiff.text.startsWith(nextDiff.text)) {
                    prevDiff.text = prevDiff.text + nextDiff.text;
                    thisDiff.text = thisDiff.text.substring(nextDiff.text.length()) + nextDiff.text;
                    pointer.remove();
                    nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
                    changes = true;
                }
            }
            prevDiff = thisDiff;
            thisDiff = nextDiff;
            nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
        if (changes) {
            this.diffCleanupMerge(diffs);
        }
    }

    public int diffXIndex(List<Diff> diffs, int loc) {
        int chars1 = 0;
        int chars2 = 0;
        int lastChars1 = 0;
        int lastChars2 = 0;
        Diff lastDiff = null;
        for (Diff aDiff : diffs) {
            if (aDiff.operation != Operation.INSERT) {
                chars1 += aDiff.text.length();
            }
            if (aDiff.operation != Operation.DELETE) {
                chars2 += aDiff.text.length();
            }
            if (chars1 > loc) {
                lastDiff = aDiff;
                break;
            }
            lastChars1 = chars1;
            lastChars2 = chars2;
        }
        if (lastDiff != null && lastDiff.operation == Operation.DELETE) {
            return lastChars2;
        }
        return lastChars2 + (loc - lastChars1);
    }

    public String diffPrettyHtml(List<Diff> diffs) {
        StringBuilder html = new StringBuilder();
        for (Diff aDiff : diffs) {
            String text = aDiff.text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\n", "&para;<br>");
            switch (aDiff.operation) {
                case INSERT: {
                    html.append("<ins style=\"background:#e6ffe6;\">").append(text).append("</ins>");
                    break;
                }
                case DELETE: {
                    html.append("<del style=\"background:#ffe6e6;\">").append(text).append("</del>");
                    break;
                }
                case EQUAL: {
                    html.append("<span>").append(text).append("</span>");
                }
            }
        }
        return html.toString();
    }

    public String diffText1(List<Diff> diffs) {
        StringBuilder text = new StringBuilder();
        for (Diff aDiff : diffs) {
            if (aDiff.operation == Operation.INSERT) continue;
            text.append(aDiff.text);
        }
        return text.toString();
    }

    public String diffText2(List<Diff> diffs) {
        StringBuilder text = new StringBuilder();
        for (Diff aDiff : diffs) {
            if (aDiff.operation == Operation.DELETE) continue;
            text.append(aDiff.text);
        }
        return text.toString();
    }

    public int diffLevenshtein(List<Diff> diffs) {
        int levenshtein = 0;
        int insertions = 0;
        int deletions = 0;
        for (Diff aDiff : diffs) {
            switch (aDiff.operation) {
                case INSERT: {
                    insertions += aDiff.text.length();
                    break;
                }
                case DELETE: {
                    deletions += aDiff.text.length();
                    break;
                }
                case EQUAL: {
                    levenshtein += Math.max(insertions, deletions);
                    insertions = 0;
                    deletions = 0;
                }
            }
        }
        return levenshtein += Math.max(insertions, deletions);
    }

    public String diffToDelta(List<Diff> diffs) {
        StringBuilder text = new StringBuilder();
        for (Diff aDiff : diffs) {
            switch (aDiff.operation) {
                case INSERT: {
                    try {
                        text.append("+").append(URLEncoder.encode(aDiff.text, "UTF-8").replace('+', ' ')).append("\t");
                        break;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new Error("This system does not support UTF-8.", e);
                    }
                }
                case DELETE: {
                    text.append("-").append(aDiff.text.length()).append("\t");
                    break;
                }
                case EQUAL: {
                    text.append("=").append(aDiff.text.length()).append("\t");
                }
            }
        }
        String delta = text.toString();
        if (delta.length() != 0) {
            delta = delta.substring(0, delta.length() - 1);
            delta = DiffMatchPatch.unescapeForEncodeUriCompatability(delta);
        }
        return delta;
    }

    public LinkedList<Diff> diffFromDelta(String text1, String delta) throws IllegalArgumentException {
        String[] tokens;
        LinkedList<Diff> diffs = new LinkedList<Diff>();
        int pointer = 0;
        block11: for (String token : tokens = delta.split("\t")) {
            if (token.length() == 0) continue;
            String param = token.substring(1);
            switch (token.charAt(0)) {
                case '+': {
                    param = param.replace("+", "%2B");
                    try {
                        param = URLDecoder.decode(param, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new Error("This system does not support UTF-8.", e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException("Illegal escape in diffFromDelta: " + param, e);
                    }
                    diffs.add(new Diff(Operation.INSERT, param));
                    continue block11;
                }
                case '-': 
                case '=': {
                    String text;
                    int n;
                    try {
                        n = Integer.parseInt(param);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Invalid number in diffFromDelta: " + param, e);
                    }
                    if (n < 0) {
                        throw new IllegalArgumentException("Negative number in diffFromDelta: " + param);
                    }
                    try {
                        text = text1.substring(pointer, pointer += n);
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        throw new IllegalArgumentException("Delta length (" + pointer + ") larger than source text length (" + text1.length() + ").", e);
                    }
                    if (token.charAt(0) == '=') {
                        diffs.add(new Diff(Operation.EQUAL, text));
                        continue block11;
                    }
                    diffs.add(new Diff(Operation.DELETE, text));
                    continue block11;
                }
                default: {
                    throw new IllegalArgumentException("Invalid diff operation in diffFromDelta: " + token.charAt(0));
                }
            }
        }
        if (pointer != text1.length()) {
            throw new IllegalArgumentException("Delta length (" + pointer + ") smaller than source text length (" + text1.length() + ").");
        }
        return diffs;
    }

    public int matchMain(String text, String pattern, int loc) {
        if (text == null || pattern == null) {
            throw new IllegalArgumentException("Null inputs. (matchMain)");
        }
        loc = Math.max(0, Math.min(loc, text.length()));
        if (text.equals(pattern)) {
            return 0;
        }
        if (text.length() == 0) {
            return -1;
        }
        if (loc + pattern.length() <= text.length() && text.substring(loc, loc + pattern.length()).equals(pattern)) {
            return loc;
        }
        return this.matchBitap(text, pattern, loc);
    }

    int matchBitap(String text, String pattern, int loc) {
        assert (pattern.length() <= 32) : "Pattern too long for this application.";
        Map<Character, Integer> s = this.matchAlphabet(pattern);
        double scoreThreshold = this.matchThreshold;
        int bestLoc = text.indexOf(pattern, loc);
        if (bestLoc != -1) {
            scoreThreshold = Math.min(this.matchBitapScore(0, bestLoc, loc, pattern), scoreThreshold);
            bestLoc = text.lastIndexOf(pattern, loc + pattern.length());
            if (bestLoc != -1) {
                scoreThreshold = Math.min(this.matchBitapScore(0, bestLoc, loc, pattern), scoreThreshold);
            }
        }
        int matchmask = 1 << pattern.length() - 1;
        bestLoc = -1;
        int binMax = pattern.length() + text.length();
        int[] lastRd = new int[]{};
        for (int d = 0; d < pattern.length(); ++d) {
            int binMin = 0;
            int binMid = binMax;
            while (binMin < binMid) {
                if (this.matchBitapScore(d, loc + binMid, loc, pattern) <= scoreThreshold) {
                    binMin = binMid;
                } else {
                    binMax = binMid;
                }
                binMid = (binMax - binMin) / 2 + binMin;
            }
            binMax = binMid;
            int start = Math.max(1, loc - binMid + 1);
            int finish = Math.min(loc + binMid, text.length()) + pattern.length();
            int[] rd = new int[finish + 2];
            rd[finish + 1] = (1 << d) - 1;
            for (int j = finish; j >= start; --j) {
                double score;
                int charMatch = text.length() <= j - 1 || !s.containsKey(Character.valueOf(text.charAt(j - 1))) ? 0 : s.get(Character.valueOf(text.charAt(j - 1)));
                rd[j] = d == 0 ? (rd[j + 1] << 1 | 1) & charMatch : (rd[j + 1] << 1 | 1) & charMatch | ((lastRd[j + 1] | lastRd[j]) << 1 | 1) | lastRd[j + 1];
                if ((rd[j] & matchmask) == 0 || !((score = this.matchBitapScore(d, j - 1, loc, pattern)) <= scoreThreshold)) continue;
                scoreThreshold = score;
                bestLoc = j - 1;
                if (bestLoc <= loc) break;
                start = Math.max(1, 2 * loc - bestLoc);
            }
            if (this.matchBitapScore(d + 1, loc, loc, pattern) > scoreThreshold) break;
            lastRd = rd;
        }
        return bestLoc;
    }

    private double matchBitapScore(int e, int x, int loc, String pattern) {
        float accuracy = (float)e / (float)pattern.length();
        int proximity = Math.abs(loc - x);
        if (this.matchDistance == 0) {
            return proximity == 0 ? (double)accuracy : 1.0;
        }
        return accuracy + (float)proximity / (float)this.matchDistance;
    }

    Map<Character, Integer> matchAlphabet(String pattern) {
        char[] charPattern;
        HashMap<Character, Integer> s = new HashMap<Character, Integer>();
        for (char c : charPattern = pattern.toCharArray()) {
            s.put(Character.valueOf(c), 0);
        }
        int i = 0;
        for (char c : charPattern) {
            s.put(Character.valueOf(c), (Integer)s.get(Character.valueOf(c)) | 1 << pattern.length() - i - 1);
            ++i;
        }
        return s;
    }

    protected void patchAddContext(Patch patch, String text) {
        String suffix;
        if (text.length() == 0) {
            return;
        }
        String pattern = text.substring(patch.start2, patch.start2 + patch.length1);
        int padding = 0;
        while (text.indexOf(pattern) != text.lastIndexOf(pattern) && pattern.length() < 32 - this.patchMargin - this.patchMargin) {
            pattern = text.substring(Math.max(0, patch.start2 - (padding += this.patchMargin)), Math.min(text.length(), patch.start2 + patch.length1 + padding));
        }
        String prefix = text.substring(Math.max(0, patch.start2 - (padding += this.patchMargin)), patch.start2);
        if (prefix.length() != 0) {
            patch.diffs.addFirst(new Diff(Operation.EQUAL, prefix));
        }
        if ((suffix = text.substring(patch.start2 + patch.length1, Math.min(text.length(), patch.start2 + patch.length1 + padding))).length() != 0) {
            patch.diffs.addLast(new Diff(Operation.EQUAL, suffix));
        }
        patch.start1 -= prefix.length();
        patch.start2 -= prefix.length();
        patch.length1 += prefix.length() + suffix.length();
        patch.length2 += prefix.length() + suffix.length();
    }

    public LinkedList<Patch> patchMake(String text1, String text2) {
        if (text1 == null || text2 == null) {
            throw new IllegalArgumentException("Null inputs. (patchMake)");
        }
        LinkedList<Diff> diffs = this.diffMain(text1, text2, true);
        if (diffs.size() > 2) {
            this.diffCleanupSemantic(diffs);
            this.diffCleanupEfficiency(diffs);
        }
        return this.patchMake(text1, diffs);
    }

    public LinkedList<Patch> patchMake(LinkedList<Diff> diffs) {
        if (diffs == null) {
            throw new IllegalArgumentException("Null inputs. (patchMake)");
        }
        String text1 = this.diffText1(diffs);
        return this.patchMake(text1, diffs);
    }

    @Deprecated
    public LinkedList<Patch> patchMake(String text1, String text2, LinkedList<Diff> diffs) {
        return this.patchMake(text1, diffs);
    }

    public LinkedList<Patch> patchMake(String text1, LinkedList<Diff> diffs) {
        if (text1 == null || diffs == null) {
            throw new IllegalArgumentException("Null inputs. (patchMake)");
        }
        LinkedList<Patch> patches = new LinkedList<Patch>();
        if (diffs.isEmpty()) {
            return patches;
        }
        Patch patch = new Patch();
        int charCount1 = 0;
        int charCount2 = 0;
        String prepatchText = text1;
        String postpatchText = text1;
        for (Diff aDiff : diffs) {
            if (patch.diffs.isEmpty() && aDiff.operation != Operation.EQUAL) {
                patch.start1 = charCount1;
                patch.start2 = charCount2;
            }
            switch (aDiff.operation) {
                case INSERT: {
                    patch.diffs.add(aDiff);
                    patch.length2 += aDiff.text.length();
                    postpatchText = postpatchText.substring(0, charCount2) + aDiff.text + postpatchText.substring(charCount2);
                    break;
                }
                case DELETE: {
                    patch.length1 += aDiff.text.length();
                    patch.diffs.add(aDiff);
                    postpatchText = postpatchText.substring(0, charCount2) + postpatchText.substring(charCount2 + aDiff.text.length());
                    break;
                }
                case EQUAL: {
                    if (aDiff.text.length() <= 2 * this.patchMargin && !patch.diffs.isEmpty() && aDiff != diffs.getLast()) {
                        patch.diffs.add(aDiff);
                        patch.length1 += aDiff.text.length();
                        patch.length2 += aDiff.text.length();
                    }
                    if (aDiff.text.length() < 2 * this.patchMargin || patch.diffs.isEmpty() || patch.diffs.isEmpty()) break;
                    this.patchAddContext(patch, prepatchText);
                    patches.add(patch);
                    patch = new Patch();
                    prepatchText = postpatchText;
                    charCount1 = charCount2;
                }
            }
            if (aDiff.operation != Operation.INSERT) {
                charCount1 += aDiff.text.length();
            }
            if (aDiff.operation == Operation.DELETE) continue;
            charCount2 += aDiff.text.length();
        }
        if (!patch.diffs.isEmpty()) {
            this.patchAddContext(patch, prepatchText);
            patches.add(patch);
        }
        return patches;
    }

    public LinkedList<Patch> patchDeepCopy(LinkedList<Patch> patches) {
        LinkedList<Patch> patchesCopy = new LinkedList<Patch>();
        for (Patch aPatch : patches) {
            Patch patchCopy = new Patch();
            for (Diff aDiff : aPatch.diffs) {
                Diff diffCopy = new Diff(aDiff.operation, aDiff.text);
                patchCopy.diffs.add(diffCopy);
            }
            patchCopy.start1 = aPatch.start1;
            patchCopy.start2 = aPatch.start2;
            patchCopy.length1 = aPatch.length1;
            patchCopy.length2 = aPatch.length2;
            patchesCopy.add(patchCopy);
        }
        return patchesCopy;
    }

    public Object[] patchApply(LinkedList<Patch> patches, String text) {
        if (patches.isEmpty()) {
            return new Object[]{text, new boolean[0]};
        }
        patches = this.patchDeepCopy(patches);
        String nullPadding = this.patchAddPadding(patches);
        text = nullPadding + text + nullPadding;
        this.patchSplitMax(patches);
        int x = 0;
        int delta = 0;
        boolean[] results = new boolean[patches.size()];
        for (Patch aPatch : patches) {
            int startLoc;
            int expectedLoc = aPatch.start2 + delta;
            String text1 = this.diffText1(aPatch.diffs);
            int endLoc = -1;
            if (text1.length() > 32) {
                startLoc = this.matchMain(text, text1.substring(0, 32), expectedLoc);
                if (startLoc != -1 && ((endLoc = this.matchMain(text, text1.substring(text1.length() - 32), expectedLoc + text1.length() - 32)) == -1 || startLoc >= endLoc)) {
                    startLoc = -1;
                }
            } else {
                startLoc = this.matchMain(text, text1, expectedLoc);
            }
            if (startLoc == -1) {
                results[x] = false;
                delta -= aPatch.length2 - aPatch.length1;
            } else {
                results[x] = true;
                delta = startLoc - expectedLoc;
                String text2 = endLoc == -1 ? text.substring(startLoc, Math.min(startLoc + text1.length(), text.length())) : text.substring(startLoc, Math.min(endLoc + 32, text.length()));
                if (text1.equals(text2)) {
                    text = text.substring(0, startLoc) + this.diffText2(aPatch.diffs) + text.substring(startLoc + text1.length());
                } else {
                    LinkedList<Diff> diffs = this.diffMain(text1, text2, false);
                    if (text1.length() > 32 && (float)this.diffLevenshtein(diffs) / (float)text1.length() > this.patchDeleteThreshold) {
                        results[x] = false;
                    } else {
                        this.diffCleanupSemanticLossless(diffs);
                        int index1 = 0;
                        for (Diff aDiff : aPatch.diffs) {
                            if (aDiff.operation != Operation.EQUAL) {
                                int index2 = this.diffXIndex(diffs, index1);
                                if (aDiff.operation == Operation.INSERT) {
                                    text = text.substring(0, startLoc + index2) + aDiff.text + text.substring(startLoc + index2);
                                } else if (aDiff.operation == Operation.DELETE) {
                                    text = text.substring(0, startLoc + index2) + text.substring(startLoc + this.diffXIndex(diffs, index1 + aDiff.text.length()));
                                }
                            }
                            if (aDiff.operation == Operation.DELETE) continue;
                            index1 += aDiff.text.length();
                        }
                    }
                }
            }
            ++x;
        }
        text = text.substring(nullPadding.length(), text.length() - nullPadding.length());
        return new Object[]{text, results};
    }

    String patchAddPadding(LinkedList<Patch> patches) {
        int extraLength;
        short paddingLength = this.patchMargin;
        String nullPadding = "";
        for (short x = 1; x <= paddingLength; x = (short)(x + 1)) {
            nullPadding = nullPadding + String.valueOf((char)x);
        }
        for (Patch aPatch : patches) {
            aPatch.start1 += paddingLength;
            aPatch.start2 += paddingLength;
        }
        Patch patch = patches.getFirst();
        LinkedList<Diff> diffs = patch.diffs;
        if (diffs.isEmpty() || diffs.getFirst().operation != Operation.EQUAL) {
            diffs.addFirst(new Diff(Operation.EQUAL, nullPadding));
            patch.start1 -= paddingLength;
            patch.start2 -= paddingLength;
            patch.length1 += paddingLength;
            patch.length2 += paddingLength;
        } else if (paddingLength > diffs.getFirst().text.length()) {
            Diff firstDiff = diffs.getFirst();
            extraLength = paddingLength - firstDiff.text.length();
            firstDiff.text = nullPadding.substring(firstDiff.text.length()) + firstDiff.text;
            patch.start1 -= extraLength;
            patch.start2 -= extraLength;
            patch.length1 += extraLength;
            patch.length2 += extraLength;
        }
        patch = patches.getLast();
        diffs = patch.diffs;
        if (diffs.isEmpty() || diffs.getLast().operation != Operation.EQUAL) {
            diffs.addLast(new Diff(Operation.EQUAL, nullPadding));
            patch.length1 += paddingLength;
            patch.length2 += paddingLength;
        } else if (paddingLength > diffs.getLast().text.length()) {
            Diff lastDiff = diffs.getLast();
            extraLength = paddingLength - lastDiff.text.length();
            lastDiff.text = lastDiff.text + nullPadding.substring(0, extraLength);
            patch.length1 += extraLength;
            patch.length2 += extraLength;
        }
        return nullPadding;
    }

    void patchSplitMax(LinkedList<Patch> patches) {
        Patch bigpatch;
        int patchSize = 32;
        ListIterator<Patch> pointer = patches.listIterator();
        Patch patch = bigpatch = pointer.hasNext() ? (Patch)pointer.next() : null;
        while (bigpatch != null) {
            if (bigpatch.length1 <= 32) {
                bigpatch = pointer.hasNext() ? (Patch)pointer.next() : null;
                continue;
            }
            pointer.remove();
            int start1 = bigpatch.start1;
            int start2 = bigpatch.start2;
            String precontext = "";
            while (!bigpatch.diffs.isEmpty()) {
                Patch patch2 = new Patch();
                boolean empty = true;
                patch2.start1 = start1 - precontext.length();
                patch2.start2 = start2 - precontext.length();
                if (precontext.length() != 0) {
                    patch2.length1 = patch2.length2 = precontext.length();
                    patch2.diffs.add(new Diff(Operation.EQUAL, precontext));
                }
                while (!bigpatch.diffs.isEmpty() && patch2.length1 < patchSize - this.patchMargin) {
                    Operation diffType = bigpatch.diffs.getFirst().operation;
                    String diffText = bigpatch.diffs.getFirst().text;
                    if (diffType == Operation.INSERT) {
                        patch2.length2 += diffText.length();
                        start2 += diffText.length();
                        patch2.diffs.addLast(bigpatch.diffs.removeFirst());
                        empty = false;
                        continue;
                    }
                    if (diffType == Operation.DELETE && patch2.diffs.size() == 1 && patch2.diffs.getFirst().operation == Operation.EQUAL && diffText.length() > 2 * patchSize) {
                        patch2.length1 += diffText.length();
                        start1 += diffText.length();
                        empty = false;
                        patch2.diffs.add(new Diff(diffType, diffText));
                        bigpatch.diffs.removeFirst();
                        continue;
                    }
                    diffText = diffText.substring(0, Math.min(diffText.length(), patchSize - patch2.length1 - this.patchMargin));
                    patch2.length1 += diffText.length();
                    start1 += diffText.length();
                    if (diffType == Operation.EQUAL) {
                        patch2.length2 += diffText.length();
                        start2 += diffText.length();
                    } else {
                        empty = false;
                    }
                    patch2.diffs.add(new Diff(diffType, diffText));
                    if (diffText.equals(bigpatch.diffs.getFirst().text)) {
                        bigpatch.diffs.removeFirst();
                        continue;
                    }
                    bigpatch.diffs.getFirst().text = bigpatch.diffs.getFirst().text.substring(diffText.length());
                }
                precontext = this.diffText2(patch2.diffs);
                precontext = precontext.substring(Math.max(0, precontext.length() - this.patchMargin));
                String postcontext = this.diffText1(bigpatch.diffs).length() > this.patchMargin ? this.diffText1(bigpatch.diffs).substring(0, this.patchMargin) : this.diffText1(bigpatch.diffs);
                if (postcontext.length() != 0) {
                    patch2.length1 += postcontext.length();
                    patch2.length2 += postcontext.length();
                    if (!patch2.diffs.isEmpty() && patch2.diffs.getLast().operation == Operation.EQUAL) {
                        patch2.diffs.getLast().text = patch2.diffs.getLast().text + postcontext;
                    } else {
                        patch2.diffs.add(new Diff(Operation.EQUAL, postcontext));
                    }
                }
                if (empty) continue;
                pointer.add(patch2);
            }
            bigpatch = pointer.hasNext() ? (Patch)pointer.next() : null;
        }
    }

    public String patchToText(List<Patch> patches) {
        StringBuilder text = new StringBuilder();
        for (Patch aPatch : patches) {
            text.append(aPatch);
        }
        return text.toString();
    }

    public List<Patch> patchFromText(String textline) throws IllegalArgumentException {
        LinkedList<Patch> patches = new LinkedList<Patch>();
        if (textline.length() == 0) {
            return patches;
        }
        List<String> textList = Arrays.asList(textline.split("\n"));
        LinkedList<String> text = new LinkedList<String>(textList);
        Pattern patchHeader = Pattern.compile("^@@ -(\\d+),?(\\d*) \\+(\\d+),?(\\d*) @@$");
        block5: while (!text.isEmpty()) {
            Matcher m = patchHeader.matcher(text.getFirst());
            if (!m.matches()) {
                throw new IllegalArgumentException("Invalid patch string: " + text.getFirst());
            }
            Patch patch = new Patch();
            patches.add(patch);
            patch.start1 = Integer.parseInt(m.group(1));
            if (m.group(2).length() == 0) {
                --patch.start1;
                patch.length1 = 1;
            } else if (m.group(2).equals("0")) {
                patch.length1 = 0;
            } else {
                --patch.start1;
                patch.length1 = Integer.parseInt(m.group(2));
            }
            patch.start2 = Integer.parseInt(m.group(3));
            if (m.group(4).length() == 0) {
                --patch.start2;
                patch.length2 = 1;
            } else if (m.group(4).equals("0")) {
                patch.length2 = 0;
            } else {
                --patch.start2;
                patch.length2 = Integer.parseInt(m.group(4));
            }
            text.removeFirst();
            while (!text.isEmpty()) {
                char sign;
                try {
                    sign = text.getFirst().charAt(0);
                }
                catch (IndexOutOfBoundsException e) {
                    text.removeFirst();
                    continue;
                }
                String line = text.getFirst().substring(1);
                line = line.replace("+", "%2B");
                try {
                    line = URLDecoder.decode(line, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new Error("This system does not support UTF-8.", e);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Illegal escape in patchFromText: " + line, e);
                }
                if (sign == '-') {
                    patch.diffs.add(new Diff(Operation.DELETE, line));
                } else if (sign == '+') {
                    patch.diffs.add(new Diff(Operation.INSERT, line));
                } else if (sign == ' ') {
                    patch.diffs.add(new Diff(Operation.EQUAL, line));
                } else {
                    if (sign == '@') continue block5;
                    throw new IllegalArgumentException("Invalid patch mode '" + sign + "' in: " + line);
                }
                text.removeFirst();
            }
        }
        return patches;
    }

    private static String unescapeForEncodeUriCompatability(String str) {
        return str.replace("%21", "!").replace("%7E", "~").replace("%27", "'").replace("%28", "(").replace("%29", ")").replace("%3B", ";").replace("%2F", "/").replace("%3F", "?").replace("%3A", ":").replace("%40", "@").replace("%26", "&").replace("%3D", "=").replace("%2B", "+").replace("%24", "$").replace("%2C", ",").replace("%23", "#");
    }

    public static class Patch {
        public LinkedList<Diff> diffs = new LinkedList();
        public int start1;
        public int start2;
        public int length1;
        public int length2;

        public String toString() {
            String coords1 = this.length1 == 0 ? this.start1 + ",0" : (this.length1 == 1 ? Integer.toString(this.start1 + 1) : this.start1 + 1 + "," + this.length1);
            String coords2 = this.length2 == 0 ? this.start2 + ",0" : (this.length2 == 1 ? Integer.toString(this.start2 + 1) : this.start2 + 1 + "," + this.length2);
            StringBuilder text = new StringBuilder();
            text.append("@@ -").append(coords1).append(" +").append(coords2).append(" @@\n");
            for (Diff aDiff : this.diffs) {
                switch (aDiff.operation) {
                    case INSERT: {
                        text.append('+');
                        break;
                    }
                    case DELETE: {
                        text.append('-');
                        break;
                    }
                    case EQUAL: {
                        text.append(' ');
                    }
                }
                try {
                    text.append(URLEncoder.encode(aDiff.text, "UTF-8").replace('+', ' ')).append("\n");
                }
                catch (UnsupportedEncodingException e) {
                    throw new Error("This system does not support UTF-8.", e);
                }
            }
            return DiffMatchPatch.unescapeForEncodeUriCompatability(text.toString());
        }
    }

    public static class Diff {
        public Operation operation;
        public String text;

        public Diff(Operation operation, String text) {
            this.operation = operation;
            this.text = text;
        }

        public String toString() {
            String prettyText = this.text.replace('\n', '\u00b6');
            return "Diff(" + (Object)((Object)this.operation) + ",\"" + prettyText + "\")";
        }

        public int hashCode() {
            int prime = 31;
            int result = this.operation == null ? 0 : this.operation.hashCode();
            return result += 31 * (this.text == null ? 0 : this.text.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Diff other = (Diff)obj;
            if (this.operation != other.operation) {
                return false;
            }
            return !(this.text == null ? other.text != null : !this.text.equals(other.text));
        }
    }

    public static enum Operation {
        DELETE,
        INSERT,
        EQUAL;

    }

    static class LinesToCharsResult {
        protected String chars1;
        protected String chars2;
        protected List<String> lineArray;

        protected LinesToCharsResult(String chars1, String chars2, List<String> lineArray) {
            this.chars1 = chars1;
            this.chars2 = chars2;
            this.lineArray = lineArray;
        }
    }
}

