/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.set;

import bak.pcj.ShortCollection;
import bak.pcj.ShortIterator;
import bak.pcj.set.AbstractShortSet;
import bak.pcj.set.ShortRange;
import bak.pcj.set.ShortSortedSet;
import bak.pcj.util.Exceptions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.NoSuchElementException;

public class ShortRangeSet
extends AbstractShortSet
implements ShortSortedSet,
Cloneable,
Serializable {
    private ArrayList ranges = new ArrayList();
    private int size = 0;

    public ShortRangeSet() {
    }

    public ShortRangeSet(short[] a) {
        this();
        this.addAll(a);
    }

    public ShortRangeSet(ShortCollection c) {
        this();
        this.addAll(c);
    }

    private ShortRange range(int index) {
        return (ShortRange)this.ranges.get(index);
    }

    private ShortRange getRangeOf(short v) {
        int index = this.getRangeIndexOf(v);
        return index >= 0 ? this.range(index) : null;
    }

    private int getRangeIndexOf(short v) {
        if (this.size == 0) {
            return -1;
        }
        int lo = 0;
        int hi = this.ranges.size() - 1;
        while (lo <= hi) {
            int mid = (lo + hi) / 2;
            ShortRange r = (ShortRange)this.ranges.get(mid);
            if (r.contains(v)) {
                return mid;
            }
            if (v < r.first()) {
                hi = mid - 1;
                continue;
            }
            lo = mid + 1;
        }
        return -(lo + 1);
    }

    private int insertRange(ShortRange range) {
        int lo = 0;
        int hi = this.ranges.size() - 1;
        while (lo <= hi) {
            int mid = (lo + hi) / 2;
            ShortRange r = this.range(mid);
            int compare = range.compareTo(r);
            if (compare == 0) {
                return -1;
            }
            if (compare < 0) {
                hi = mid - 1;
                continue;
            }
            lo = mid + 1;
        }
        this.ranges.add(lo, range);
        return lo;
    }

    private void normalize(int index) {
        while (index < this.ranges.size() - 1) {
            ShortRange r2;
            ShortRange r1 = this.range(index);
            ShortRange r3 = r1.tryMergeWith(r2 = this.range(index + 1));
            if (r3 == null) break;
            this.ranges.set(index, r3);
            this.ranges.remove(index + 1);
            this.size -= r1.intersectionLength(r2);
        }
    }

    private void normalize() {
        ShortRange r3;
        int index = 0;
        this.size = 0;
        while (index < this.ranges.size() - 1) {
            ShortRange r2;
            ShortRange r1 = this.range(index);
            r3 = r1.tryMergeWith(r2 = this.range(index + 1));
            if (r3 != null) {
                this.ranges.set(index, r3);
                this.ranges.remove(index + 1);
                continue;
            }
            this.size += r1.length();
            ++index;
        }
        r3 = this.range(this.ranges.size() - 1);
        this.size += r3.length();
    }

    public boolean add(short v) {
        int index = this.getRangeIndexOf(v);
        if (index >= 0) {
            return false;
        }
        int insertionIndex = -index - 1;
        this.ranges.add(insertionIndex, new ShortRange(v, v));
        if (insertionIndex > 0) {
            --insertionIndex;
        }
        ++this.size;
        this.normalize(insertionIndex);
        return true;
    }

    public ShortIterator iterator() {
        return new ShortIterator(){
            int nextIndex = 0;
            int lastIndex = -1;
            int currRange = 0;
            int currOffset = 0;
            short lastValue;

            public boolean hasNext() {
                return this.nextIndex < ShortRangeSet.this.size;
            }

            public short next() {
                if (this.nextIndex >= ShortRangeSet.this.size) {
                    Exceptions.endOfIterator();
                }
                this.lastIndex = this.nextIndex++;
                this.lastValue = this.curr();
                if (this.nextIndex < ShortRangeSet.this.size) {
                    if (this.currOffset == ShortRangeSet.this.range(this.currRange).length() - 1) {
                        ++this.currRange;
                        this.currOffset = 0;
                    } else {
                        ++this.currOffset;
                    }
                }
                return this.lastValue;
            }

            public void remove() {
                if (this.lastIndex == -1) {
                    Exceptions.noElementToRemove();
                }
                ShortRangeSet.this.remove(this.lastValue);
                --this.nextIndex;
                if (this.nextIndex < ShortRangeSet.this.size) {
                    this.recalc();
                }
                this.lastIndex = -1;
            }

            private short curr() {
                return (short)(ShortRangeSet.this.range(this.currRange).first() + this.currOffset);
            }

            private void recalc() {
                int rs;
                this.currRange = 0;
                this.currOffset = this.nextIndex;
                while (this.currOffset >= (rs = ShortRangeSet.this.range(this.currRange).length())) {
                    this.currOffset -= rs;
                    ++this.currRange;
                }
            }
        };
    }

    public short first() {
        if (this.size == 0) {
            Exceptions.setNoFirst();
        }
        return this.range(0).first();
    }

    private short firstFrom(short v) {
        int index = this.getRangeIndexOf(v);
        if (index >= 0) {
            return v;
        }
        if ((index = -index - 1) >= this.ranges.size()) {
            Exceptions.setNoFirst();
        }
        return this.range(index).first();
    }

    public short last() {
        if (this.size == 0) {
            Exceptions.setNoLast();
        }
        return this.range(this.ranges.size() - 1).last();
    }

    private short lastFrom(short v) {
        int index = this.getRangeIndexOf(v);
        if (index >= 0) {
            return v;
        }
        index = -index - 1;
        if (--index < 0 || index >= this.ranges.size()) {
            Exceptions.setNoLast();
        }
        return this.range(index).last();
    }

    public ShortSortedSet headSet(short to) {
        return new SubSet(false, 0, true, to);
    }

    public ShortSortedSet tailSet(short from) {
        return new SubSet(true, from, false, 0);
    }

    public ShortSortedSet subSet(short from, short to) {
        return new SubSet(true, from, true, to);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        int i = 0;
        int rsize = this.ranges.size();
        while (i < rsize) {
            if (i > 0) {
                s.append(',');
            }
            s.append(this.range(i));
            ++i;
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public Object clone() {
        try {
            ShortRangeSet c = (ShortRangeSet)super.clone();
            c.ranges = (ArrayList)this.ranges.clone();
            return c;
        }
        catch (CloneNotSupportedException e) {
            Exceptions.cloning();
            throw new RuntimeException();
        }
    }

    public void clear() {
        this.ranges.clear();
        this.size = 0;
    }

    public boolean contains(short v) {
        return this.getRangeIndexOf(v) >= 0;
    }

    public int hashCode() {
        int h = 0;
        int i = 0;
        boolean index = false;
        int rsize = this.ranges.size();
        while (i < rsize) {
            ShortRange r = this.range(i);
            short c = r.first();
            short last = r.last();
            while (c <= last) {
                h += c;
                c = (short)(c + 1);
            }
            ++i;
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public boolean remove(short v) {
        int index = this.getRangeIndexOf(v);
        if (index < 0) {
            return false;
        }
        ShortRange r = this.range(index);
        if (v == r.first()) {
            if (r.length() == 1) {
                this.ranges.remove(index);
            } else {
                this.ranges.set(index, new ShortRange((short)(r.first() + 1), r.last()));
            }
        } else if (v == r.last()) {
            this.ranges.set(index, new ShortRange(r.first(), (short)(r.last() - 1)));
        } else {
            ShortRange r1 = new ShortRange(r.first(), (short)(v - 1));
            ShortRange r2 = new ShortRange((short)(v + 1), r.last());
            this.ranges.set(index, r1);
            this.ranges.add(index + 1, r2);
        }
        --this.size;
        return true;
    }

    public short[] toArray(short[] a) {
        if (a == null || a.length < this.size) {
            a = new short[this.size];
        }
        int i = 0;
        int index = 0;
        int rsize = this.ranges.size();
        while (i < rsize) {
            ShortRange r = this.range(i);
            short c = r.first();
            short last = r.last();
            while (c <= last) {
                a[index++] = c;
                c = (short)(c + 1);
            }
            ++i;
        }
        return a;
    }

    public boolean containsAll(ShortRange range) {
        ShortRange r = this.getRangeOf(range.first());
        return r != null ? r.contains(range.last()) : false;
    }

    public boolean addAll(ShortRangeSet c) {
        int oldSize = this.size;
        int i = 0;
        int rsize = c.ranges.size();
        while (i < rsize) {
            this.addAll(c.range(i));
            ++i;
        }
        return this.size != oldSize;
    }

    public boolean addAll(ShortRange range) {
        int oldSize = this.size;
        int index = this.insertRange(range);
        if (index != -1) {
            int nindex = index;
            if (nindex > 0) {
                --nindex;
            }
            this.size += range.length();
            this.normalize(nindex);
        }
        return this.size != oldSize;
    }

    public boolean addAll(short first, short last) {
        return this.addAll(new ShortRange(first, last));
    }

    public boolean addAll(short[] a) {
        short[] sa;
        if (a.length == 0) {
            return false;
        }
        int oldSize = this.size;
        if (!this.isSorted(a)) {
            sa = (short[])a.clone();
            Arrays.sort(sa);
        } else {
            sa = a;
        }
        int index = 0;
        while (index < sa.length) {
            short c0 = sa[index];
            index = this.range(sa, index);
            short c1 = sa[index];
            this.ranges.add(new ShortRange(c0, c1));
            ++index;
        }
        Collections.sort(this.ranges);
        this.normalize();
        return this.size != oldSize;
    }

    private int range(short[] a, int index) {
        short c0 = a[index++];
        while (index < a.length && a[index] == c0) {
            ++index;
        }
        while (index < a.length && a[index] == (short)(c0 + 1)) {
            c0 = a[index++];
            while (index < a.length && a[index] == c0) {
                ++index;
            }
        }
        return index - 1;
    }

    private boolean isSorted(short[] a) {
        int i = 1;
        while (i < a.length) {
            if (a[i] < a[i - 1]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public ShortRange[] ranges() {
        ShortRange[] a = new ShortRange[this.ranges.size()];
        this.ranges.toArray(a);
        return a;
    }

    private class SubSet
    extends AbstractShortSet
    implements ShortSortedSet,
    Serializable {
        private boolean hasLowerBound;
        private boolean hasUpperBound;
        private short lowerBound;
        private short upperBound;

        SubSet(boolean hasLowerBound, short lowerBound, boolean hasUpperBound, short upperBound) {
            if (hasLowerBound) {
                if (lowerBound < 0) {
                    Exceptions.negativeArgument("lower bound", String.valueOf(lowerBound));
                }
                if (hasUpperBound && upperBound < lowerBound) {
                    Exceptions.invalidSetBounds(String.valueOf(lowerBound), String.valueOf(upperBound));
                }
            }
            this.hasLowerBound = hasLowerBound;
            this.lowerBound = lowerBound;
            this.hasUpperBound = hasUpperBound;
            this.upperBound = upperBound;
        }

        public boolean add(short v) {
            if (!this.inSubRange(v)) {
                Exceptions.valueNotInSubRange(String.valueOf(v));
            }
            return ShortRangeSet.this.add(v);
        }

        public boolean remove(short v) {
            if (!this.inSubRange(v)) {
                Exceptions.valueNotInSubRange(String.valueOf(v));
            }
            return ShortRangeSet.this.remove(v);
        }

        public boolean contains(short v) {
            return this.inSubRange(v) && ShortRangeSet.this.contains(v);
        }

        public ShortIterator iterator() {
            short first;
            try {
                first = this.first();
            }
            catch (NoSuchElementException e) {
                return new EmptySubSetIterator();
            }
            short last = this.last();
            int rangeIndexLow = ShortRangeSet.this.getRangeIndexOf(first);
            int rangeIndexHigh = ShortRangeSet.this.getRangeIndexOf(last);
            if (rangeIndexLow == rangeIndexHigh) {
                return new SimpleSubSetIterator(first, last);
            }
            return new NonEmptySubSetIterator(first, last, rangeIndexLow, rangeIndexHigh);
        }

        public int size() {
            int size;
            int rangeIndexLow;
            short first;
            if (ShortRangeSet.this.size() == 0) {
                return 0;
            }
            try {
                first = this.first();
                rangeIndexLow = ShortRangeSet.this.getRangeIndexOf(first);
            }
            catch (NoSuchElementException e) {
                return 0;
            }
            short last = this.last();
            int rangeIndexHigh = ShortRangeSet.this.getRangeIndexOf(last);
            if (rangeIndexLow == rangeIndexHigh) {
                size = last - first + 1;
            } else {
                ShortRange rangeLow = ShortRangeSet.this.range(rangeIndexLow);
                ShortRange rangeHigh = ShortRangeSet.this.range(rangeIndexHigh);
                int sizeLow = rangeLow.last() - first + 1;
                int sizeHigh = last - rangeHigh.first() + 1;
                size = sizeLow + sizeHigh;
                int i = rangeIndexLow + 1;
                while (i < rangeIndexHigh) {
                    size += ShortRangeSet.this.range(i).length();
                    ++i;
                }
            }
            return size;
        }

        public short first() {
            short first = ShortRangeSet.this.firstFrom(this.hasLowerBound ? this.lowerBound : (short)0);
            if (this.hasUpperBound && first >= this.upperBound) {
                Exceptions.setNoFirst();
            }
            return first;
        }

        public short last() {
            short last = ShortRangeSet.this.lastFrom(this.hasUpperBound ? (short)(this.upperBound - 1) : ShortRangeSet.this.last());
            if (this.hasLowerBound && last < this.lowerBound) {
                Exceptions.setNoLast();
            }
            return last;
        }

        public ShortSortedSet headSet(short to) {
            if (!this.inSubRange(to)) {
                Exceptions.invalidUpperBound(String.valueOf(to));
            }
            return new SubSet(this.hasLowerBound, this.lowerBound, true, to);
        }

        public ShortSortedSet tailSet(short from) {
            if (!this.inSubRange(from)) {
                Exceptions.invalidLowerBound(String.valueOf(from));
            }
            return new SubSet(true, from, this.hasUpperBound, this.upperBound);
        }

        public ShortSortedSet subSet(short from, short to) {
            if (!this.inSubRange(from)) {
                Exceptions.invalidLowerBound(String.valueOf(from));
            }
            if (!this.inSubRange(to)) {
                Exceptions.invalidUpperBound(String.valueOf(to));
            }
            return new SubSet(true, from, true, to);
        }

        private boolean inSubRange(short v) {
            if (this.hasLowerBound && v < this.lowerBound) {
                return false;
            }
            return !this.hasUpperBound || v < this.upperBound;
        }

        class NonEmptySubSetIterator
        implements ShortIterator {
            short first;
            short last;
            int rangeIndexLow;
            int rangeIndexHigh;
            ShortRange rangeLow;
            ShortRange rangeHigh;
            short previousValue;
            ShortRange currRange;
            int currRangeIndex;
            int currOffset;
            boolean valueAvailable;
            int nextIndex;

            NonEmptySubSetIterator(short first, short last, int rangeIndexLow, int rangeIndexHigh) {
                if (rangeIndexLow == rangeIndexHigh) {
                    throw new RuntimeException("Internal error");
                }
                this.first = first;
                this.last = last;
                this.rangeIndexLow = rangeIndexLow;
                this.rangeIndexHigh = rangeIndexHigh;
                this.rangeLow = new ShortRange(first, ShortRangeSet.this.range(rangeIndexLow).last());
                this.rangeHigh = new ShortRange(ShortRangeSet.this.range(rangeIndexHigh).first(), last);
                this.currRangeIndex = rangeIndexLow;
                this.currRange = this.rangeLow;
                this.currOffset = 0;
                this.previousValue = first;
                this.valueAvailable = false;
                this.nextIndex = 0;
            }

            private ShortRange getRange(int rangeIndex) {
                if (rangeIndex == this.rangeIndexLow) {
                    return this.rangeLow;
                }
                if (rangeIndex == this.rangeIndexHigh) {
                    return this.rangeHigh;
                }
                return ShortRangeSet.this.range(rangeIndex);
            }

            private void recalc() {
                int rs;
                this.first = SubSet.this.first();
                this.last = SubSet.this.last();
                this.rangeIndexLow = ShortRangeSet.this.getRangeIndexOf(this.first);
                this.rangeIndexHigh = ShortRangeSet.this.getRangeIndexOf(this.last);
                if (this.rangeIndexLow == this.rangeIndexHigh) {
                    this.rangeLow = this.rangeHigh = new ShortRange(this.first, this.last);
                } else {
                    this.rangeLow = new ShortRange(this.first, ShortRangeSet.this.range(this.rangeIndexLow).last());
                    this.rangeHigh = new ShortRange(ShortRangeSet.this.range(this.rangeIndexHigh).first(), this.last);
                }
                this.currOffset = this.nextIndex;
                this.currRangeIndex = this.rangeIndexLow;
                this.currRange = this.rangeLow;
                while (this.currOffset >= (rs = this.currRange.length())) {
                    this.currOffset -= rs;
                    this.currRange = this.getRange(++this.currRangeIndex);
                }
            }

            public boolean hasNext() {
                return this.previousValue < this.last;
            }

            public short next() {
                if (!this.hasNext()) {
                    Exceptions.endOfIterator();
                }
                this.previousValue = (short)(this.currRange.first() + this.currOffset++);
                if (this.currOffset == this.currRange.length() && this.previousValue < this.last) {
                    this.currOffset = 0;
                    this.currRange = this.getRange(++this.currRangeIndex);
                }
                ++this.nextIndex;
                this.valueAvailable = true;
                return this.previousValue;
            }

            public void remove() {
                if (!this.valueAvailable) {
                    Exceptions.noElementToRemove();
                }
                ShortRangeSet.this.remove(this.previousValue);
                --this.nextIndex;
                this.recalc();
                this.valueAvailable = false;
            }
        }

        class SimpleSubSetIterator
        implements ShortIterator {
            int nextIndex;
            int size;
            int lastIndex;
            short lastValue;
            short from;
            short to;

            SimpleSubSetIterator(short from, short to) {
                this.size = to - from + 1;
                this.nextIndex = 0;
                this.lastIndex = -1;
                this.from = from;
                this.to = to;
            }

            public boolean hasNext() {
                return this.nextIndex < this.size;
            }

            public short next() {
                if (!this.hasNext()) {
                    Exceptions.endOfIterator();
                }
                this.lastValue = (short)(this.from + this.nextIndex);
                this.lastIndex = this.nextIndex++;
                return this.lastValue;
            }

            public void remove() {
                if (this.lastIndex == -1) {
                    Exceptions.noElementToRemove();
                }
                ShortRangeSet.this.remove(this.lastValue);
                this.lastIndex = -1;
            }
        }

        class EmptySubSetIterator
        implements ShortIterator {
            EmptySubSetIterator() {
            }

            public boolean hasNext() {
                return false;
            }

            public short next() {
                Exceptions.endOfIterator();
                throw new RuntimeException();
            }

            public void remove() {
                Exceptions.noElementToRemove();
            }
        }
    }
}

