/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.DoubleCollection;
import bak.pcj.hash.DefaultBooleanHashFunction;
import bak.pcj.hash.DefaultDoubleHashFunction;
import bak.pcj.map.BooleanKeyDoubleMap;
import bak.pcj.map.BooleanKeyDoubleMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.BooleanSet;
import bak.pcj.util.Exceptions;

public abstract class AbstractBooleanKeyDoubleMap
implements BooleanKeyDoubleMap {
    protected AbstractBooleanKeyDoubleMap() {
    }

    public void clear() {
        BooleanKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public double remove(boolean key) {
        BooleanKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            double value = i.getValue();
            i.remove();
            return value;
        }
        return MapDefaults.defaultDouble();
    }

    public void putAll(BooleanKeyDoubleMap map) {
        BooleanKeyDoubleMapIterator i = map.entries();
        while (i.hasNext()) {
            i.next();
            this.put(i.getKey(), i.getValue());
        }
    }

    public boolean containsKey(boolean key) {
        BooleanKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return true;
        }
        return false;
    }

    public double get(boolean key) {
        BooleanKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return i.getValue();
        }
        return MapDefaults.defaultDouble();
    }

    public boolean containsValue(double value) {
        BooleanKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BooleanKeyDoubleMap)) {
            return false;
        }
        BooleanKeyDoubleMap map = (BooleanKeyDoubleMap)obj;
        if (this.size() != map.size()) {
            return false;
        }
        BooleanKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            boolean k = i.getKey();
            if (map.containsKey(k) && map.lget() == i.getValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        BooleanKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            h += DefaultBooleanHashFunction.INSTANCE.hash(i.getKey()) ^ DefaultDoubleHashFunction.INSTANCE.hash(i.getValue());
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        int size = 0;
        BooleanKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public double tget(boolean key) {
        double value = this.get(key);
        if (value == MapDefaults.defaultDouble() && !this.containsKey(key)) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        BooleanKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            i.next();
            s.append(String.valueOf(i.getKey()));
            s.append("->");
            s.append(String.valueOf(i.getValue()));
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public abstract DoubleCollection values();

    public abstract double put(boolean var1, double var2);

    public abstract double lget();

    public abstract BooleanSet keySet();

    public abstract BooleanKeyDoubleMapIterator entries();
}

