/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.util.z3950.provider.GN;

import java.util.List;
import java.util.Observer;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.NotImplementedException;
import org.fao.geonet.kernel.search.MetaSearcher;
import org.fao.geonet.services.util.z3950.GNXMLQuery;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.DOMOutputter;
import org.jzkit.search.util.RecordModel.ExplicitRecordFormatSpecification;
import org.jzkit.search.util.RecordModel.InformationFragment;
import org.jzkit.search.util.RecordModel.InformationFragmentImpl;
import org.jzkit.search.util.RecordModel.RecordFormatSpecification;
import org.jzkit.search.util.ResultSet.AbstractIRResultSet;
import org.jzkit.search.util.ResultSet.IFSNotificationTarget;
import org.jzkit.search.util.ResultSet.IRResultSet;
import org.jzkit.search.util.ResultSet.IRResultSetException;
import org.jzkit.search.util.ResultSet.IRResultSetInfo;

public class GNResultSet
extends AbstractIRResultSet
implements IRResultSet {
    private GNXMLQuery query;
    private ServiceContext srvxtx;
    private int status;
    private int fragmentcount;
    private MetaSearcher metasearcher;
    public static final String SEARCH_Z3950_SERVER = "z3950Server.xsl";

    public GNResultSet(GNXMLQuery query, Object userInfo, Observer[] observers, ServiceContext srvctx) throws Exception {
        super(observers);
        this.query = query;
        this.srvxtx = srvctx;
        throw new NotImplementedException("Z39.50 not implemented in ES");
    }

    public int evaluate(int timeout) {
        try {
            if (Log.isDebugEnabled((String)"geonetwork.sru")) {
                Log.debug((String)"geonetwork.sru", (Object)("INCOMING XML QUERY:\n" + this.query));
            }
            Element request = new Element("request");
            request.addContent((Content)this.query.toGNXMLRep());
            List<String> categories = this.query.getCollections();
            for (String category : categories) {
                if (category.equals("geonetwork") || category.equals("Default")) continue;
                request.addContent((Content)new Element("category").setText(category));
            }
            ServiceConfig config = new ServiceConfig();
            this.metasearcher.search(this.srvxtx, request, config);
            this.setFragmentCount(this.metasearcher.getSize());
            this.setTaskStatusCode(4);
        }
        catch (Throwable e) {
            Log.error((String)"geonetwork.sru", (String)("error evaluating query.." + e.getMessage()), (Throwable)e);
        }
        return this.getStatus();
    }

    public InformationFragment[] getFragment(int startingFragment, int count, RecordFormatSpecification spec) throws IRResultSetException {
        InformationFragment[] fragment;
        block9: {
            if (Log.isDebugEnabled((String)"geonetwork.sru")) {
                Log.debug((String)"geonetwork.sru", (Object)("Request for fragment start:" + startingFragment + ", count:" + count));
            }
            fragment = new InformationFragment[count];
            ExplicitRecordFormatSpecification rec_spec = new ExplicitRecordFormatSpecification("xml", null, "f");
            try {
                int from = startingFragment;
                int to = startingFragment + count - 1;
                Element request = new Element("request");
                request.addContent((Content)new Element("from").setText("" + from));
                request.addContent((Content)new Element("to").setText("" + to));
                ServiceConfig config = new ServiceConfig();
                if (Log.isDebugEnabled((String)"geonetwork.sru")) {
                    Log.debug((String)"geonetwork.sru", (Object)("Search request:\n" + Xml.getString((Element)request)));
                }
                Element result = this.metasearcher.present(this.srvxtx, request, config);
                if (Log.isDebugEnabled((String)"geonetwork.sru")) {
                    Log.debug((String)"geonetwork.sru", (Object)("Search result:\n" + Xml.getString((Element)result)));
                }
                result.removeChildren("summary");
                List list = result.getChildren();
                if (Log.isDebugEnabled((String)"geonetwork.sru")) {
                    Log.debug((String)"geonetwork.sru", (Object)("Set name asked:" + spec));
                }
                for (int i = 0; i < count; ++i) {
                    Element md = (Element)list.get(0);
                    md.detach();
                    if (Log.isDebugEnabled((String)"geonetwork.sru")) {
                        Log.debug((String)"geonetwork.sru", (Object)("Returning fragment:\n" + Xml.getString((Element)md)));
                    }
                    DOMOutputter outputter = new DOMOutputter();
                    Document doc = new Document(md);
                    org.w3c.dom.Document doc2 = outputter.output(doc);
                    fragment[i] = new InformationFragmentImpl((long)(startingFragment + i), "geonetwork", "geonetwork", null, (Object)doc2, rec_spec);
                }
                if (Log.isDebugEnabled((String)"geonetwork.sru")) {
                    Log.debug((String)"geonetwork.sru", (Object)"Fragment returned");
                }
            }
            catch (Throwable e) {
                if (!Log.isDebugEnabled((String)"geonetwork.sru")) break block9;
                Log.debug((String)"geonetwork.sru", (Object)("Exception: " + e.getClass().getName() + " " + e));
            }
        }
        return fragment;
    }

    public void asyncGetFragment(int starting_fragment, int count, RecordFormatSpecification spec, IFSNotificationTarget target) throws IRResultSetException {
        InformationFragment[] result = this.getFragment(starting_fragment, count, spec);
        target.notifyRecords(result);
    }

    public void close() {
        this.metasearcher.close();
    }

    private void setTaskStatusCode(int i) {
        this.status = i;
    }

    public int getFragmentCount() {
        return this.fragmentcount;
    }

    private void setFragmentCount(int i) {
        this.fragmentcount = i;
    }

    public int getRecordAvailableHWM() {
        return this.getFragmentCount();
    }

    public IRResultSetInfo getResultSetInfo() {
        return new IRResultSetInfo("GNDefault", this.fragmentcount, this.status);
    }
}

