/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.resources;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import javax.servlet.ServletContext;
import jeeves.server.context.ServiceContext;
import org.apache.commons.io.FilenameUtils;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.resources.Resources;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Log;

public class FileResources
extends Resources {
    @Override
    @Nullable
    protected Path findImagePath(String imageName, Path logosDir) throws IOException {
        if (imageName.indexOf(46) > -1) {
            Path imagePath = logosDir.resolve(imageName);
            if (Files.exists(imagePath, new LinkOption[0])) {
                return imagePath;
            }
        } else {
            try (DirectoryStream<Path> possibleLogos = Files.newDirectoryStream(logosDir, imageName + ".*");){
                for (Path next : possibleLogos) {
                    String ext = FilenameUtils.getExtension((String)next.getFileName().toString());
                    if (!IMAGE_EXTENSIONS.contains(ext.toLowerCase())) continue;
                    Path path = next;
                    return path;
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Resources.ResourceHolder getImage(ServiceContext context, String imageName, Path logosDir) throws IOException {
        Path path = this.findImagePath(imageName, logosDir);
        if (path != null) {
            return new FileResourceHolder(this.getBasePath(context), path);
        }
        return null;
    }

    @Override
    Pair<byte[], Long> loadResource(Path resourcesDir, ServletContext context, Path appPath, String filename, byte[] defaultValue, long loadSince) throws IOException {
        Path file = this.locateResource(resourcesDir, context, appPath, filename);
        if (Files.exists(file, new LinkOption[0])) {
            try {
                long lastModified = Files.getLastModifiedTime(file, new LinkOption[0]).to(TimeUnit.MILLISECONDS);
                if (loadSince < 0L || lastModified > loadSince) {
                    ByteArrayOutputStream data = new ByteArrayOutputStream();
                    Files.copy(file, data);
                    return Pair.read((Object)data.toByteArray(), (Object)lastModified);
                }
                return Pair.read((Object)defaultValue, (Object)loadSince);
            }
            catch (IOException e) {
                Log.warning((String)"geonetwork.resources", (Object)("Unable to find resource: " + filename));
            }
        }
        return Pair.read((Object)defaultValue, (Object)-1L);
    }

    @Override
    public Resources.ResourceHolder getWritableImage(ServiceContext context, String imageName, Path logosDir) {
        try {
            Files.createDirectories(logosDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Path path = logosDir.resolve(imageName);
        return new FileResourceHolder(this.getBasePath(context), path);
    }

    @Override
    protected Path locateResource(@Nullable Path resourcesDir, ServletContext context, Path appPath, @Nonnull String filename) throws IOException {
        Path file;
        block27: {
            if (filename.charAt(0) == '/' || filename.charAt(0) == '\\') {
                filename = filename.substring(1);
            }
            if (!Files.exists(file = resourcesDir != null ? resourcesDir.resolve(filename) : IO.toPath((String)filename, (String[])new String[0]), new LinkOption[0])) {
                String realPath;
                Path webappCopy = null;
                if (context != null && (realPath = context.getRealPath(filename)) != null) {
                    webappCopy = IO.toPath((String)realPath, (String[])new String[0]);
                }
                if (webappCopy == null) {
                    webappCopy = appPath.resolve(filename);
                }
                if (Files.exists(webappCopy, new LinkOption[0])) {
                    IO.copyDirectoryOrFile((Path)webappCopy, (Path)file, (boolean)false);
                }
                String fileName = file.getFileName().toString();
                int indexOfDot = fileName.lastIndexOf(".");
                String suffixless = FilenameUtils.removeExtension((String)fileName);
                String suffix = FilenameUtils.getExtension((String)fileName);
                if (!Files.exists(file, new LinkOption[0]) && IMAGE_WRITE_SUFFIXES.contains(suffix.toLowerCase())) {
                    DirectoryStream.Filter<Path> filter = entry -> {
                        String name = entry.getFileName().toString();
                        boolean startsWith = name.startsWith(suffixless);
                        String ext = FilenameUtils.getExtension((String)name).toLowerCase();
                        boolean canReadImage = name.length() > indexOfDot && IMAGE_READ_SUFFIXES.contains(ext);
                        return startsWith && canReadImage;
                    };
                    try (DirectoryStream<Path> paths = Files.newDirectoryStream(file.getParent(), filter);){
                        Iterator<Path> iter = paths.iterator();
                        if (!iter.hasNext()) break block27;
                        Path path = iter.next();
                        try (InputStream in = IO.newInputStream((Path)path);
                             OutputStream out = Files.newOutputStream(file, new OpenOption[0]);){
                            try {
                                BufferedImage image = ImageIO.read(in);
                                ImageIO.write((RenderedImage)image, suffix, out);
                            }
                            catch (IOException e) {
                                if (context != null) {
                                    context.log("Unable to convert image from " + path + " to " + file, (Throwable)e);
                                }
                            }
                        }
                    }
                }
            }
        }
        return file;
    }

    @Override
    protected void addFiles(DirectoryStream.Filter<Path> iconFilter, Path webappDir, HashSet<Path> result) {
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(webappDir, iconFilter);){
            for (Path file : paths) {
                result.add(file);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public FileTime getLastModified(Path resourcesDir, ServletContext context, Path appPath, String filename) throws IOException {
        Path file = this.locateResource(resourcesDir, context, appPath, filename);
        if (file != null && Files.exists(file, new LinkOption[0])) {
            return Files.getLastModifiedTime(file, new LinkOption[0]);
        }
        return null;
    }

    @Override
    public void deleteImageIfExists(String image, Path dir) throws IOException {
        Path icon = this.findImagePath(image, dir);
        if (icon != null) {
            Files.deleteIfExists(icon);
        }
    }

    private static class FileResourceHolder
    implements Resources.ResourceHolder {
        private String relativePath;
        private final Path path;

        private FileResourceHolder(Path basePath, Path path) {
            this.relativePath = basePath.relativize(path).toString().replace('\\', '/');
            this.path = path;
        }

        @Override
        public Path getPath() {
            return this.path;
        }

        @Override
        public String getRelativePath() {
            return this.relativePath;
        }

        @Override
        public FileTime getLastModifiedTime() throws IOException {
            return Files.getLastModifiedTime(this.path, new LinkOption[0]);
        }

        @Override
        public void abort() {
            IO.deleteFile((Path)this.getPath(), (boolean)false, (String)"geonetwork");
        }

        @Override
        public void close() {
        }

        public String toString() {
            return this.path.toString();
        }
    }
}

